/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;

public abstract class RdbWrapper {
    private volatile Object model;
    private static final boolean log_messages = false;
    static /* synthetic */ Class class$0;

    RdbWrapper() {
        this.initialize();
    }

    RdbWrapper(Object modelObject) {
        this();
        this.initializeFromModel(modelObject);
    }

    protected void initializeFromModel(Object modelObject) {
        this.setModel(modelObject);
    }

    protected void initialize() {
    }

    protected void initialize(Object newModel) {
        this.setModel(newModel);
    }

    protected static Collection wrapAll(Iterator modelIterator, final Class wrapperClass) {
        TransformationIterator iterator = new TransformationIterator(modelIterator){

            protected Object transform(Object next) {
                return RdbWrapper.wrap(next, wrapperClass);
            }
        };
        return CollectionTools.collection((Iterator)iterator);
    }

    protected static Collection wrapAll(Collection modelObjects, Class wrapperClass) {
        return RdbWrapper.wrapAll(modelObjects.iterator(), wrapperClass);
    }

    private static RdbWrapper wrap(Object modelObject, Class wrapperClass) {
        if (modelObject == null) {
            return null;
        }
        Constructor wrapperConstructor = RdbWrapper.wrapperConstructorFor(modelObject, wrapperClass);
        return RdbWrapper.buildWrapperWith(wrapperConstructor, new Object[]{modelObject});
    }

    protected Collection wrapAllModels(Collection modelObjects, Class wrapperClass) {
        return RdbWrapper.wrapAll(modelObjects.iterator(), wrapperClass);
    }

    protected Collection wrapAllModels(Iterator modelIterator, Class wrapperClass) {
        return RdbWrapper.wrapAll(modelIterator, wrapperClass);
    }

    private static final RdbWrapper buildWrapperWith(Constructor wrapperConstructor, Object[] parameters) {
        RdbWrapper newWrapper = null;
        try {
            newWrapper = (RdbWrapper)wrapperConstructor.newInstance(parameters);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("InvocationTarget Exception When Instantiating " + wrapperConstructor.getName(), ite);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Instantiation Exception When Instantiating " + wrapperConstructor.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal Access Exception When Instantiating " + wrapperConstructor.getName(), iae);
        }
        return newWrapper;
    }

    private static final Constructor wrapperConstructorFor(Object modelObject, Class wrapperClass) {
        Class<?> modelClass = modelObject.getClass();
        return RdbWrapper.wrapperConstructorFor(modelClass, wrapperClass, 1);
    }

    private static final Constructor wrapperConstructorFor(Class modelClass, Class wrapperClass, int numberOfConstructorParameter) {
        ArrayIterator i = new ArrayIterator((Object[])wrapperClass.getDeclaredConstructors());
        while (i.hasNext()) {
            Constructor wrapperConstructor = (Constructor)i.next();
            Class<?>[] parameters = wrapperConstructor.getParameterTypes();
            if (parameters.length != numberOfConstructorParameter) continue;
            if (parameters.length == 2 && parameters[0].isAssignableFrom(RdbWrapper.class) && parameters[1].isAssignableFrom(modelClass)) {
                return wrapperConstructor;
            }
            if (parameters.length == 1 && parameters[0].isAssignableFrom(RdbWrapper.class)) {
                return wrapperConstructor;
            }
            if (parameters.length != 0) continue;
            return wrapperConstructor;
        }
        throw new NoSuchElementException("No Valid Constructor Found for: " + wrapperClass.getName());
    }

    protected Object getModel() {
        return this.model;
    }

    private final void setModel(Object model) {
        this.model = model;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)this, (StringBuffer)sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    protected void log(String message) {
    }

    public void toString(StringBuffer sb) {
    }

    public boolean equals(RdbWrapper wrapper) {
        return this.getModel() == wrapper.getModel();
    }

    public boolean wraps(Object modelObject) {
        return this.getModel() == modelObject;
    }

    public boolean isNull() {
        return false;
    }
}

