/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.List;
import org.eclipse.dali.core.AttributeOverride;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.adapters.IColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeOverrideAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaAttributeOverrideColumnModelAdapter
implements IColumnModelAdapter {
    private Column column;
    private Member member;

    void engage(Column column, Member member, CompilationUnit astRoot) {
        this.column = column;
        this.member = member;
        this.updatePersModel(astRoot);
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersSpecifiedName(astRoot);
        this.updatePersDefaultName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        String javaValue = this.javaValue(astRoot);
        String persValue = this.column.getSpecifiedName();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.column.setSpecifiedName(javaValue);
        }
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private String defaultName() {
        AttributeOverride attributeOverride = (AttributeOverride)this.column.getParent();
        return attributeOverride.getName();
    }

    private String javaValue(CompilationUnit astRoot) {
        return ASTTools.stringValue(this.columnNameValuePair(this.member.bodyDeclaration(astRoot)));
    }

    private MemberValuePair columnNameValuePair(BodyDeclaration bodyDeclaration) {
        Expression columnAnnotation;
        MemberValuePair columnValuePair = this.columnValuePair(bodyDeclaration);
        if (columnValuePair != null && (columnAnnotation = columnValuePair.getValue()).getNodeType() == 77) {
            return ASTTools.getMemberValuePair((NormalAnnotation)columnAnnotation, "name");
        }
        return null;
    }

    private MemberValuePair columnValuePair(BodyDeclaration bodyDeclaration) {
        Annotation attributeOverrideAnnotation = this.getAttributeOverrideAnnotation(bodyDeclaration);
        if (attributeOverrideAnnotation != null) {
            return ASTTools.getMemberValuePair(attributeOverrideAnnotation, "column");
        }
        return null;
    }

    private Annotation getAttributeOverrideAnnotation(BodyDeclaration bodyDeclaration) {
        return ((JavaAttributeOverrideAdapter)this.getAttributeOverride().getModelAdapter()).getAttributeOverrideAnnotation(bodyDeclaration);
    }

    public void specifiedNameChanged() {
        String javaName = this.javaValue(this.member.createASTRoot());
        String persName = this.column.getSpecifiedName();
        if (persName == null && javaName != null) {
            this.removeAttributeOverrideAnnotation();
        }
        if (persName != null && !persName.equals(javaName)) {
            this.setJavaValue(persName);
        }
    }

    private void removeAttributeOverrideAnnotation() {
        this.member.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation attributeOverrideAnnotation = JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                ASTNode parent = attributeOverrideAnnotation.getParent();
                if (parent instanceof MemberValuePair) {
                    MemberValuePair valuePair = (MemberValuePair)parent;
                    if ((parent = valuePair.getParent()) instanceof NormalAnnotation) {
                        List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                        list.remove(valuePair);
                        if (list.isEmpty()) {
                            ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                        }
                    }
                } else if (parent == bodyDeclaration) {
                    ASTTools.removeAnnotation(bodyDeclaration, attributeOverrideAnnotation);
                } else if (parent instanceof NormalAnnotation) {
                    List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                    }
                } else if (parent instanceof ArrayInitializer) {
                    List list = (List)((ArrayInitializer)parent).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        if ((parent = parent.getParent()).getNodeType() == 80) {
                            parent = parent.getParent();
                        }
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)parent);
                    }
                }
            }
        });
    }

    private void setJavaValue(final String javaValue) {
        this.member.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Expression columnAnnotation;
                MemberValuePair columnNameValuePair;
                AST ast = bodyDeclaration.getAST();
                MemberValuePair columnValuePair = JavaAttributeOverrideColumnModelAdapter.this.columnValuePair(bodyDeclaration);
                if (columnValuePair == null) {
                    NormalAnnotation attributeOverrideAnnotation = (NormalAnnotation)JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                    if (attributeOverrideAnnotation == null) {
                        attributeOverrideAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "AttributeOverride");
                        ASTTools.addLiteralMemberValuePair(attributeOverrideAnnotation, "name", JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverride().getName());
                        Annotation existingAnnotation = ASTTools.getAnnotation(bodyDeclaration, "AttributeOverride");
                        if (existingAnnotation != null) {
                            SingleMemberAnnotation overridesAnnotation = ASTTools.newSingleMemberAnnotation(ast, "AttributeOverrides");
                            ArrayInitializer array = ast.newArrayInitializer();
                            List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                            ASTTools.removeAnnotation(bodyDeclaration, existingAnnotation);
                            list.add(existingAnnotation);
                            list.add(attributeOverrideAnnotation);
                            overridesAnnotation.setValue((Expression)array);
                            ASTTools.addAnnotation(bodyDeclaration, (Annotation)overridesAnnotation);
                        } else {
                            existingAnnotation = ASTTools.getAnnotation(bodyDeclaration, "AttributeOverrides");
                            if (existingAnnotation != null) {
                                if (existingAnnotation.isSingleMemberAnnotation()) {
                                    Expression expression = ((SingleMemberAnnotation)existingAnnotation).getValue();
                                    if (expression.getNodeType() == 4) {
                                        ((List)((ArrayInitializer)expression).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                                    } else {
                                        ArrayInitializer array = ast.newArrayInitializer();
                                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                                        ((SingleMemberAnnotation)existingAnnotation).setValue((Expression)array);
                                        list.add(expression);
                                        list.add(attributeOverrideAnnotation);
                                    }
                                } else if (existingAnnotation.isNormalAnnotation()) {
                                    Expression existingValue;
                                    MemberValuePair valuePair = ASTTools.getMemberValuePair((NormalAnnotation)existingAnnotation, "value");
                                    if (valuePair == null) {
                                        valuePair = ast.newMemberValuePair();
                                        valuePair.setName(ast.newSimpleName("value"));
                                        ASTTools.addValuePair((NormalAnnotation)existingAnnotation, valuePair);
                                    }
                                    if ((existingValue = valuePair.getValue()) != null && existingValue.getNodeType() == 4) {
                                        ((List)((ArrayInitializer)existingValue).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                                    } else {
                                        ArrayInitializer array = ast.newArrayInitializer();
                                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                                        valuePair.setValue((Expression)array);
                                        if (existingValue != null) {
                                            list.add(existingValue);
                                        }
                                        list.add(attributeOverrideAnnotation);
                                    }
                                }
                            } else {
                                ASTTools.addAnnotation(bodyDeclaration, (Annotation)attributeOverrideAnnotation);
                            }
                        }
                    }
                    columnValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnValuePair.setName(bodyDeclaration.getAST().newSimpleName("column"));
                    ASTTools.addValuePair(attributeOverrideAnnotation, columnValuePair);
                    NormalAnnotation columnAnnotation2 = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "Column");
                    columnValuePair.setValue((Expression)columnAnnotation2);
                }
                if ((columnNameValuePair = ASTTools.getMemberValuePair((Annotation)(columnAnnotation = columnValuePair.getValue()), "name")) == null) {
                    columnNameValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnNameValuePair.setName(bodyDeclaration.getAST().newSimpleName("name"));
                    ASTTools.addValuePair((NormalAnnotation)columnAnnotation, columnNameValuePair);
                }
                columnNameValuePair.setValue((Expression)ASTTools.newStringLiteral(bodyDeclaration.getAST(), javaValue));
            }
        });
    }

    public void specifiedTableNameChanged() {
    }

    private AttributeOverride getAttributeOverride() {
        return (AttributeOverride)this.column.getParent();
    }

    public ITextRange getTextRange() {
        return ASTTools.getTextRange((ASTNode)this.columnValuePair(this.member.bodyDeclaration()));
    }

    public ITextRange nameTextRange() {
        return ASTTools.getTextRange((ASTNode)this.columnNameValuePair(this.member.bodyDeclaration()));
    }

    public ITextRange tableNameTextRange() {
        return null;
    }
}

