/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.GeneratedValue;
import org.eclipse.dali.core.GeneratorType;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.JavaIdModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaGeneratedValueModelAdapter
implements IGeneratedValueModelAdapter {
    private JavaIdModelAdapter parent;
    private GeneratedValue generatedValue;
    private EnumAnnotationElementAdapter strategyAdapter;
    private StringAnnotationElementAdapter specifiedGeneratorNameAdapter;

    public JavaGeneratedValueModelAdapter(JavaIdModelAdapter parent) {
        this.parent = parent;
        this.strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
        this.specifiedGeneratorNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedGeneratorNameInfo());
    }

    public GeneratedValue buildGeneratedValue() {
        this.generatedValue = DaliFactory.eINSTANCE.createGeneratedValue(this);
        return this.generatedValue;
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            /*
             * WARNING - void declaration
             */
            public void setPersValue(String generatorType) {
                void var2_2;
                GeneratorType genType;
                if (generatorType == null) {
                    return;
                }
                if (generatorType.equals("AUTO")) {
                    genType = GeneratorType.AUTO_LITERAL;
                } else if (generatorType.equals("SEQUENCE")) {
                    genType = GeneratorType.SEQUENCE_LITERAL;
                } else if (generatorType.equals("IDENTITY")) {
                    genType = GeneratorType.IDENTITY_LITERAL;
                } else if (generatorType.equals("TABLE")) {
                    genType = GeneratorType.TABLE_LITERAL;
                } else if (generatorType.equals(GeneratorType.DEFAULT_LITERAL.getName())) {
                    genType = GeneratorType.DEFAULT_LITERAL;
                } else {
                    return;
                }
                JavaGeneratedValueModelAdapter.this.getGeneratedValue().setStrategy((GeneratorType)var2_2);
            }

            public String persValue() {
                GeneratorType genType = JavaGeneratedValueModelAdapter.this.getGeneratedValue().getStrategy();
                switch (genType.getValue()) {
                    case 1: {
                        return "AUTO";
                    }
                    case 2: {
                        return "SEQUENCE";
                    }
                    case 3: {
                        return "IDENTITY";
                    }
                    case 4: {
                        return "TABLE";
                    }
                    case 0: {
                        return GeneratorType.DEFAULT_LITERAL.getName();
                    }
                }
                return null;
            }

            public String enumClassName() {
                return GENERATOR_TYPE;
            }

            public String annotationElementName() {
                return "strategy";
            }

            public String annotationName() {
                return "GeneratedValue";
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.parent.getAttribute();
            }

            public String defaultValue() {
                return GeneratorType.DEFAULT_LITERAL.getName();
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedGeneratorNameInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaGeneratedValueModelAdapter.this.getGeneratedValue().setSpecifiedGeneratorName(newValue);
            }

            public String persValue() {
                return JavaGeneratedValueModelAdapter.this.getGeneratedValue().getSpecifiedGeneratorName();
            }

            public String annotationElementName() {
                return "generator";
            }

            public String annotationName() {
                return "GeneratedValue";
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.parent.getAttribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
        this.updatePersSpecifiedGeneratorName(astRoot);
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        if (this.strategyAdapter.updatePersElement(astRoot)) {
            this.parent.updatePersGenerator(astRoot);
        }
    }

    public void specifiedGeneratorNameChanged() {
        this.updateJavaSpecifiedGeneratorName();
    }

    private void updateJavaSpecifiedGeneratorName() {
        this.specifiedGeneratorNameAdapter.updateJavaElement();
    }

    private void updatePersSpecifiedGeneratorName(CompilationUnit astRoot) {
        this.specifiedGeneratorNameAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        this.updateJavaGeneratorType();
    }

    private void updateJavaGeneratorType() {
        if (this.strategyAdapter.updateJavaElement()) {
            this.parent.strategyChanged();
        }
    }

    public ITextRange getTextRange() {
        return null;
    }

    GeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }
}

