/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.JoinTable;
import org.eclipse.dali.core.ManyToMany;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.adapters.IJoinTableModelAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaInverseJoinColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaJoinColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;

public class JavaJoinTableModelAdapter
extends JavaTableModelAdapter
implements IJoinTableModelAdapter {
    static final String JOIN_TABLE_ANNOTATION = "JoinTable";
    static final String JOIN_COLUMNS_MEMBER = "joinColumns";
    static final String INVERSE_JOIN_COLUMNS_MEMBER = "inverseJoinColumns";
    private JavaJoinColumnModelAdapter joinColumnModelAdapter = new JavaJoinColumnModelAdapter(this.buildJoinColumnOwner());
    private JavaInverseJoinColumnModelAdapter inverseJoinColumnModelAdapter = new JavaInverseJoinColumnModelAdapter(this.buildJoinColumnOwner());

    JavaJoinTableModelAdapter() {
    }

    private JavaJoinColumnModelAdapter.JoinColumnOwner buildJoinColumnOwner() {
        return new JavaJoinColumnModelAdapter.JoinColumnOwner(){

            public ReferencePersistentAttributeFlavor referenceMapping() {
                return (ManyToMany)JavaJoinTableModelAdapter.this.getJoinTable().getParent();
            }
        };
    }

    public void engage(Table table, CompilationUnit astRoot) {
        if (!(table instanceof JoinTable)) {
            throw new IllegalArgumentException();
        }
        Attribute attribute = ((JavaPersistentAttributeFlavorModelAdapter)((ManyToMany)table.getParent()).getModelAdapter()).getAttribute();
        JoinColumn column = this.joinColumnModelAdapter.buildJoinColumn(attribute);
        ((JoinTable)table).getJoinColumns().add((Object)column);
        JoinColumn inverseJoinColumn = this.inverseJoinColumnModelAdapter.buildJoinColumn(attribute);
        ((JoinTable)table).getInverseJoinColumns().add((Object)inverseJoinColumn);
        super.engage(table, astRoot);
    }

    void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersDefaultJoinColumns(astRoot);
        this.updatePersDefaultInverseJoingColumns(astRoot);
        this.joinColumnModelAdapter.updatePersModel(astRoot);
        this.inverseJoinColumnModelAdapter.updatePersModel(astRoot);
    }

    private void updatePersDefaultJoinColumns(CompilationUnit astRoot) {
        MemberValuePair memberValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, JOIN_COLUMNS_MEMBER, astRoot);
        if (memberValuePair == null) {
            if (!this.getJoinTable().isDefaultJoinColumns()) {
                this.getJoinTable().setDefaultJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultJoinColumns()) {
            this.getJoinTable().setDefaultJoinColumns(false);
        }
    }

    private void updatePersDefaultInverseJoingColumns(CompilationUnit astRoot) {
        MemberValuePair memberValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, INVERSE_JOIN_COLUMNS_MEMBER, astRoot);
        if (memberValuePair == null) {
            if (!this.getJoinTable().isDefaultInverseJoinColumns()) {
                this.getJoinTable().setDefaultInverseJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultInverseJoinColumns()) {
            this.getJoinTable().setDefaultInverseJoinColumns(false);
        }
    }

    protected String annotationName() {
        return JOIN_TABLE_ANNOTATION;
    }

    private JoinTable getJoinTable() {
        return (JoinTable)this.getTable();
    }

    protected String defaultName() {
        Table owningTable = this.getManyToMany().getPersistentTypeFlavor().getTable();
        Entity targetEntity = this.getManyToMany().getResolvedTargetEntity();
        if (targetEntity != null) {
            Table table = targetEntity.getTable();
            if (owningTable != null && table != null) {
                return String.valueOf(owningTable.getName()) + "_" + table.getName();
            }
        }
        return "";
    }

    private ManyToMany getManyToMany() {
        return (ManyToMany)this.getJoinTable().eContainer();
    }

    protected Member member() {
        return ((JavaPersistentAttributeModelAdapter)this.getManyToMany().getPersistentAttribute().getModelAdapter()).getAttribute();
    }

    public void defaultJoinColumnsChanged() {
    }

    public void defaultInverseJoinColumnsChanged() {
    }
}

