/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.TableGenerator;
import org.eclipse.dali.orm.Temporal;
import org.eclipse.dali.orm.TemporalType;
import org.eclipse.dali.orm.provider.IdMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.TemporalItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.GeneratedValueComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.SequenceGeneratorComposite;
import org.eclipse.dali.ui.views.TableGeneratorComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class IdMappingComposite
extends Composite
implements IPersistenceComposite {
    private ColumnComposite columnComposite;
    private Button primaryKeyGenerationCheckBox;
    private GeneratedValueComposite generatedValueComposite;
    private ExpandableComposite tableGenExpandableComposite;
    private Button tableGeneratorCheckBox;
    private TableGeneratorComposite tableGeneratorComposite;
    private ExpandableComposite sequenceGenExpandableComposite;
    private Button sequenceGeneratorCheckBox;
    private SequenceGeneratorComposite sequenceGeneratorComposite;
    private TemporalItemProvider temporalItemProvider;
    private Button temporalCheckBox;
    private ComboViewer temporalTypeComboViewer;
    private INotifyChangedListener temporalListener;
    private IdMapping idMapping;
    private INotifyChangedListener mappingListener;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private IdMappingItemProvider mappingItemProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    IdMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.mappingItemProvider = (IdMappingItemProvider)this.adapterFactory.createIdMappingAdapter();
        this.temporalItemProvider = (TemporalItemProvider)this.adapterFactory.createTemporalAdapter();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.IdMappingComposite_general);
        generalTab.setControl(generalControl);
        Control generationControl = this.buildGenerationTab(folder);
        TabItem generationTab = new TabItem(folder, 0);
        generationTab.setText(DaliUiMessages.IdMappingComposite_pk_generation);
        generationTab.setControl(generationControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.columnComposite = new ColumnComposite(composite, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        this.temporalCheckBox = this.buildTemporalCheckBox(composite);
        this.temporalTypeComboViewer = this.buildTemporalCombo(composite);
        this.temporalTypeComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.temporalTypeComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_temporal");
        return composite;
    }

    protected SharedScrolledComposite getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof SharedScrolledComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof SharedScrolledComposite) {
            return (SharedScrolledComposite)parent;
        }
        return null;
    }

    private Control buildGenerationTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.primaryKeyGenerationCheckBox = this.buildPrimaryKeyGenerationCheckBox(composite);
        GridData gridData = new GridData();
        this.primaryKeyGenerationCheckBox.setLayoutData((Object)gridData);
        this.generatedValueComposite = new GeneratedValueComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.generatedValueComposite.setLayoutData(gridData);
        this.tableGenExpandableComposite = new ExpandableComposite(composite, 0, 18);
        this.tableGenExpandableComposite.setText(DaliUiMessages.IdMappingComposite_tableGenerator);
        this.tableGenExpandableComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.tableGenExpandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                IdMappingComposite.this.getParentScrolledComposite((Control)IdMappingComposite.this.tableGenExpandableComposite).reflow(true);
            }
        });
        Composite tableGenClient = new Composite((Composite)this.tableGenExpandableComposite, 0);
        tableGenClient.setLayout((Layout)new GridLayout());
        this.tableGenExpandableComposite.setClient((Control)tableGenClient);
        this.tableGeneratorCheckBox = this.buildTableGeneratorCheckBox(tableGenClient);
        gridData = new GridData();
        this.tableGeneratorCheckBox.setLayoutData((Object)gridData);
        this.tableGeneratorComposite = new TableGeneratorComposite(tableGenClient, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.tableGeneratorComposite.setLayoutData(gridData);
        this.sequenceGenExpandableComposite = new ExpandableComposite(composite, 0, 18);
        this.sequenceGenExpandableComposite.setText(DaliUiMessages.IdMappingComposite_sequenceGenerator);
        this.sequenceGenExpandableComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.sequenceGenExpandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                IdMappingComposite.this.getParentScrolledComposite((Control)IdMappingComposite.this.sequenceGenExpandableComposite).reflow(true);
            }
        });
        Composite sequenceGenClient = new Composite((Composite)this.sequenceGenExpandableComposite, 0);
        sequenceGenClient.setLayout((Layout)new GridLayout());
        this.sequenceGenExpandableComposite.setClient((Control)sequenceGenClient);
        this.sequenceGeneratorCheckBox = this.buildSequenceGeneratorCheckBox(sequenceGenClient);
        gridData = new GridData();
        this.sequenceGeneratorCheckBox.setLayoutData((Object)gridData);
        this.sequenceGeneratorComposite = new SequenceGeneratorComposite(sequenceGenClient, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.sequenceGeneratorComposite.setLayoutData(gridData);
        return composite;
    }

    private Button buildTemporalCheckBox(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(DaliUiMessages.BasicMappingComposite_temporal);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdMappingComposite.this.temporalCheckBoxClicked(e);
            }
        });
        return button;
    }

    void temporalCheckBoxClicked(SelectionEvent e) {
        boolean mappingHasTemporal = this.idMapping.getTemporal() != null;
        boolean checked = this.temporalCheckBox.getSelection();
        if (checked == mappingHasTemporal) {
            return;
        }
        Temporal temporal = null;
        if (checked) {
            temporal = this.idMapping.getIdMappingModelAdapter().createTemporalModelAdapter(null).getTemporal();
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping, (Object)OrmPackage.eINSTANCE.getIdMapping_Temporal(), (Object)temporal));
    }

    private ComboViewer buildTemporalCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(TemporalType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IdMappingComposite.this.temporalTypeSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void temporalTypeSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            TemporalType sel = (TemporalType)((IStructuredSelection)selection).getFirstElement();
            TemporalType tt = null;
            Temporal temporal = this.idMapping.getTemporal();
            if (temporal != null) {
                tt = temporal.getType();
            }
            if (temporal != null && tt != sel) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)temporal, (Object)OrmPackage.eINSTANCE.getTemporal_Type(), (Object)sel));
            }
        }
    }

    private Button buildPrimaryKeyGenerationCheckBox(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(DaliUiMessages.IdMappingComposite_primaryKeyGeneration);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdMappingComposite.this.primaryKeyGenerationCheckBoxClicked(e);
            }
        });
        return button;
    }

    void primaryKeyGenerationCheckBoxClicked(SelectionEvent e) {
        boolean mappingHasGeneratedValue = this.idMapping.getGeneratedValue() != null;
        boolean checked = this.primaryKeyGenerationCheckBox.getSelection();
        if (checked == mappingHasGeneratedValue) {
            return;
        }
        GeneratedValue generatedValue = null;
        if (checked) {
            generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(this.idMapping.getIdMappingModelAdapter().createGeneratedValueModelAdapter());
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping, (Object)OrmPackage.eINSTANCE.getIdMapping_GeneratedValue(), (Object)generatedValue));
    }

    private Button buildTableGeneratorCheckBox(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(DaliUiMessages.IdMappingComposite_tableGenerator);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdMappingComposite.this.tableGeneratorCheckBoxClicked(e);
            }
        });
        return button;
    }

    void tableGeneratorCheckBoxClicked(SelectionEvent e) {
        GeneratedValue generatedValue;
        boolean mappingHasTableGenerator = this.idMapping.getTableGenerator() != null;
        boolean checked = this.tableGeneratorCheckBox.getSelection();
        if (checked == mappingHasTableGenerator) {
            return;
        }
        TableGenerator tableGenerator = null;
        if (checked) {
            tableGenerator = OrmFactory.eINSTANCE.createTableGenerator(this.idMapping.getIdMappingModelAdapter().createTableGeneratorModelAdapter());
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping, (Object)OrmPackage.eINSTANCE.getIdMapping_TableGenerator(), (Object)tableGenerator));
        if (checked && (generatedValue = this.idMapping.getGeneratedValue()) != null && generatedValue.getSpecifiedGeneratorName() != null) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)tableGenerator, (Object)OrmPackage.eINSTANCE.getGenerator_SpecifiedName(), (Object)generatedValue.getSpecifiedGeneratorName()));
        }
    }

    private Button buildSequenceGeneratorCheckBox(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(DaliUiMessages.IdMappingComposite_sequenceGenerator);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdMappingComposite.this.sequenceGeneratorCheckBoxClicked(e);
            }
        });
        return button;
    }

    void sequenceGeneratorCheckBoxClicked(SelectionEvent e) {
        GeneratedValue generatedValue;
        boolean mappingHasSequenceGenerator = this.idMapping.getSequenceGenerator() != null;
        boolean checked = this.sequenceGeneratorCheckBox.getSelection();
        if (checked == mappingHasSequenceGenerator) {
            return;
        }
        SequenceGenerator sequenceGenerator = null;
        if (checked) {
            sequenceGenerator = OrmFactory.eINSTANCE.createSequenceGenerator(this.idMapping.getIdMappingModelAdapter().createSequenceGeneratorModelAdapter());
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping, (Object)OrmPackage.eINSTANCE.getIdMapping_SequenceGenerator(), (Object)sequenceGenerator));
        if (checked && (generatedValue = this.idMapping.getGeneratedValue()) != null && generatedValue.getSpecifiedGeneratorName() != null) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)sequenceGenerator, (Object)OrmPackage.eINSTANCE.getGenerator_SpecifiedName(), (Object)generatedValue.getSpecifiedGeneratorName()));
        }
    }

    public void populate(EObject model) {
        this.disengageListeners();
        this.idMapping = (IdMapping)model;
        if (this.idMapping == null) {
            this.generatedValueComposite.populate(null);
            this.tableGeneratorComposite.populate(null);
            this.sequenceGeneratorComposite.populate(null);
            this.columnComposite.populate(null);
            return;
        }
        Temporal temporal = this.idMapping.getTemporal();
        this.engageListeners();
        this.populateGeneratedValueComposite();
        this.populateSequenceGeneratorComposite();
        this.populateTableGeneratorComposite();
        this.populateColumnCombo();
        if (temporal == null) {
            this.temporalCheckBox.setSelection(false);
            this.temporalTypeComboViewer.getCombo().setEnabled(false);
        } else {
            this.temporalCheckBox.setSelection(true);
            this.temporalTypeComboViewer.getCombo().setEnabled(true);
            this.setTemporalTypeSelection(temporal.getType());
        }
    }

    private Temporal engageListeners() {
        this.mappingItemProvider.addListener(this.getMappingListener());
        this.idMapping.eAdapters().add((Object)this.mappingItemProvider);
        Temporal temporal = this.idMapping.getTemporal();
        if (temporal != null) {
            this.temporalItemProvider.addListener(this.getTemporalListener());
            temporal.eAdapters().add((Object)this.temporalItemProvider);
        }
        return temporal;
    }

    private void disengageListeners() {
        if (this.idMapping != null) {
            Temporal temporal = this.idMapping.getTemporal();
            if (temporal != null) {
                temporal.eAdapters().remove((Object)this.temporalItemProvider);
                this.temporalItemProvider.removeListener(this.getTemporalListener());
            }
            this.idMapping.eAdapters().remove((Object)this.mappingItemProvider);
            this.mappingItemProvider.removeListener(this.getMappingListener());
        }
    }

    void setTemporalTypeSelection(TemporalType temporalType) {
        if (temporalType != ((IStructuredSelection)this.temporalTypeComboViewer.getSelection()).getFirstElement()) {
            this.temporalTypeComboViewer.setSelection((ISelection)this.buildStructuredSelection(temporalType));
        }
    }

    private IStructuredSelection buildStructuredSelection(TemporalType temporalType) {
        return temporalType == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)temporalType);
    }

    void populateColumnCombo() {
        this.columnComposite.populate((EObject)this.idMapping.getColumn());
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    IdMappingComposite.this.mappingChanged(notification);
                }
            };
        }
        return this.mappingListener;
    }

    void mappingChanged(Notification notification) {
        if (!(((ViewerNotification)notification).getElement() instanceof IdMapping)) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.IdMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 3: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IdMappingComposite.this.populateTableGeneratorComposite();
                    }
                });
                break;
            }
            case 2: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IdMappingComposite.this.populateSequenceGeneratorComposite();
                    }
                });
                break;
            }
            case 1: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IdMappingComposite.this.populateGeneratedValueComposite();
                    }
                });
                break;
            }
            case 4: {
                final Temporal oldTemporal = (Temporal)notification.getOldValue();
                final Temporal newTemporal = (Temporal)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IdMappingComposite.this.temporalChanged(oldTemporal, newTemporal);
                    }
                });
            }
        }
    }

    void temporalChanged(Temporal oldTemporal, Temporal newTemporal) {
        if (oldTemporal == null) {
            if (newTemporal != null) {
                this.temporalItemProvider.addListener(this.getTemporalListener());
                newTemporal.eAdapters().add((Object)this.temporalItemProvider);
                this.temporalCheckBox.setSelection(true);
                this.temporalTypeComboViewer.getCombo().setEnabled(true);
                this.setTemporalTypeSelection(newTemporal.getType());
            }
        } else {
            oldTemporal.eAdapters().remove((Object)this.temporalItemProvider);
            this.temporalItemProvider.removeListener(this.getTemporalListener());
            if (newTemporal == null) {
                this.temporalCheckBox.setSelection(false);
                this.temporalTypeComboViewer.getCombo().setEnabled(false);
                this.setTemporalTypeSelection(null);
            } else {
                this.temporalItemProvider.addListener(this.getTemporalListener());
                newTemporal.eAdapters().add((Object)this.temporalItemProvider);
                this.setTemporalTypeSelection(newTemporal.getType());
            }
        }
    }

    private INotifyChangedListener getTemporalListener() {
        if (this.temporalListener == null) {
            this.temporalListener = this.buildTemporalListener();
        }
        return this.temporalListener;
    }

    private INotifyChangedListener buildTemporalListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                if (((ViewerNotification)notification).getElement() instanceof Temporal) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.orm.Temporal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 0: {
                            TemporalType temporalType = (TemporalType)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, temporalType){
                                final /* synthetic */ 13 this$1;
                                private final /* synthetic */ TemporalType val$temporalType;
                                {
                                    this.this$1 = var1_1;
                                    this.val$temporalType = temporalType;
                                }

                                public void run() {
                                    13.access$0(this.this$1).setTemporalTypeSelection(this.val$temporalType);
                                }
                            });
                        }
                    }
                }
            }

            static /* synthetic */ IdMappingComposite access$0(13 var0) {
                return var0.IdMappingComposite.this;
            }
        };
    }

    private void populateTableGeneratorComposite() {
        this.tableGeneratorComposite.populate((EObject)this.idMapping);
        boolean tableGeneratorExists = this.idMapping.getTableGenerator() != null;
        this.tableGeneratorCheckBox.setSelection(tableGeneratorExists);
        if (tableGeneratorExists) {
            this.tableGenExpandableComposite.setExpanded(true);
        }
    }

    private void populateSequenceGeneratorComposite() {
        this.sequenceGeneratorComposite.populate((EObject)this.idMapping);
        boolean sequenceGeneratorExists = this.idMapping.getSequenceGenerator() != null;
        this.sequenceGeneratorCheckBox.setSelection(sequenceGeneratorExists);
        if (sequenceGeneratorExists) {
            this.sequenceGenExpandableComposite.setExpanded(true);
        }
    }

    private void populateGeneratedValueComposite() {
        this.generatedValueComposite.populate((EObject)this.idMapping);
        this.primaryKeyGenerationCheckBox.setSelection(this.idMapping.getGeneratedValue() != null);
    }

    public void dispose() {
        this.disengageListeners();
        this.columnComposite.dispose();
        this.tableGeneratorComposite.dispose();
        this.sequenceGeneratorComposite.dispose();
        this.generatedValueComposite.dispose();
        super.dispose();
    }

    public static class IdMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new IdMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

