/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

class GenerateEntitiesWizardPage
extends NewTypeWizardPage {
    CheckboxTableViewer tableTable;
    private boolean convertToCamelCase = true;
    private boolean fieldAccessType = true;
    private String collectionTypeName;
    private int fieldVisibility;
    private int methodVisibility;
    private boolean generateGettersAndSetters;
    private boolean generateDefaultConstructor;
    private boolean serializable;
    private boolean generateSerialVersionUID;
    private boolean generateEmbeddedIdForCompoundPK;
    private Map overrideEntityNames;
    static final String[] TABLE_TABLE_COLUMN_PROPERTIES = new String[]{"table", "entityName"};
    private static final int TABLE_COLUMN_INDEX = 0;
    private static final int ENTITY_NAME_COLUMN_INDEX = 1;
    static /* synthetic */ Class class$0;

    GenerateEntitiesWizardPage() {
        super(true, "Generate Entities");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.collectionTypeName = clazz.getName();
        this.fieldVisibility = 0;
        this.methodVisibility = 3;
        this.generateGettersAndSetters = true;
        this.generateDefaultConstructor = true;
        this.serializable = true;
        this.generateSerialVersionUID = true;
        this.generateEmbeddedIdForCompoundPK = true;
        this.setTitle(DaliUiMessages.GenerateEntitiesWizardPage_generateEntities);
        this.setMessage(DaliUiMessages.GenerateEntitiesWizardPage_chooseEntityTable);
    }

    void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.dali.ui.dialog_generateEntities");
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        Group tablesGroup = new Group(composite, 16);
        tablesGroup.setLayout((Layout)new GridLayout());
        tablesGroup.setText(DaliUiMessages.GenerateEntitiesWizardPage_tables);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tablesGroup.setLayoutData((Object)data);
        this.createTablesSelectionControl((Composite)tablesGroup);
        GenerateEntitiesWizard generateEntitiesWizard = (GenerateEntitiesWizard)this.getWizard();
        Collection possibleTables = generateEntitiesWizard.getPossibleTables();
        this.initTablesSelectionControl(possibleTables);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableTable.getControl(), "org.eclipse.dali.ui.dialog_generateEntities_tables");
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private void initTablesSelectionControl(Collection possibleTables) {
        this.overrideEntityNames = new HashMap(possibleTables.size());
        this.tableTable.setInput((Object)possibleTables);
    }

    private void createTablesSelectionControl(Composite parent) {
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        Table table = new Table((Composite)layout, 68388);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText("Table");
        tableNameColumn.setResizable(true);
        TableColumn entityNameColumn = new TableColumn(table, 0, 1);
        entityNameColumn.setText("Entity Name");
        entityNameColumn.setResizable(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)20);
        gd.widthHint = 600;
        layout.setLayoutData((Object)gd);
        this.tableTable = new CheckboxTableViewer(table);
        this.tableTable.setUseHashlookup(true);
        this.tableTable.setLabelProvider(this.buildTableTableLabelProvider());
        this.tableTable.setContentProvider(this.buildTableTableContentProvider());
        this.tableTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((org.eclipse.dali.db.Table)e1).getName().compareTo(((org.eclipse.dali.db.Table)e2).getName());
            }
        });
        this.tableTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenerateEntitiesWizardPage.this.handleTablesListSelectionChanged(event);
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    GenerateEntitiesWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
        this.tableTable.editElement(selected[0], 1);
    }

    private void addCellEditors() {
        this.tableTable.setColumnProperties(TABLE_TABLE_COLUMN_PROPERTIES);
        TextCellEditor[] editors = new TextCellEditor[TABLE_TABLE_COLUMN_PROPERTIES.length];
        editors[1] = new TextCellEditor((Composite)this.tableTable.getTable(), 4);
        this.tableTable.setCellEditors((CellEditor[])editors);
        this.tableTable.setCellModifier(this.buildTableTableCellModifier());
    }

    void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.setPageComplete(true);
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    private ICellModifier buildTableTableCellModifier() {
        return new TableTableCellModifier();
    }

    Collection getSelectedTables() {
        return Arrays.asList(this.tableTable.getCheckedElements());
    }

    private boolean hasTablesSelected() {
        return this.tableTable != null ? this.getSelectedTables().size() > 0 : false;
    }

    void updateTablesListViewer(Collection possibleTables) {
        if (this.tableTable != null) {
            this.initTablesSelectionControl(possibleTables);
        }
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (this.isPageComplete() && !this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }

    String entityName(org.eclipse.dali.db.Table table) {
        String overrideEntityName = (String)this.overrideEntityNames.get(table);
        return overrideEntityName != null ? overrideEntityName : this.defaultEntityName(table);
    }

    private String defaultEntityName(org.eclipse.dali.db.Table table) {
        String entityName = table.shortJavaClassName();
        if (this.convertToCamelCase) {
            entityName = StringTools.convertUnderscoresToCamelCase((String)entityName);
        }
        return entityName;
    }

    void setOverrideEntityName(org.eclipse.dali.db.Table table, String name) {
        if (table.shortJavaClassName().equals(name)) {
            this.overrideEntityNames.remove(table);
        } else {
            this.overrideEntityNames.put(table, name);
        }
    }

    boolean convertToCamelCase() {
        return this.convertToCamelCase;
    }

    private void setConvertToCamelCase(boolean convertToCamelCase) {
        this.convertToCamelCase = convertToCamelCase;
    }

    boolean fieldAccessType() {
        return this.fieldAccessType;
    }

    private void setFieldAccessType(boolean fieldAccessType) {
        this.fieldAccessType = fieldAccessType;
    }

    String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    private void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    int getFieldVisibility() {
        return this.fieldVisibility;
    }

    private void setFieldVisibility(int fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    int getMethodVisibility() {
        return this.methodVisibility;
    }

    private void setMethodVisibility(int methodVisibility) {
        this.methodVisibility = methodVisibility;
    }

    boolean generateGettersAndSetters() {
        return this.generateGettersAndSetters;
    }

    private void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
        this.generateGettersAndSetters = generateGettersAndSetters;
    }

    boolean generateDefaultConstructor() {
        return this.generateDefaultConstructor;
    }

    private void setGenerateDefaultConstructor(boolean generateDefaultConstructor) {
        this.generateDefaultConstructor = generateDefaultConstructor;
    }

    boolean serializable() {
        return this.serializable;
    }

    private void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    boolean generateSerialVersionUID() {
        return this.generateSerialVersionUID;
    }

    private void setGenerateSerialVersionUID(boolean generateSerialVersionUID) {
        this.generateSerialVersionUID = generateSerialVersionUID;
    }

    boolean generateEmbeddedIdForCompoundPK() {
        return this.generateEmbeddedIdForCompoundPK;
    }

    private void setGenerateEmbeddedIdForCompoundPK(boolean generateEmbeddedIdForCompoundPK) {
        this.generateEmbeddedIdForCompoundPK = generateEmbeddedIdForCompoundPK;
    }

    Map getOverrideEntityNames() {
        return this.overrideEntityNames;
    }

    private class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((org.eclipse.dali.db.Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((org.eclipse.dali.db.Table)element).getName();
                }
                case 1: {
                    return GenerateEntitiesWizardPage.this.entityName((org.eclipse.dali.db.Table)element);
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }

    private class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableTableCellModifier
    implements ICellModifier {
        TableTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1]);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                return GenerateEntitiesWizardPage.this.entityName((org.eclipse.dali.db.Table)element);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            if (!(element instanceof org.eclipse.dali.db.Table)) {
                return;
            }
            boolean unchanged = false;
            org.eclipse.dali.db.Table table = (org.eclipse.dali.db.Table)element;
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                unchanged = GenerateEntitiesWizardPage.this.entityName(table).equals(value);
                GenerateEntitiesWizardPage.this.setOverrideEntityName(table, (String)value);
            }
            if (!unchanged) {
                GenerateEntitiesWizardPage.this.tableTable.update((Object)table, new String[]{property});
            }
        }
    }
}

