/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import org.eclipse.tm4e.markdown.marked.HTMLRenderer;
import org.eclipse.tm4e.markdown.marked.IRenderer;
import org.eclipse.tm4e.markdown.marked.InlineLexer;
import org.eclipse.tm4e.markdown.marked.Options;
import org.eclipse.tm4e.markdown.marked.Token;
import org.eclipse.tm4e.markdown.marked.Tokens;

public class Parser {
    private Tokens tokens = new Tokens();
    private Token token = null;
    private Options options;
    private InlineLexer inline;
    private IRenderer renderer;

    public Parser(Options options, IRenderer renderer) {
        this.options = options != null ? options : Options.DEFAULTS;
        this.renderer = renderer != null ? renderer : new HTMLRenderer();
    }

    public static IRenderer parse(Tokens src, Options options, IRenderer renderer) {
        Parser parser = new Parser(options, renderer);
        return parser.parse(src);
    }

    private IRenderer parse(Tokens src) {
        this.inline = new InlineLexer(src.links, this.options, this.renderer);
        this.tokens = src.reverse();
        while (this.next()) {
            this.tok();
        }
        return this.renderer;
    }

    private boolean next() {
        this.token = this.tokens.pop();
        return this.token != null;
    }

    private void tok() {
        switch (this.token.type) {
            case space: {
                break;
            }
            case hr: {
                this.renderer.hr();
                break;
            }
            case heading: {
                this.renderer.heading(this.token.text, this.token.depth, this.token.text);
                break;
            }
            case code: {
                this.renderer.code(this.token.text, this.token.lang, this.token.escaped);
                break;
            }
            case paragraph: {
                this.renderer.startParagraph();
                this.inline.output(this.token.text);
                this.renderer.endParagraph();
            }
        }
    }
}

