/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;

public class BaseThemeAssociationRegistry {
    private IThemeAssociation defaultAssociation;
    private final Map<String, List<IThemeAssociation>> eclipseThemeIds = new HashMap<String, List<IThemeAssociation>>();
    private List<IThemeAssociation> allAssociations = new ArrayList<IThemeAssociation>();

    public void register(IThemeAssociation association) {
        this.allAssociations.clear();
    }

    public void unregister(IThemeAssociation association) {
        this.allAssociations.clear();
    }

    public IThemeAssociation getThemeAssociationFor(String eclipseThemeId) {
        List<IThemeAssociation> associations = this.eclipseThemeIds.get(eclipseThemeId);
        if (associations != null && associations.size() == 1) {
            return associations.get(0);
        }
        return null;
    }

    public IThemeAssociation[] getThemeAssociations(boolean isDefault) {
        return this.getThemeAssociations().toArray(new IThemeAssociation[this.allAssociations.size()]);
    }

    public IThemeAssociation getDefaultAssociation() {
        return this.defaultAssociation;
    }

    public IThemeAssociation[] getThemeAssociationsForTheme(String themeId) {
        return this.getThemeAssociations().stream().filter(themeAssociation -> themeId.equals(themeAssociation.getThemeId())).collect(Collectors.toList()).toArray(new IThemeAssociation[0]);
    }

    public boolean hasThemeAssociationsForTheme(String themeId, String eclipseThemeId) {
        return true;
    }

    public List<IThemeAssociation> getThemeAssociations() {
        if (this.allAssociations.isEmpty()) {
            if (this.defaultAssociation != null) {
                this.allAssociations.add(this.defaultAssociation);
            }
            Collection<List<IThemeAssociation>> associations = this.eclipseThemeIds.values();
            for (Collection collection : associations) {
                this.allAssociations.addAll(collection);
            }
        }
        return this.allAssociations;
    }
}

