/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

final class DocumentHelper {
    DocumentHelper() {
    }

    static int getStartLine(DocumentEvent event) throws BadLocationException {
        return event.getDocument().getLineOfOffset(event.getOffset());
    }

    static int getEndLine(DocumentEvent event, boolean documentAboutToBeChanged) throws BadLocationException {
        int length = documentAboutToBeChanged ? event.getLength() : event.getText().length();
        return event.getDocument().getLineOfOffset(event.getOffset() + length);
    }

    static boolean isRemove(DocumentEvent event) {
        return event.getText() == null || event.getText().isEmpty();
    }

    static boolean isInsert(DocumentEvent event) {
        return event.getLength() == 0 && event.getText() != null;
    }

    static String getLineText(IDocument document, int line, boolean withLineDelimiter) throws BadLocationException {
        int lo = document.getLineOffset(line);
        int ll = document.getLineLength(line);
        if (!withLineDelimiter) {
            String delim = document.getLineDelimiter(line);
            ll -= delim != null ? delim.length() : 0;
        }
        return document.get(lo, ll);
    }

    private static IRegion getRegion(IDocument document, int fromLine, int toLine) throws BadLocationException {
        int startOffset = document.getLineOffset(fromLine);
        int endOffset = document.getLineOffset(toLine) + document.getLineLength(toLine);
        return new Region(startOffset, endOffset - startOffset);
    }
}

