/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.externaltools.internal.registry.ExternalToolMigration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class BuilderCoreUtils {
    public static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    public static final String INC_CLEAN = "incclean";
    public static final String BUILDER_FOLDER_NAME = ".externalToolBuilders";
    public static final String PROJECT_TAG = "<project>";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_2_1 = "2.1";
    public static final String VERSION_3_0_interim = "3.0.interim";
    public static final String VERSION_3_0_final = "3.0";
    private static final String BUILD_TYPE_SEPARATOR = ",";
    private static final int[] DEFAULT_BUILD_TYPES = new int[]{10, 6};

    public static ILaunchConfiguration configFromBuildCommandArgs(IProject project, Map<String, String> commandArgs, String[] version) {
        String configHandle = commandArgs.get(LAUNCH_CONFIG_HANDLE);
        if (configHandle == null) {
            version[0] = VERSION_1_0;
            return ExternalToolMigration.configFromArgumentMap(commandArgs);
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration configuration = null;
        if (configHandle.startsWith(PROJECT_TAG)) {
            version[0] = VERSION_3_0_final;
            Path path = new Path(configHandle);
            IFile file = project.getFile(path.removeFirstSegments(1));
            if (file.exists()) {
                configuration = manager.getLaunchConfiguration(file);
            }
        } else {
            IPath path = new Path(BUILDER_FOLDER_NAME).append(configHandle);
            IFile file = project.getFile(path);
            if (file.exists()) {
                version[0] = VERSION_3_0_interim;
                configuration = manager.getLaunchConfiguration(file);
            } else {
                try {
                    configuration = manager.getLaunchConfiguration(configHandle);
                }
                catch (CoreException coreException) {}
                if (configuration != null) {
                    version[0] = VERSION_2_1;
                }
            }
        }
        return configuration;
    }

    public static void configureTriggers(ILaunchConfiguration config, ICommand newCommand) throws CoreException {
        newCommand.setBuilding(6, false);
        newCommand.setBuilding(10, false);
        newCommand.setBuilding(9, false);
        newCommand.setBuilding(15, false);
        String buildKinds = config.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", null);
        boolean isfull = false;
        boolean isinc = false;
        int[] nArray = BuilderCoreUtils.buildTypesToArray(buildKinds);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int trigger = nArray[n2];
            switch (trigger) {
                case 6: {
                    newCommand.setBuilding(6, true);
                    isfull = true;
                    break;
                }
                case 10: {
                    newCommand.setBuilding(10, true);
                    isinc = true;
                    break;
                }
                case 9: {
                    newCommand.setBuilding(9, true);
                    break;
                }
                case 15: {
                    newCommand.setBuilding(15, true);
                    break;
                }
            }
            ++n2;
        }
        if (!isfull && isinc) {
            HashMap<String, String> args = newCommand.getArguments();
            if (args == null) {
                args = new HashMap<String, String>();
            }
            newCommand.setBuilding(6, true);
            args.put(INC_CLEAN, Boolean.TRUE.toString());
            newCommand.setArguments(args);
        }
        if (!config.getAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", false)) {
            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
            copy.doSave();
        }
    }

    public static boolean isUnmigratedConfig(ILaunchConfiguration config) {
        return config.isWorkingCopy() && ((ILaunchConfigurationWorkingCopy)config).getOriginal() == null;
    }

    public static ICommand toBuildCommand(IProject project, ILaunchConfiguration config, ICommand command) throws CoreException {
        Map<String, String> args = null;
        if (BuilderCoreUtils.isUnmigratedConfig(config)) {
            ICommand[] commands;
            ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand projectCommand = iCommandArray[n2];
                String name = ExternalToolMigration.getNameFromCommandArgs(projectCommand.getArguments());
                if (name != null && name.equals(config.getName())) {
                    args = projectCommand.getArguments();
                    break;
                }
                ++n2;
            }
        } else {
            ILaunchConfigurationWorkingCopy workingCopy;
            ILaunchConfiguration temp = config;
            if (config instanceof ILaunchConfigurationWorkingCopy && (workingCopy = (ILaunchConfigurationWorkingCopy)config).getOriginal() != null) {
                temp = workingCopy.getOriginal();
            }
            args = new HashMap<String, String>();
            StringBuilder buffer = new StringBuilder(PROJECT_TAG);
            buffer.append('/').append(temp.getFile().getFullPath().removeFirstSegments(1));
            args.put(LAUNCH_CONFIG_HANDLE, buffer.toString());
        }
        command.setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        command.setArguments(args);
        return command;
    }

    public static IFolder getBuilderFolder(IProject project, boolean create) {
        if (project == null) {
            return null;
        }
        IFolder folder = project.getFolder(BUILDER_FOLDER_NAME);
        if (!folder.exists() && create) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return folder;
    }

    public static int[] buildTypesToArray(String buildTypes) {
        if (buildTypes == null || buildTypes.length() == 0) {
            return DEFAULT_BUILD_TYPES;
        }
        int count = 0;
        boolean incremental = false;
        boolean full = false;
        boolean auto = false;
        boolean clean = false;
        StringTokenizer tokenizer = new StringTokenizer(buildTypes, BUILD_TYPE_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("incremental".equals(token)) {
                if (incremental) continue;
                incremental = true;
                ++count;
                continue;
            }
            if ("full".equals(token)) {
                if (full) continue;
                full = true;
                ++count;
                continue;
            }
            if ("auto".equals(token)) {
                if (auto) continue;
                auto = true;
                ++count;
                continue;
            }
            if (!"clean".equals(token) || clean) continue;
            clean = true;
            ++count;
        }
        int[] results = new int[count];
        count = 0;
        if (incremental) {
            results[count] = 10;
            ++count;
        }
        if (full) {
            results[count] = 6;
            ++count;
        }
        if (auto) {
            results[count] = 9;
            ++count;
        }
        if (clean) {
            results[count] = 15;
            ++count;
        }
        return results;
    }
}

