/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.views.properties.tabbed.l10n.TabbedPropertyMessages;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TabDescriptor
extends AbstractTabDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_LABEL = "label";
    private static final String ATT_IMAGE = "image";
    private static final String ATT_INDENTED = "indented";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_AFTER_TAB = "afterTab";
    private static final String TAB_ERROR = TabbedPropertyMessages.TabDescriptor_Tab_error;
    private String id;
    private String label;
    private Image image;
    private boolean selected;
    private boolean indented;
    private String category;
    private String afterTab;

    public TabDescriptor(IConfigurationElement configurationElement) {
        if (configurationElement != null) {
            String indentedString;
            this.id = configurationElement.getAttribute(ATT_ID);
            this.label = configurationElement.getAttribute(ATT_LABEL);
            String imageString = configurationElement.getAttribute(ATT_IMAGE);
            if (imageString != null) {
                String name = configurationElement.getDeclaringExtension().getContributor().getName();
                ResourceLocator.imageDescriptorFromBundle((String)name, (String)imageString).ifPresent(d -> {
                    Image image = this.image = d.createImage();
                });
            }
            this.indented = (indentedString = configurationElement.getAttribute(ATT_INDENTED)) != null && indentedString.equals("true");
            this.category = configurationElement.getAttribute(ATT_CATEGORY);
            this.afterTab = configurationElement.getAttribute(ATT_AFTER_TAB);
            if (this.id == null || this.label == null || this.category == null) {
                this.handleTabError(configurationElement, null);
            }
        }
        this.selected = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getAfterTab() {
        if (this.afterTab == null) {
            return super.getAfterTab();
        }
        return this.afterTab;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    protected boolean append(ISectionDescriptor target) {
        if (!target.getTargetTab().equals(this.id)) {
            return false;
        }
        if (this.insertSectionDescriptor(target)) {
            return true;
        }
        this.getSectionDescriptors().add(target);
        return true;
    }

    private boolean insertSectionDescriptor(ISectionDescriptor target) {
        if (target.getAfterSection().equals("top")) {
            this.getSectionDescriptors().add(0, target);
            return true;
        }
        int i = 0;
        while (i < this.getSectionDescriptors().size()) {
            ISectionDescriptor descriptor = (ISectionDescriptor)this.getSectionDescriptors().get(i);
            if (target.getAfterSection().equals(descriptor.getId())) {
                this.getSectionDescriptors().add(i + 1, target);
                return true;
            }
            if (descriptor.getAfterSection().equals(target.getId())) {
                this.getSectionDescriptors().add(i, target);
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    private void handleTabError(IConfigurationElement configurationElement, CoreException exception) {
        String pluginId = configurationElement.getDeclaringExtension().getContributor().getName();
        String message = MessageFormat.format(TAB_ERROR, pluginId);
        Status status = new Status(4, pluginId, 3, message, (Throwable)exception);
        Bundle bundle = FrameworkUtil.getBundle(TabDescriptor.class);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    protected void setImage(Image image) {
        this.image = image;
    }

    protected void setIndented(boolean indented) {
        this.indented = indented;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isIndented() {
        return this.indented;
    }

    @Override
    public String getText() {
        return this.label;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }
}

