/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class RecordPattern
extends Pattern {
    public static final ChildListPropertyDescriptor PATTERNS_PROPERTY = new ChildListPropertyDescriptor(RecordPattern.class, "patterns", Pattern.class, true);
    public static final ChildPropertyDescriptor PATTERN_TYPE_PROPERTY = new ChildPropertyDescriptor(RecordPattern.class, "patternType", Type.class, true, true);
    public static final ChildPropertyDescriptor PATTERN_NAME_PROPERTY = new ChildPropertyDescriptor(RecordPattern.class, "patternName", SimpleName.class, false, true);
    private static final List PROPERTY_DESCRIPTORS;
    private SimpleName optionalPatternName = null;
    private Type patternType = null;
    private ASTNode.NodeList patterns = new ASTNode.NodeList(PATTERNS_PROPERTY);

    static {
        ArrayList properyList = new ArrayList(5);
        RecordPattern.createPropertyList(RecordPattern.class, properyList);
        RecordPattern.addProperty(PATTERN_TYPE_PROPERTY, properyList);
        RecordPattern.addProperty(PATTERNS_PROPERTY, properyList);
        RecordPattern.addProperty(PATTERN_NAME_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = RecordPattern.reapPropertyList(properyList);
    }

    @Override
    int getNodeType0() {
        return 113;
    }

    RecordPattern(AST ast) {
        super(ast);
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
    }

    public static List propertyDescriptors(int apiLevel) {
        return null;
    }

    public static List propertyDescriptors(int apiLevel, boolean previewEnabled) {
        if (DOMASTUtil.isPatternSupported(apiLevel, previewEnabled)) {
            return PROPERTY_DESCRIPTORS;
        }
        return null;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return RecordPattern.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return RecordPattern.propertyDescriptors(apiLevel, previewEnabled);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == PATTERN_TYPE_PROPERTY) {
            if (get) {
                return this.getPatternType();
            }
            this.setPatternType((Type)child);
            return null;
        }
        if (property == PATTERN_NAME_PROPERTY) {
            if (get) {
                return this.getPatternName();
            }
            this.setPatternName((SimpleName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PATTERNS_PROPERTY) {
            return this.patterns();
        }
        return super.internalGetChildListProperty(property);
    }

    public void setPatternName(SimpleName patternName) {
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
        if (patternName == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.optionalPatternName;
        this.preReplaceChild(oldChild, patternName, PATTERN_NAME_PROPERTY);
        this.optionalPatternName = patternName;
        this.postReplaceChild(oldChild, patternName, PATTERN_NAME_PROPERTY);
    }

    public void setPatternType(Type patternType) {
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
        if (patternType == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.patternType;
        this.preReplaceChild(oldChild, patternType, PATTERN_TYPE_PROPERTY);
        this.patternType = patternType;
        this.postReplaceChild(oldChild, patternType, PATTERN_TYPE_PROPERTY);
    }

    public SimpleName getPatternName() {
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
        return this.optionalPatternName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getPatternType() {
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
        if (this.patternType == null) {
            RecordPattern recordPattern = this;
            synchronized (recordPattern) {
                if (this.patternType == null) {
                    this.preLazyInit();
                    this.patternType = this.ast.newPrimitiveType(PrimitiveType.INT);
                    this.postLazyInit(this.patternType, PATTERN_TYPE_PROPERTY);
                }
            }
        }
        return this.patternType;
    }

    public List<Pattern> patterns() {
        this.supportedOnlyIn19();
        this.unsupportedWithoutPreviewError();
        return this.patterns;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        RecordPattern result = new RecordPattern(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.patterns().addAll(ASTNode.copySubtrees(target, this.patterns()));
        result.setPatternType((Type)this.getPatternType().clone(target));
        result.setPatternName((SimpleName)this.getPatternName().clone(target));
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.patterns);
            this.acceptChild(visitor, this.getPatternType());
            this.acceptChild(visitor, this.getPatternName());
        }
        visitor.endVisit(this);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.patternType == null ? 0 : this.getPatternType().treeSize()) + (this.optionalPatternName == null ? 0 : this.getPatternName().treeSize()) + this.patterns.listSize();
    }
}

