/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;

public class DateHistoryCategory
extends AbstractHistoryCategory {
    private String name;
    private Calendar fromDate;
    private Calendar toDate;
    private IFileRevision[] revisions;

    public DateHistoryCategory(String name, Calendar fromDate, Calendar toDate) {
        this.name = name;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean collectFileRevisions(IFileRevision[] fileRevisions, boolean shouldRemove) {
        ArrayList<IFileRevision> pertinentRevisions = new ArrayList<IFileRevision>();
        ArrayList<IFileRevision> nonPertinentRevisions = new ArrayList<IFileRevision>();
        IFileRevision[] iFileRevisionArray = fileRevisions;
        int n = fileRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision fileRevision = iFileRevisionArray[n2];
            Calendar fileRevDate = Calendar.getInstance();
            fileRevDate.setTimeInMillis(fileRevision.getTimestamp());
            int fileRevDay = fileRevDate.get(6);
            int fileRevYear = fileRevDate.get(1);
            if (this.fromDate == null) {
                if (fileRevDay < this.toDate.get(6) && fileRevYear == this.toDate.get(1) || fileRevYear < this.toDate.get(1)) {
                    pertinentRevisions.add(fileRevision);
                } else {
                    nonPertinentRevisions.add(fileRevision);
                }
            } else if (this.toDate == null) {
                if (fileRevDay == this.fromDate.get(6) && fileRevYear == this.fromDate.get(1)) {
                    pertinentRevisions.add(fileRevision);
                } else {
                    nonPertinentRevisions.add(fileRevision);
                }
            } else if (fileRevYear >= this.fromDate.get(1) && fileRevYear <= this.toDate.get(1) && fileRevDay >= this.fromDate.get(6) && fileRevDay < this.toDate.get(6)) {
                pertinentRevisions.add(fileRevision);
            } else {
                nonPertinentRevisions.add(fileRevision);
            }
            ++n2;
        }
        if (pertinentRevisions.size() > 0) {
            IFileRevision[] tempRevision = pertinentRevisions.toArray(new IFileRevision[pertinentRevisions.size()]);
            this.revisions = new IFileRevision[tempRevision.length];
            System.arraycopy(tempRevision, 0, this.revisions, 0, tempRevision.length);
            return true;
        }
        return false;
    }

    @Override
    public IFileRevision[] getRevisions() {
        return this.revisions;
    }

    @Override
    public boolean hasRevisions() {
        return this.revisions != null && this.revisions.length != 0;
    }
}

