/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import org.eclipse.rse.internal.ui.dialogs.SystemDeleteTableRow;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;

public class SystemRenameTableRow
extends SystemDeleteTableRow {
    private String newName = this.getName();
    private SystemMessage errorMsg = null;
    private ISystemValidator inputValidator = null;
    private ValidatorUniqueString inputUniqueNameValidator = null;
    private Object parent;
    private int nameLengthLimit = -1;

    public SystemRenameTableRow(Object element, int rowNbr) {
        super(element, rowNbr);
        this.inputValidator = this.getViewAdapter(element).getNameValidator(element);
        if (this.inputValidator != null) {
            this.nameLengthLimit = this.inputValidator.getMaximumNameLength();
        }
    }

    public void setNewName(String name) {
        this.newName = name != null ? (this.isRemote() ? SystemRenameTableRow.trimTrailing(name) : name.trim()) : null;
    }

    public static String trimTrailing(String text) {
        return ("." + text).trim().substring(1);
    }

    public String getNewName() {
        return this.newName;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public String getCanonicalNewName() {
        Object element = super.getElement();
        ISystemViewElementAdapter adapter = super.getViewAdapter();
        String cName = this.newName;
        cName = adapter != null ? adapter.getCanonicalNewName(element, this.newName) : this.newName;
        return cName;
    }

    public boolean newNameEqualsOldName() {
        Object element = super.getElement();
        ISystemViewElementAdapter adapter = super.getViewAdapter();
        if (adapter != null) {
            return adapter.namesAreEqual(element, this.newName);
        }
        return this.getName().equals(this.newName);
    }

    public int getNameLengthLimit() {
        return this.nameLengthLimit;
    }

    public void setNameValidator(ISystemValidator nameValidator) {
        this.inputValidator = nameValidator;
    }

    public void setUniqueNameValidator(ValidatorUniqueString uniqueNameValidator) {
        this.inputUniqueNameValidator = uniqueNameValidator;
    }

    public ISystemValidator getNameValidator() {
        return this.inputValidator;
    }

    public ValidatorUniqueString getUniqueNameValidator() {
        return this.inputUniqueNameValidator;
    }

    public boolean getError() {
        return this.errorMsg != null;
    }

    public SystemMessage getErrorMessage() {
        return this.errorMsg;
    }

    public void setErrorMessage(SystemMessage errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String toString() {
        return this.getNewName();
    }
}

