/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class DSPDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IFontProvider {
    private Font italic;

    public String getText(Object element) {
        StringBuilder label = new StringBuilder();
        if (element instanceof DSPThread var3_4) {
            label.append(NLS.bind((String)"Thread #{0} [{1}]", (Object)thread.getId(), (Object)thread.getName()));
        }
        if (label.length() != 0) {
            if (element instanceof ITerminate var5_6) {
                if (terminate.isTerminated()) {
                    label.insert(0, "<terminated>");
                }
            } else {
                if (element instanceof IDisconnect var7_8 && disconned.isDisconnected()) {
                    label.insert(0, "<disconnected>");
                }
            }
        } else {
            label.append(DebugUIPlugin.getDefaultLabelProvider().getText(element));
        }
        if (( instanceOfPatternExpressionValue = element) instanceof DSPDebugElement && (terminate = (DSPDebugElement)((Object) instanceOfPatternExpressionValue)) == (DSPDebugElement)((Object) instanceOfPatternExpressionValue) && debugElement.getErrorMessage() != null) {
            label.append(" <error:");
            label.append(debugElement.getErrorMessage());
            label.append('>');
        }
        return label.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Font getFont(Object element) {
        void debugElement;
        void var3_2;
        DSPDebugElement dSPDebugElement;
        Object object = element;
        if (object instanceof DSPDebugElement && (dSPDebugElement = (DSPDebugElement)((Object)object)) == (DSPDebugElement)var3_2 && debugElement.getErrorMessage() != null) {
            return this.italic();
        }
        return null;
    }

    private Font italic() {
        if (this.italic == null) {
            Font dialogFont = JFaceResources.getDialogFont();
            FontData[] fontData = dialogFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                FontData data = fontData[i];
                data.setStyle(2);
                ++i;
            }
            Display display = DSPDebugModelPresentation.getDisplay();
            this.italic = new Font((Device)display, fontData);
        }
        return this.italic;
    }

    public void dispose() {
        if (this.italic != null) {
            this.italic.dispose();
        }
        super.dispose();
    }

    public IEditorInput getEditorInput(Object element) {
        Object object = element;
        if (object instanceof ILineBreakpoint && (var2_3 = (ILineBreakpoint)object) == (ILineBreakpoint)var3_2) {
            return new FileEditorInput((IFile)lineBreakpoint.getMarker().getResource());
        }
        if (element instanceof IFile var4_5) {
            return new FileEditorInput((IFile)file);
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.toString()));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if (files != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return new FileEditorInput(file);
                }
                ++n2;
            }
        }
        return new FileStoreEditorInput(fileStore);
    }

    public String getEditorId(IEditorInput input, Object element) {
        String id = null;
        if (input != null) {
            IEditorDescriptor descriptor = null;
            if (input instanceof IFileEditorInput var5_6) {
                IFile file = fileEditorInput.getFile();
                descriptor = IDE.getDefaultEditor((IFile)file);
            } else {
                if (input instanceof IURIEditorInput file) {
                    URI uri = uriEditorInput.getURI();
                    try {
                        IFileStore fileStore = EFS.getStore((URI)uri);
                        id = IDE.getEditorDescriptorForFileStore((IFileStore)fileStore, (boolean)false).getId();
                    }
                    catch (CoreException fileStore) {
                        // empty catch block
                    }
                }
            }
            if (id == null) {
                if (descriptor == null) {
                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                    descriptor = registry.getDefaultEditor(input.getName());
                }
                id = "org.eclipse.ui.genericeditor.GenericEditor";
                if (descriptor != null) {
                    id = descriptor.getId();
                }
            }
            if (id == null && element instanceof ILineBreakpoint && (sourcePres = (ISourcePresentation)Platform.getAdapterManager().getAdapter(element, ISourcePresentation.class)) != null && (lid = sourcePres.getEditorId(input, element)) != null) {
                id = lid;
            }
        }
        return id;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

