/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.highlight;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;

public class HighlightReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String TOGGLE_HIGHLIGHT_PREFERENCE = "org.eclipse.ui.genericeditor.togglehighlight";
    public static final String READ_ANNOTATION_TYPE = "org.eclipse.lsp4e.read";
    public static final String WRITE_ANNOTATION_TYPE = "org.eclipse.lsp4e.write";
    public static final String TEXT_ANNOTATION_TYPE = "org.eclipse.lsp4e.text";
    private boolean enabled;
    private ISourceViewer sourceViewer;
    private IDocument document;
    private CompletableFuture<?> request;
    private Job highlightJob;
    private Annotation[] fOccurrenceAnnotations = null;
    private EditorSelectionChangedListener editorSelectionChangedListener;

    /*
     * WARNING - void declaration
     */
    private void updateHighlights(ISelection selection) {
        void var3_2;
        ITextSelection iTextSelection;
        ISelection iSelection = selection;
        if (iSelection instanceof ITextSelection && (iTextSelection = (ITextSelection)iSelection) == (ITextSelection)var3_2) {
            void textSelection;
            if (this.highlightJob != null) {
                this.highlightJob.cancel();
            }
            this.highlightJob = Job.createSystem((String)"LSP4E Highlight", arg_0 -> this.lambda$0((ITextSelection)textSelection, arg_0));
            this.highlightJob.schedule();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void install(ITextViewer viewer) {
        void var3_2;
        ISourceViewer iSourceViewer;
        ITextViewer iTextViewer = viewer;
        if (iTextViewer instanceof ISourceViewer && (iSourceViewer = (ISourceViewer)iTextViewer) == (ISourceViewer)var3_2) {
            void thisSourceViewer;
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
            preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.enabled = preferences.getBoolean(TOGGLE_HIGHLIGHT_PREFERENCE, true);
            this.sourceViewer = thisSourceViewer;
            this.editorSelectionChangedListener = new EditorSelectionChangedListener();
            this.editorSelectionChangedListener.install(this.sourceViewer.getSelectionProvider());
        }
    }

    public void uninstall() {
        if (this.sourceViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.cancel();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            ISelectionProvider selectionProvider = this.sourceViewer.getSelectionProvider();
            StyledText textWidget = this.sourceViewer.getTextWidget();
            if (textWidget != null && selectionProvider != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateHighlights(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    private void collectHighlights(int caretOffset, IProgressMonitor monitor) {
        Position position;
        if (this.sourceViewer == null || !this.enabled || monitor.isCanceled()) {
            return;
        }
        this.cancel();
        try {
            position = LSPEclipseUtils.toPosition(caretOffset, this.document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return;
        }
        URI uri = LSPEclipseUtils.toUri(this.document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
        DocumentHighlightParams params = new DocumentHighlightParams(identifier, position);
        this.request = LanguageServiceAccessor.getLanguageServers(this.document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentHighlightProvider())).thenAcceptAsync(languageServers -> {
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().documentHighlight(params)).map(request -> request.thenAcceptAsync(result -> {
                if (!monitor.isCanceled()) {
                    this.updateAnnotations((List<? extends DocumentHighlight>)result, this.sourceViewer.getAnnotationModel());
                }
            })).toArray(CompletableFuture[]::new));
        });
    }

    private void cancel() {
        if (this.request != null && !this.request.isDone()) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateAnnotations(List<? extends DocumentHighlight> highlights, IAnnotationModel annotationModel) {
        HashMap<Annotation, org.eclipse.jface.text.Position> annotationMap = new HashMap<Annotation, org.eclipse.jface.text.Position>(highlights.size());
        IAnnotationModelExtension iAnnotationModelExtension = highlights.iterator();
        while (iAnnotationModelExtension.hasNext()) {
            DocumentHighlight h = iAnnotationModelExtension.next();
            if (h == null) continue;
            try {
                int start = LSPEclipseUtils.toOffset(h.getRange().getStart(), this.document);
                int end = LSPEclipseUtils.toOffset(h.getRange().getEnd(), this.document);
                annotationMap.put(new Annotation(this.kindToAnnotationType(h.getKind()), false, null), new org.eclipse.jface.text.Position(start, end - start));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            IAnnotationModel iAnnotationModel = annotationModel;
            if (iAnnotationModel instanceof IAnnotationModelExtension && (iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel) == (IAnnotationModelExtension)iAnnotationModel) {
                void modelExtension;
                modelExtension.replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
            } else {
                this.removeOccurrenceAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (org.eclipse.jface.text.Position)mapEntry.getValue());
                }
            }
            this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.size()]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object getLockObject(IAnnotationModel annotationModel) {
        void sync;
        Object lock;
        void var3_2;
        ISynchronizable iSynchronizable;
        IAnnotationModel iAnnotationModel = annotationModel;
        if (iAnnotationModel instanceof ISynchronizable && (iSynchronizable = (ISynchronizable)iAnnotationModel) == (ISynchronizable)var3_2 && (lock = sync.getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension var3_4) {
                modelExtension.replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fOccurrenceAnnotations;
                int n = this.fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private String kindToAnnotationType(DocumentHighlightKind kind) {
        return switch (kind) {
            case DocumentHighlightKind.Read -> READ_ANNOTATION_TYPE;
            case DocumentHighlightKind.Write -> WRITE_ANNOTATION_TYPE;
            default -> TEXT_ANNOTATION_TYPE;
        };
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(TOGGLE_HIGHLIGHT_PREFERENCE)) {
            this.enabled = Boolean.valueOf(event.getNewValue().toString());
            if (this.enabled) {
                this.initialReconcile();
            } else {
                this.removeOccurrenceAnnotations();
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    private /* synthetic */ void lambda$0(ITextSelection iTextSelection, IProgressMonitor monitor) throws CoreException {
        this.collectHighlights(iTextSelection.getOffset(), monitor);
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        /*
         * WARNING - void declaration
         */
        public void install(ISelectionProvider selectionProvider) {
            void var3_2;
            IPostSelectionProvider iPostSelectionProvider;
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider && (iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider) == (IPostSelectionProvider)var3_2) {
                void provider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void uninstall(ISelectionProvider selectionProvider) {
            void var3_2;
            IPostSelectionProvider iPostSelectionProvider;
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider && (iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider) == (IPostSelectionProvider)var3_2) {
                void provider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            HighlightReconcilingStrategy.this.updateHighlights(event.getSelection());
        }
    }
}

