/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;

public class Perspective {
    private final PerspectiveDescriptor descriptor;
    private final WorkbenchPage page;
    private final List<IActionSetDescriptor> alwaysOnActionSets;
    private final List<IActionSetDescriptor> alwaysOffActionSets;
    private final MPerspective layout;

    public Perspective(PerspectiveDescriptor desc, MPerspective layout, WorkbenchPage page) {
        Assert.isNotNull((Object)page);
        this.page = page;
        this.layout = layout;
        this.descriptor = desc;
        this.alwaysOnActionSets = new ArrayList<IActionSetDescriptor>(2);
        this.alwaysOffActionSets = new ArrayList<IActionSetDescriptor>(2);
    }

    public void initActionSets() {
        if (this.descriptor != null) {
            String[] hiddenIds;
            List<String> alwaysOn = ModeledPageLayout.getIds(this.layout, "persp.actionSet:");
            String hiddenIDs = this.page.getHiddenItems();
            ArrayList<String> alwaysOff = new ArrayList<String>();
            String[] stringArray = hiddenIds = hiddenIDs.split(",");
            int n = hiddenIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.startsWith("persp.hideActionSetSC:") && !alwaysOff.contains(id = id.substring("persp.hideActionSetSC:".length()))) {
                    alwaysOff.add(id);
                }
                ++n2;
            }
            alwaysOn.removeAll(alwaysOff);
            for (IActionSetDescriptor descriptor : this.createInitialActionSets(alwaysOn)) {
                if (this.alwaysOnActionSets.contains(descriptor)) continue;
                this.alwaysOnActionSets.add(descriptor);
            }
            for (IActionSetDescriptor descriptor : this.createInitialActionSets(alwaysOff)) {
                if (this.alwaysOffActionSets.contains(descriptor)) continue;
                this.alwaysOffActionSets.add(descriptor);
            }
        }
    }

    private List<IActionSetDescriptor> createInitialActionSets(List<String> ids) {
        ArrayList<IActionSetDescriptor> result = new ArrayList<IActionSetDescriptor>();
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        for (String id : ids) {
            IActionSetDescriptor desc = reg.findActionSet(id);
            if (desc == null) continue;
            result.add(desc);
        }
        return result;
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    public String[] getNewWizardShortcuts() {
        return this.page.getNewWizardShortcuts();
    }

    public String[] getPerspectiveShortcuts() {
        return this.page.getPerspectiveShortcuts();
    }

    public String[] getShowViewShortcuts() {
        return this.page.getShowViewShortcuts();
    }

    private void removeAlwaysOn(IActionSetDescriptor descriptor) {
        if (this.alwaysOnActionSets.contains(descriptor)) {
            this.alwaysOnActionSets.remove(descriptor);
            this.page.perspectiveActionSetChanged(this, descriptor, 3);
        }
    }

    private void addAlwaysOff(IActionSetDescriptor descriptor) {
        if (!this.alwaysOffActionSets.contains(descriptor)) {
            this.alwaysOffActionSets.add(descriptor);
            this.page.perspectiveActionSetChanged(this, descriptor, 0);
            this.removeAlwaysOn(descriptor);
        }
    }

    private void addAlwaysOn(IActionSetDescriptor descriptor) {
        if (!this.alwaysOnActionSets.contains(descriptor)) {
            this.alwaysOnActionSets.add(descriptor);
            this.page.perspectiveActionSetChanged(this, descriptor, 2);
            this.removeAlwaysOff(descriptor);
        }
    }

    private void removeAlwaysOff(IActionSetDescriptor descriptor) {
        if (this.alwaysOffActionSets.contains(descriptor)) {
            this.alwaysOffActionSets.remove(descriptor);
            this.page.perspectiveActionSetChanged(this, descriptor, 1);
        }
    }

    public void turnOnActionSets(IActionSetDescriptor[] newArray) {
        IActionSetDescriptor[] iActionSetDescriptorArray = newArray;
        int n = newArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor descriptor = iActionSetDescriptorArray[n2];
            this.addActionSet(descriptor);
            ++n2;
        }
    }

    public void turnOffActionSets(IActionSetDescriptor[] toDisable) {
        IActionSetDescriptor[] iActionSetDescriptorArray = toDisable;
        int n = toDisable.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor descriptor = iActionSetDescriptorArray[n2];
            this.turnOffActionSet(descriptor);
            ++n2;
        }
    }

    public void turnOffActionSet(IActionSetDescriptor toDisable) {
        this.removeActionSet(toDisable);
    }

    protected void addActionSet(IActionSetDescriptor newDesc) {
        IContextService service = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            service.deferUpdates(true);
            for (IActionSetDescriptor desc : this.alwaysOnActionSets) {
                if (!desc.getId().equals(newDesc.getId())) continue;
                this.removeAlwaysOn(desc);
                this.removeAlwaysOff(desc);
                break;
            }
            this.addAlwaysOn(newDesc);
            String actionSetID = newDesc.getId();
            String tag = "persp.actionSet:" + actionSetID;
            if (!this.layout.getTags().contains(tag)) {
                this.layout.getTags().add(tag);
            }
        }
        finally {
            service.deferUpdates(false);
        }
    }

    protected void removeActionSet(IActionSetDescriptor toRemove) {
        String id = toRemove.getId();
        IContextService service = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            service.deferUpdates(true);
            for (IActionSetDescriptor desc : this.alwaysOnActionSets) {
                if (!desc.getId().equals(id)) continue;
                this.removeAlwaysOn(desc);
                break;
            }
            for (IActionSetDescriptor desc : this.alwaysOffActionSets) {
                if (!desc.getId().equals(id)) continue;
                this.removeAlwaysOff(desc);
                break;
            }
            this.addAlwaysOff(toRemove);
        }
        finally {
            service.deferUpdates(false);
        }
    }

    public List<IActionSetDescriptor> getAlwaysOnActionSets() {
        return this.alwaysOnActionSets;
    }

    public List<IActionSetDescriptor> getAlwaysOffActionSets() {
        return this.alwaysOffActionSets;
    }

    public void updateActionBars() {
        this.page.getActionBars().getMenuManager().updateAll(true);
        this.page.resetToolBarLayout();
    }
}

