/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAstro {
    static IProject project;
    static IFolder pagesFolder;

    @BeforeAll
    public static void setUp() throws Exception {
        AllCleanRule.closeIntro();
        AllCleanRule.enableLogging();
        project = Utils.provisionTestProject("astro-app");
        ProcessBuilder builder = NodeJSManager.prepareNPMProcessBuilder((String[])new String[]{"install", "--no-bin-links", "--ignore-scripts"}).directory(project.getLocation().toFile());
        Process process = builder.start();
        System.out.println(builder.command().toString());
        String result = process.errorReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Error Stream: >>>\n" + result + "\n<<<");
        result = process.inputReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Output Stream: >>>\n" + result + "\n<<<");
        Assertions.assertEquals((int)0, (int)process.waitFor(), (String)"npm install didn't complete property");
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)project.exists());
        pagesFolder = project.getFolder("src").getFolder("pages");
        Assertions.assertTrue((boolean)pagesFolder.exists());
    }

    @BeforeEach
    public void setUpTestCase() {
        AllCleanRule.enableLogging();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        new AllCleanRule().afterEach(null);
    }

    @Test
    void testAstroPage() throws Exception {
        IFile indexPageFile = project.getFile("src/pages/index.astro");
        TextEditor indexPageEditor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)indexPageFile);
        Display display = indexPageEditor.getSite().getShell().getDisplay();
        IDocument doc = indexPageEditor.getDocumentProvider().getDocument((Object)indexPageEditor.getEditorInput());
        AtomicReference astroLS = new AtomicReference();
        DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            astroLS.set(LanguageServiceAccessor.getStartedWrappers((IDocument)doc, null, (boolean)false).stream().filter(w -> "org.eclipse.wildwebdeveloper.astro".equals(w.serverDefinition.id)).findFirst().orElse(null));
            return astroLS.get() != null && ((LanguageServerWrapper)astroLS.get()).isActive() && ((LanguageServerWrapper)astroLS.get()).isConnectedTo(LSPEclipseUtils.toUri((IDocument)doc));
        });
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            try {
                return Arrays.stream(indexPageFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)).anyMatch(marker -> marker.getAttribute("message", "").contains("'path' is declared but its value is never read"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }), (String)"Diagnostic not published in standalone component file");
        IFile baseLayoutFile = project.getFile("src/layouts/base.astro");
        Path baseLayoutPath = baseLayoutFile.getLocation().toPath();
        int offset = doc.get().indexOf("BaseLayout");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            try {
                TextDocumentPositionParams params = LSPEclipseUtils.toTextDocumentPosistionParams((int)offset, (IDocument)doc);
                LocationLink baseLayoutDefinitionLink = ((List)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)doc).withCapability(ServerCapabilities::getDefinitionProvider)).collectAll(ls -> ls.getTextDocumentService().definition(LSPEclipseUtils.toDefinitionParams((TextDocumentPositionParams)params))).get(1L, TimeUnit.SECONDS)).stream().filter(Either::isRight).flatMap(e -> ((List)e.getRight()).stream()).filter(locationLink -> Paths.get(URI.create(locationLink.getTargetUri())).equals(baseLayoutPath)).findFirst().orElse(null);
                return baseLayoutDefinitionLink != null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }));
        display.syncExec(() -> {
            try {
                indexPageEditor.selectAndReveal(offset, 0);
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                ITextViewer viewer = (ITextViewer)getSourceViewerMethod.invoke((Object)indexPageEditor, new Object[0]);
                StyledText widget = viewer.getTextWidget();
                Event keyDown = new Event();
                keyDown.type = 1;
                keyDown.keyCode = 0x100000C;
                keyDown.widget = widget;
                widget.notifyListeners(1, keyDown);
                Event keyUp = new Event();
                keyUp.type = 2;
                keyUp.keyCode = 0x100000C;
                keyUp.widget = widget;
                widget.notifyListeners(2, keyUp);
            }
            catch (Exception ex) {
                Assertions.fail((Throwable)ex);
            }
        });
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            TextEditor baseLayoutEditor = (TextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new FileEditorInput(baseLayoutFile));
            if (baseLayoutEditor != null) {
                baseLayoutEditor.close(false);
                return true;
            }
            return false;
        }));
        indexPageEditor.close(false);
    }
}

