/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef POWERSCHEME_H
#define POWERSCHEME_H

#include "common.h"
#include <QString>
#include <QLibrary>

class Scheme
{
public:
    Scheme();
    explicit Scheme(GUID g, const QString &name);
    ~Scheme();

    void setGUID(GUID g);
    void setName(const QString &name);

    GUID guid() const;
    QString name() const;

private:
    GUID m_guid;
    QString m_name;
};

#if (defined (Q_OS_WIN32) && (WINVER >= 0x0600))
class PowerScheme
{
private:
    //types and definitions
    typedef DWORD (*power_set_active_scheme_t)(
        HKEY UserRootPowerKey,
        const GUID *SchemeGuid
        );

    typedef DWORD (*power_get_active_scheme_t)(
        HKEY UserRootPowerKey,
        GUID **ActivePolicyGuid
        );

public:
    PowerScheme();
    ~PowerScheme();

    bool powrProfLoaded() const;

    void setMinPower();
    void setMaxPower();
    void setBalanced();

    bool isMinPower() const;
    bool isMaxPower() const;
    bool isBalanced() const;

private:
    QLibrary m_lib_powrprof;
    power_set_active_scheme_t m_power_set_active_scheme;
    power_get_active_scheme_t m_power_get_active_scheme;
};
#endif

#endif // POWERSCHEME_H
