/**********************************************************************
 *
 *    FILE:            AnimationPath.cpp
 *
 *    DESCRIPTION:    Read/Write osg::AnimationPath in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerate
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 25.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "AnimationPath.h"
#include "Object.h"

using namespace ive;

void AnimationPath::write(DataOutputStream* out){
    // Write AnimationPath's identification.
    out->writeInt(IVEANIMATIONPATH);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("AnimationPath::write(): Could not cast this osg::AnimationPath to an osg::Object.");
    // Write AnimationPath's properties.

    // Write loopmode
    out->writeInt(getLoopMode());
    // Write control points
    AnimationPath::TimeControlPointMap tcpm = getTimeControlPointMap();
    out->writeInt(tcpm.size());
    for(AnimationPath::TimeControlPointMap::iterator itr=tcpm.begin(); itr!=tcpm.end(); ++itr){
        out->writeFloat(itr->first);
        out->writeVec3(itr->second.getPosition());
        out->writeQuat(itr->second.getRotation());
        out->writeVec3(itr->second.getScale());
    }
}

void AnimationPath::read(DataInputStream* in){
    // Peek on AnimationPath's identification.
    int id = in->peekInt();
    if(id == IVEANIMATIONPATH){
        // Read AnimationPath's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("AnimationPath::read(): Could not cast this osg::AnimationPath to an osg::Object.");
        // Read AnimationPath's properties

        // Read loopmode
        setLoopMode((osg::AnimationPath::LoopMode)in->readInt());
        // Read control points
        int size = in->readInt();
        for(int i=0;i<size;i++){
            float time = in->readFloat();
            osg::Vec3 pos = in->readVec3();
            osg::Quat rot = in->readQuat();
            osg::Vec3 scale = in->readVec3();
            insert(time, osg::AnimationPath::ControlPoint(pos, rot, scale));
        }
    }
    else{
        in_THROW_EXCEPTION("AnimationPath::read(): Expected AnimationPath identification.");
    }
}
