/* ====================================================================
 * Copyright (c) 2002 Johnny Shelley.  All rights reserved.
 *
 * Bcrypt is licensed under the BSD software license. See the file 
 * called 'LICENSE' that you should have received with this software
 * for details
 * ====================================================================
 */

#include "includes.h"
#include "blowfish.h"

/* from wrapbf.c */
off_t BFEncrypt(FILE *infd, FILE *outfd, char *key, BCoptions *options);
off_t BFDecrypt(FILE *infd, FILE *outfd, char *key, char *key2, BCoptions *options);

/* from keys.c */
char * getkey(int type);
void mutateKey(char **key, char **key2);

/* from rwfile.c */
int getremain(uLong sz, int dv);
int deletefile(char *file, BCoptions options, char *key, struct stat statbuf);

/* from main.c */
BCoptions initoptions(BCoptions options);
int usage(char *name);
int memerror();
int parseArgs(int *argc, char **argv, BCoptions *options);
int assignFiles(char *arg, char **infile, char **outfile, struct stat *statbuf,
        BCoptions *options, char *key);
int main(int argc, char *argv[]);

/* from endian.c */
void getEndian(uint8_t **e);
uint32_t swapEndian(uint32_t value);
int testEndian(uint8_t *input);
int swapCompressed(uint8_t **input, uLong sz);

