/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : DII_TEST
    Description : Test class for GNU/EDMA DII
    Author      : David Martnez Oliveira
    Date        : July, 13th, 2003
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class DII_TEST
***************************************************
*/
 
typedef struct
{
	ESint32		num;
	EPChar		str;
}DtDII_TEST;
/*
***************************************************
  Method Declaration for class DII_TEST
***************************************************
*/
 
ESint32 EDMAPROC
DII_TESTtest_in_intS32U32S16U16S8U8rS32(OBJID IdObj, ESint32 sin32, EUint32 uin32, 
					ESint16 sin16, EUint16 uin16, ESint8 sin8, EUint8 uin8)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] Signed 32-bit parameter   : %d", __FUNCTION__, sin32);
  edma_printf_obj (IdObj, "[%s] Unsigned 32-bit parameter : %d", __FUNCTION__, uin32);

  edma_printf_obj (IdObj, "[%s] Signed 16-bit parameter   : %d", __FUNCTION__, sin16);
  edma_printf_obj (IdObj, "[%s] Unsigned 16-bit parameter : %d", __FUNCTION__, uin16);

  edma_printf_obj (IdObj, "[%s] Signed 8-bit parameter   : %d", __FUNCTION__, sin8);
  edma_printf_obj (IdObj, "[%s] Unsigned 8-bit parameter : %d", __FUNCTION__, uin8);

  return 0;
}


ESint32 EDMAPROC
DII_TESTtest_in_realR32R64rS32(OBJID IdObj, EReal32 re32, EReal64 re64)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] Real 32-bit parameter : %f", __FUNCTION__, re32);
  edma_printf_obj (IdObj, "[%s] Real 64-bit parameter : %lf", __FUNCTION__, re64);

  return 0;
}


ESint32 EDMAPROC
DII_TESTtest_in_mixedS8U32R32S32S32(OBJID IdObj, ESint8 sin8, EUint32 uin32,
				    EReal32 re32, ESint32 sin32)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "[%s] Signed 8-bit parameter   : %d", __FUNCTION__, sin8);
  edma_printf_obj (IdObj, "[%s] Unsigned 32-bit parameter : %d", __FUNCTION__, uin32);
  edma_printf_obj (IdObj, "[%s] Real 32-bit parameter : %f", __FUNCTION__, re32);
  edma_printf_obj (IdObj, "[%s] Signed 32-bit parameter   : %d", __FUNCTION__, sin32);

}


void EDMAPROC
DII_TESTtest_out_intsS8sU32sS32(OBJID IdObj, EPSint8 sin8, EPUint32 uin32, EPSint32 sin32)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);
  
  edma_printf_obj (IdObj, "[%s] Parameter pointer received: %p - %p - %p", 
		   __FUNCTION__, sin8, uin32, sin32);
#if 1
  edma_printf_obj (IdObj, "[%s] Input Signed 8-bit Integer is    : %d ", __FUNCTION__, *sin8);
  edma_printf_obj (IdObj, "[%s] Input UnSigned 32-bit Integer is : %d ", __FUNCTION__, *uin32);
  edma_printf_obj (IdObj, "[%s] Input Signed 32-bit Integer is   : %d ", __FUNCTION__, *sin32);
  *sin8 = 1;
  *uin32 = 2;
  *sin32 = 3;
  
#endif

}


ESint32 EDMAPROC
DII_TESTtest_out_realsR32sR64rS32(OBJID IdObj, EPReal32 r32, EPReal64 r64)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] Values received -> r32:%lf r64:%lf", __FUNCTION__, *r32, *r64);
  
  *r32 += 10;
  *r64 += 10;

  return 0;
}


ESint32 EDMAPROC
DII_TESTtest_in_otherZOZrS32(OBJID IdObj, EPChar str1, OBJID id, EPChar str2)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] First Input String is  : '%s'", __FUNCTION__, str1);
  edma_printf_obj (IdObj, "[%s] Second Input String is : '%s'", __FUNCTION__, str2);
  edma_printf_obj (IdObj, "[%s] Object Input Param is  : %d ==> Object Report follows", 
		   __FUNCTION__, id);
  edma_obj_report (id);

  return 0;
}


ESint32 EDMAPROC
DII_TESTtest_out_othersZsOsZrS32(OBJID IdObj, EPChar str1, OBJID *id, EPChar str2)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] First Input String is: '%s'", __FUNCTION__, str1);
  edma_printf_obj (IdObj, "[%s] Second Input String is : '%s'", __FUNCTION__, str2);
  edma_printf_obj (IdObj, "[%s] Object Input Param is  : %d ==> Object Report follows", 
		   __FUNCTION__, *id);
  edma_obj_report (*id);

  /* Change output parameters */
  strcpy (str1, "Parameter 1 Changed!");
  strcpy (str2, "Parameter 2 Changed!");
  *id = -1;

  return 0;
}


ESint32 EDMAPROC
DII_TESTtest_inoutsR64ZsZS32sA(OBJID IdObj, EPReal64 re64, EPChar str1, EPChar str2, ESint32 si32, EDMAT_BUFFER buf)
{
  DtDII_TEST	*m;

  m = (DtDII_TEST *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "[%s] Input Real 64-bits : %lf", __FUNCTION__, *re64);
  edma_printf_obj (IdObj, "[%s] Input string       :'%s'", __FUNCTION__, str1);
  edma_printf_obj (IdObj, "[%s] Input string       :'%s'", __FUNCTION__, str2);
  edma_printf_obj (IdObj, "[%s] Input Int 32-bits  : %d",  __FUNCTION__, si32);

  *re64 += 20;
  strcpy (str2, "String parameter changed!");

  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
