/*
 * Electric(tm) VLSI Design System
 *
 * File: tecart.h
 * Artwork technology header
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#define	ELLIPSEPOINTS         30		/* number of lines in an ellipse */

/* the state bits */
#define	ARTWORKFILLARROWHEADS  1		/* set to fill arrow heads */

/* all of the artwork primitives */
extern TECHNOLOGY *art_tech;						/* the technology */

extern NODEPROTO  *art_pinprim;						/* Pin */
extern NODEPROTO  *art_boxprim;						/* Box */
extern NODEPROTO  *art_crossedboxprim;				/* Crossed-Box */
extern NODEPROTO  *art_filledboxprim;				/* Filled-Box */
extern NODEPROTO  *art_circleprim;					/* Circle */
extern NODEPROTO  *art_filledcircleprim;			/* Filled-Circle */
extern NODEPROTO  *art_splineprim;					/* Spline */
extern NODEPROTO  *art_triangleprim;				/* Triangle */
extern NODEPROTO  *art_filledtriangleprim;			/* Filled-Triangle */
extern NODEPROTO  *art_arrowprim;					/* Arrow */
extern NODEPROTO  *art_openedpolygonprim;			/* Opened-Polygon */
extern NODEPROTO  *art_openeddottedpolygonprim;		/* Opened-Dotted-Polygon */
extern NODEPROTO  *art_openeddashedpolygonprim;		/* Opened-Dashed-Polygon */
extern NODEPROTO  *art_openedfardottepolygonprim;	/* Opened-FarDotted-Polygon */
extern NODEPROTO  *art_closedpolygonprim;			/* Closed-Polygon */
extern NODEPROTO  *art_filledpolygonprim;			/* Filled-Polygon */

extern ARCPROTO   *art_solidarc;					/* solid arc */
extern ARCPROTO   *art_dash1arc;					/* dash type 1 arc */
extern ARCPROTO   *art_dash2arc;					/* dash type 2 arc */
extern ARCPROTO   *art_dash3arc;					/* dash type 3 arc */

extern INTBIG      art_messagekey;					/* key for "ART_message" */
extern INTBIG      art_colorkey;					/* key for "ART_color" */
extern INTBIG      art_degreeskey;					/* key for "ART_degrees" */
extern INTBIG      art_patternkey;					/* key for "ART_pattern" */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* prototypes for technology routines */
INTSML art_initprocess(TECHNOLOGY*, INTSML);
void art_setmode(INTSML, char*[]);
INTBIG art_request(char*, va_list);
INTSML art_nodepolys(NODEINST*);
INTSML art_nodeEpolys(NODEINST*);
void art_shapenodepoly(NODEINST*, INTSML, POLYGON*);
void art_shapeEnodepoly(NODEINST*, INTSML, POLYGON*);
void art_shapeportpoly(NODEINST*, PORTPROTO*, POLYGON*, XARRAY, INTSML);
INTSML art_arcpolys(ARCINST*);
void art_shapearcpoly(ARCINST*, INTSML, POLYGON*);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
