/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.EpicSignal;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Pattern;

class EpicReader {
    String filePath;
    InputStream inputStream;
    long fileLength;
    long byteCount;
    byte[] buf = new byte[65536];
    int bufL;
    int bufP;
    StringBuffer builder = new StringBuffer();
    Pattern whiteSpace = Pattern.compile("[ \t]+");
    int timesC = 0;
    int eventsC = 0;
    ArrayList signals = new ArrayList();
    int numSignals = 0;
    double timeResolution;
    double voltageResolution;
    double currentResolution;
    int curTime = 0;
    int maxT = 0;
    private static String VERSION_STRING;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpicReader(URL fileURL) {
        try {
            this.readFile(fileURL);
        }
        finally {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    boolean readFile(URL fileURL) {
        this.filePath = fileURL.getFile();
        long startTime = System.currentTimeMillis();
        URLConnection urlCon = null;
        try {
            urlCon = fileURL.openConnection();
            String contentLength = urlCon.getHeaderField("content-length");
            this.fileLength = -1L;
            try {
                this.fileLength = Long.parseLong(contentLength);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0L;
        try {
            String firstLine = this.getLine();
            if (firstLine == null || !firstLine.equals(VERSION_STRING)) {
                System.out.println("Unknown Epic Version: " + firstLine);
            }
            while (this.bufP < this.bufL || !this.readBuf()) {
                int startLine = this.bufP;
                if (this.parseNumLineFast()) continue;
                this.bufP = startLine;
                String line = this.getLine();
                if (line != null) {
                    this.parseNumLine(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long memLength = 0L;
        for (int i = 0; i < this.signals.size(); ++i) {
            EpicSignal s = (EpicSignal)this.signals.get(i);
            if (s == null) continue;
            memLength += (long)s.len;
        }
        System.out.println((double)(stopTime - startTime) / 1000.0 + " sec " + this.byteCount + " bytes " + this.numSignals + " signals " + this.timesC + " timepoints " + this.eventsC + " events " + memLength + " bytes in memory");
        return false;
    }

    private void parseNumLine(String line) {
        if (line.length() == 0) {
            return;
        }
        char ch = line.charAt(0);
        if (ch == '.') {
            String[] split = this.whiteSpace.split(line);
            if (split[0].equals(".index") && split.length == 4) {
                int type;
                if (split[3].equals("v")) {
                    type = 1;
                } else if (split[3].equals("i")) {
                    type = 2;
                } else {
                    System.out.println("Unknown waveform type: " + line);
                    return;
                }
                String name = split[1];
                int sigNum = TextUtils.atoi(split[2]);
                while (this.signals.size() <= sigNum) {
                    this.signals.add(null);
                }
                EpicSignal s = (EpicSignal)this.signals.get(sigNum);
                if (s == null) {
                    s = new EpicSignal();
                    this.signals.set(sigNum, s);
                    ++this.numSignals;
                }
                s.name = name;
                s.type = type;
            } else if (!split[0].equals(".vdd") || split.length != 2) {
                if (split[0].equals(".time_resolution") && split.length == 2) {
                    this.timeResolution = TextUtils.atof(split[1]) * 1.0E-9;
                } else if (split[0].equals(".current_resolution") && split.length == 2) {
                    this.currentResolution = TextUtils.atof(split[1]);
                } else if (split[0].equals(".voltage_resolution") && split.length == 2) {
                    this.voltageResolution = TextUtils.atof(split[1]);
                } else if (!(split[0].equals(".high_threshold") && split.length == 2 || split[0].equals(".low_threshold") && split.length == 2 || split[0].equals(".nnodes") && split.length == 2 || split[0].equals(".nelems") && split.length == 2 || split[0].equals(".extra_nodes") && split.length == 2 || split[0].equals(".bus_notation") && split.length == 4 || split[0].equals(".hier_separator") && split.length == 2 || split[0].equals(".case") && split.length == 2)) {
                    System.out.println("Unrecognized Epic line: " + line);
                }
            }
        } else if (ch >= '0' || ch <= '9') {
            String[] split = this.whiteSpace.split(line);
            int num = TextUtils.atoi(split[0]);
            if (split.length > 1) {
                this.putValue(num, TextUtils.atoi(split[1]));
            } else {
                this.putTime(num);
            }
        } else if (ch != ';' && !Character.isSpaceChar(ch)) {
            System.out.println("Unrecognized Epic line: " + line);
        }
    }

    private boolean parseNumLineFast() {
        byte ch;
        if (this.bufP + 20 >= this.bufL) {
            return false;
        }
        if ((ch = this.buf[this.bufP++]) < 48 || ch > 57) {
            return false;
        }
        int num1 = ch - 48;
        int lim = this.bufP + 9;
        while (this.bufP < lim && (ch = this.buf[this.bufP++]) >= 48 && ch <= 57) {
            num1 = num1 * 10 + (ch - 48);
        }
        boolean twoNumbers = false;
        int num2 = 0;
        if (ch == 32) {
            ch = this.buf[this.bufP++];
            boolean sign = false;
            if (ch == 45) {
                sign = true;
                ch = this.buf[this.bufP++];
            }
            if (ch < 48 || ch > 57) {
                return false;
            }
            num2 = ch - 48;
            int lim2 = this.bufP + 9;
            while (this.bufP < lim2 && (ch = this.buf[this.bufP++]) >= 48 && ch <= 57) {
                num2 = num2 * 10 + (ch - 48);
            }
            if (sign) {
                num2 = -num2;
            }
            twoNumbers = true;
        }
        if (ch != 10) {
            if (ch == 13) {
                if (this.buf[this.bufP] == 10) {
                    ++this.bufP;
                }
            } else {
                return false;
            }
        }
        if (twoNumbers) {
            this.putValue(num1, num2);
        } else {
            this.putTime(num1);
        }
        return true;
    }

    private void putTime(int time) {
        ++this.timesC;
        this.maxT = this.curTime = Math.max(this.curTime, time);
    }

    void putValue(int sigNum, int value) {
        ++this.eventsC;
        while (this.signals.size() <= sigNum) {
            this.signals.add(null);
        }
        EpicSignal s = (EpicSignal)this.signals.get(sigNum);
        if (s == null) {
            s = new EpicSignal();
            this.signals.set(sigNum, s);
            ++this.numSignals;
        }
        s.putEvent(this.curTime, value);
    }

    private String getLine() throws IOException {
        this.builder.setLength(0);
        while (true) {
            if (this.bufP < this.bufL) {
                int ch;
                if ((ch = this.buf[this.bufP++] & 0xFF) == 10) {
                    return this.builder.toString();
                }
                if (ch == 13) {
                    if (this.bufP == this.bufL) {
                        this.readBuf();
                    }
                    if (this.bufP < this.bufL && this.buf[this.bufP] == 10) {
                        ++this.bufP;
                    }
                    return this.builder.toString();
                }
                this.builder.append((char)ch);
                continue;
            }
            if (this.readBuf()) break;
        }
        return this.builder.length() != 0 ? this.builder.toString() : null;
    }

    private boolean readBuf() throws IOException {
        if (!$assertionsDisabled && this.bufP != this.bufL) {
            throw new AssertionError();
        }
        this.bufL = 0;
        this.bufP = 0;
        this.bufL = this.inputStream.read(this.buf, 0, this.buf.length);
        if (this.bufL <= 0) {
            this.bufL = 0;
            return true;
        }
        this.byteCount += (long)this.bufL;
        this.showProgress(this.fileLength != 0L ? (double)this.byteCount / (double)this.fileLength : 0.0);
        return false;
    }

    void showProgress(double ratio) {
    }

    static {
        $assertionsDisabled = !EpicReader.class.desiredAssertionStatus();
        VERSION_STRING = ";! output_format 5.3";
    }
}

