/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.projectSettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjSettings {
    private static ProjSettingsNode settings = new ProjSettingsNode();
    private static File lastProjectSettingsFile = null;
    private static final String entry = "e";
    private static final boolean READER_RESETS_DEFAULTS = true;
    private static final boolean WRITER_WRITES_DEFAULTS = true;

    public static ProjSettingsNode getSettings() {
        return settings;
    }

    public static void putValue(Setting setting) {
        int pos;
        String xmlPath = setting.getXmlPath();
        ProjSettingsNode node = ProjSettings.getSettings();
        while ((pos = xmlPath.indexOf(46)) >= 0) {
            String key = xmlPath.substring(0, pos);
            node = node.getNode(key);
            xmlPath = xmlPath.substring(pos + 1);
        }
        node.putValue(xmlPath, setting);
    }

    public static void writeSettings(File file) {
        ProjSettings.write(file.getPath(), ProjSettings.getSettings());
    }

    public static File getLastProjectSettingsFile() {
        return lastProjectSettingsFile;
    }

    public static void readSettings(File file, boolean allowOverride) {
        ReadResult result;
        if (lastProjectSettingsFile == null) {
            allowOverride = true;
        }
        if ((result = ProjSettings.read(file.getPath(), allowOverride)) == ReadResult.ERROR) {
            return;
        }
        if (result == ReadResult.CONFLICTS && lastProjectSettingsFile != null) {
            String message = "Warning: Project Settings conflicts;" + (allowOverride ? "" : " ignoring new settings.") + " See messages window";
            Job.getUserInterface().showInformationMessage(message, "Project Settings Conflict");
            System.out.println("Project Setting conflicts found: " + lastProjectSettingsFile.getPath() + " vs " + file.getPath());
        }
        lastProjectSettingsFile = file;
    }

    public static void exportSettings() {
        File outputFile = new File(FileType.LIBRARYFORMATS.getGroupPath(), "projsettings.xml");
        String ofile = OpenFile.chooseOutputFile(FileType.XML, "Export Project Settings", outputFile.getPath());
        if (ofile == null) {
            return;
        }
        outputFile = new File(ofile);
        ProjSettings.writeSettings(outputFile);
    }

    public static void importSettings() {
        String ifile = OpenFile.chooseInputFile(FileType.XML, "Import Project Settings", false, FileType.LIBRARYFORMATS.getGroupPath(), false);
        if (ifile == null) {
            return;
        }
        new ImportSettingsJob(ifile);
    }

    private static void write(String file, ProjSettingsNode node) {
        File ofile = new File(file);
        Writer wr = new Writer(ofile);
        if (wr.write("ProjectSettings", node)) {
            System.out.println("Wrote Project Settings to " + file);
            lastProjectSettingsFile = ofile;
        }
        wr.close();
    }

    private static ReadResult read(String file, boolean allowOverride) {
        Reader rd = new Reader(TextUtils.makeURLToFile(file));
        ReadResult r = rd.read(allowOverride);
        System.out.println("Read Project Settings from " + file);
        return r;
    }

    private static String replaceSpecialChars(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("=", "&eq;");
        str = str.replace(">", "&gt;");
        str = str.replace("<", "&lt;");
        str = str.replace("'", "&apos;");
        str = str.replace("\"", "&quot;");
        str = str.replace("\n", "&#xA;");
        return str;
    }

    public static String describeContext(Stack<String> context) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String name : context) {
            if (first) {
                first = false;
            } else {
                buf.append(".");
            }
            buf.append(name);
        }
        if (buf.length() == 0) {
            return "RootContext";
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        ProjSettings.test();
    }

    public static void test() {
        ProjSettings.write("/tmp/projsettings.xml", ProjSettings.getSettings());
        ProjSettings.read("/tmp/projsettings.xml", false);
    }

    protected static class TestExtendNode
    extends ProjSettingsNode {
        protected TestExtendNode() {
        }
    }

    private static class Reader
    extends DefaultHandler {
        private URL url;
        private Stack<ProjSettingsNode> context;
        private Locator locator;
        private boolean allowOverride;
        private boolean differencesFound;
        private HashMap<Setting, Object> settings = new HashMap();
        private static final boolean DEBUG = false;

        private Reader(URL url) {
            this.url = url;
            this.context = new Stack();
            this.locator = null;
            this.allowOverride = true;
            this.differencesFound = false;
        }

        private ReadResult read(boolean allowOverride) {
            this.allowOverride = allowOverride;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                URLConnection conn = this.url.openConnection();
                InputStream is = conn.getInputStream();
                factory.newSAXParser().parse(is, (DefaultHandler)this);
                this.commit(ProjSettings.getSettings());
                if (this.differencesFound) {
                    return ReadResult.CONFLICTS;
                }
                return ReadResult.OK;
            }
            catch (IOException e) {
                System.out.println("Error reading file " + this.url.toString() + ": " + e.getMessage());
            }
            catch (SAXParseException e) {
                System.out.println("Error parsing file " + this.url.toString() + " on line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ": " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                System.out.println("Configuration error reading file " + this.url.toString() + ": " + e.getMessage());
            }
            catch (SAXException e) {
                System.out.println("Exception reading file " + this.url.toString() + ": " + e.getMessage());
            }
            return ReadResult.ERROR;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String key = attributes.getValue("key");
            if (key == null) {
                throw this.parseException("Entry " + qName + " is missing \"key\" attribute");
            }
            if (qName.equals("node")) {
                if (this.context.isEmpty()) {
                    this.context.push(ProjSettings.getSettings());
                } else {
                    ProjSettingsNode node = this.context.peek().getNode(key);
                    if (node == null) {
                        System.out.println("Error: No Project Settings Node named " + key + " in Electric");
                    } else {
                        this.context.push(node);
                    }
                }
            } else if (qName.equals(ProjSettings.entry)) {
                if (this.context.isEmpty()) {
                    throw this.parseException("No node for key-value pair " + qName);
                }
                ProjSettingsNode currentNode = this.context.peek();
                String valueStr = null;
                Object value = null;
                Setting setting = currentNode.getValue(key);
                try {
                    valueStr = attributes.getValue("string");
                    if (valueStr != null) {
                        value = valueStr;
                    } else {
                        valueStr = attributes.getValue("int");
                        if (valueStr != null) {
                            value = Integer.valueOf(valueStr);
                        } else {
                            valueStr = attributes.getValue("double");
                            if (valueStr != null) {
                                value = Double.valueOf(valueStr);
                            } else {
                                valueStr = attributes.getValue("boolean");
                                if (valueStr != null) {
                                    value = Boolean.valueOf(valueStr);
                                } else {
                                    valueStr = attributes.getValue("long");
                                    if (valueStr != null) {
                                        value = Long.valueOf(valueStr);
                                    } else {
                                        System.out.println("Error: Unsupported value for key " + key + ", at line " + this.locator.getLineNumber() + ": must be string, int, double, boolean, or long");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Error converting " + valueStr + " to a number at line " + this.locator.getLineNumber() + ": " + e.getMessage());
                }
                if (value != null) {
                    if (setting != null) {
                        this.settings.put(setting, value);
                    } else if (this.allowOverride) {
                        currentNode.put(key, new ProjSettingsNode.UninitializedPref(value));
                    }
                }
            }
        }

        private void commit(ProjSettingsNode node) {
            for (Object v : node.data.values()) {
                if (v instanceof Setting) {
                    Setting setting = (Setting)v;
                    Object value = this.settings.get(setting);
                    if (value == null) {
                        value = setting.getFactoryValue();
                    }
                    this.prDiff(setting, setting.getValue(), value, this.allowOverride);
                    if (!this.allowOverride) continue;
                    setting.set(value);
                    continue;
                }
                if (!(v instanceof ProjSettingsNode)) continue;
                this.commit((ProjSettingsNode)v);
            }
        }

        private boolean commit0() {
            for (Map.Entry<Setting, Object> e : this.settings.entrySet()) {
                Setting setting = e.getKey();
                Object value = e.getValue();
                this.prDiff(setting, setting.getValue(), value, this.allowOverride);
                if (!this.allowOverride) continue;
                setting.set(value);
            }
            return this.differencesFound;
        }

        private void prDiff(Setting setting, Object prefVal, Object xmlVal, boolean allowOverride) {
            if (!ProjSettingsNode.equal(xmlVal, setting)) {
                this.differencesFound = true;
                if (allowOverride) {
                    System.out.println("Warning: Setting \"" + setting.getPrefName() + "\" set to " + xmlVal + ", overrides current val of " + prefVal);
                } else {
                    System.out.println("Warning: Setting \"" + setting.getPrefName() + "\" retains current val of " + prefVal + ", while ignoring projectsettings.xml value of " + xmlVal);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("node")) {
                if (this.context.isEmpty()) {
                    throw this.parseException("Empty context, too many closing </> brackets");
                }
                this.context.pop();
            }
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private SAXParseException parseException(String msg) {
            return new SAXParseException(msg, this.locator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadResult {
        OK,
        CONFLICTS,
        ERROR;

    }

    private static class Writer {
        private File file;
        PrintWriter out;
        private int indent;
        private static final int indentVal = 4;
        Set<Object> visited = new HashSet<Object>();

        private Writer(File file) {
            this.file = file;
        }

        private boolean write(String nodeName, ProjSettingsNode node) {
            this.out = new PrintWriter(new BufferedOutputStream(System.out));
            if (this.file != null) {
                try {
                    this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.file)));
                }
                catch (IOException e) {
                    System.out.println("Error opening " + this.file + " for write: " + e.getMessage());
                    this.file = null;
                    return false;
                }
            }
            this.writeNode(nodeName, node);
            return true;
        }

        private void prIndent(String msg) {
            for (int i = 0; i < this.indent * 4; ++i) {
                this.out.print(" ");
            }
            this.out.println(msg);
        }

        private void writeNode(String name, ProjSettingsNode node) {
            if (this.visited.contains(node)) {
                System.out.println("ERROR: recursive loop in Project Settings; ignoring second instantiation of ProjSettingsNode \"" + name + "\".");
                return;
            }
            this.visited.add(node);
            String classDef = "";
            if (node.getKeys().size() != 0) {
                this.prIndent("<node key=\"" + name + "\"" + classDef + ">");
                ++this.indent;
                for (String key : node.getKeys()) {
                    this.writeSetting(key, node.get(key));
                }
                --this.indent;
                this.prIndent("</node>");
            }
        }

        private void writeSetting(String key, Object value) {
            if (value instanceof ProjSettingsNode) {
                ProjSettingsNode node = (ProjSettingsNode)value;
                this.writeNode(key, node);
            } else if (value instanceof Setting) {
                Setting setting = (Setting)value;
                Object val = setting.getValue();
                this.writeValue(key, val);
            } else if (value instanceof ProjSettingsNode.UninitializedPref) {
                ProjSettingsNode.UninitializedPref pref = (ProjSettingsNode.UninitializedPref)value;
                this.writeValue(key, pref.value);
            } else {
                System.out.println("Ignoring unsupported class " + value.getClass().getName() + " for key " + key + " in project settings");
            }
        }

        private void writeValue(String key, Object value) {
            if (value instanceof Integer) {
                this.prIndent("<e key=\"" + key + "\"\t int=\"" + value.toString() + "\" />");
            } else if (value instanceof Double) {
                this.prIndent("<e key=\"" + key + "\"\t double=\"" + value.toString() + "\" />");
            } else if (value instanceof Long) {
                this.prIndent("<e key=\"" + key + "\"\t long=\"" + value.toString() + "\" />");
            } else if (value instanceof Boolean) {
                this.prIndent("<e key=\"" + key + "\"\t boolean=\"" + value.toString() + "\" />");
            } else if (value instanceof String) {
                String str = (String)value;
                this.prIndent("<e key=\"" + key + "\"\t string=\"" + ProjSettings.replaceSpecialChars(str) + "\" />");
            } else {
                this.prIndent("<e key=\"" + key + "\"\t string=\"" + value + "\" />");
            }
        }

        private void close() {
            if (this.file != null) {
                this.out.close();
            }
        }
    }

    public static class ImportSettingsJob
    extends Job {
        private String fileName;

        public ImportSettingsJob(String fileName) {
            super("Import Settings", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileName = fileName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            ProjSettings.readSettings(new File(this.fileName), true);
            return true;
        }
    }
}

