/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PadGenerator {
    private Library destLib;
    private String fileName;
    private Dimension2D alignment;
    private String padframename;
    private String corename;
    private int lineno;
    private Library cellLib;
    private boolean copycells;
    private List<View> views;
    private int angle;
    private HashMap<String, ArrayAlign> alignments;
    private HashMap<String, PadExports> exports;
    private List<Object> orderedCommands;
    private boolean coreAllOnOneSide = false;

    public static void makePadFrame(Library destLib, String fileName) {
        if (fileName == null) {
            return;
        }
        EditingPreferences ep = destLib.getEditingPreferences();
        new MakePadFrame(destLib, fileName, ep.getAlignmentToGrid());
    }

    public static Cell makePadFrameUseJob(Library destLib, String fileName, Dimension2D alignment, Job job) {
        PadGenerator pg = new PadGenerator(destLib, fileName, alignment);
        return pg.makePadFrame(job);
    }

    private PadGenerator(Library destLib, String fileName, Dimension2D alignment) {
        this.destLib = destLib;
        this.fileName = fileName;
        this.alignment = alignment;
        this.alignments = new HashMap();
        this.exports = new HashMap();
        this.views = new ArrayList<View>();
        this.angle = 0;
        this.lineno = 1;
        this.orderedCommands = new ArrayList<Object>();
    }

    private Cell makePadFrame(Job job) {
        File inputFile = new File(this.fileName);
        if (inputFile == null || !inputFile.canRead()) {
            System.out.println("Error reading file " + this.fileName);
            return null;
        }
        try {
            FileReader readFile = new FileReader(inputFile);
            BufferedReader readLine = new BufferedReader(readFile);
            String lineRead = readLine.readLine();
            while (lineRead != null) {
                String keyWord;
                StringTokenizer str = new StringTokenizer(lineRead, " \t");
                if (str.hasMoreTokens() && (keyWord = str.nextToken()).charAt(0) != ';') {
                    do {
                        if (keyWord.equals("celllibrary")) {
                            if (this.processCellLibrary(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("views")) {
                            if (this.processViews(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("cell")) {
                            if (this.processCell(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("core")) {
                            if (this.processCore(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("rotate")) {
                            if (this.processRotate(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("reverse")) {
                            if (this.processReverse(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("align")) {
                            if (this.processAlign(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("export")) {
                            if (this.processExport(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("place")) {
                            if (this.processPlace(str)) continue;
                            return null;
                        }
                        if (keyWord.equals("coreExportsAllOnOneSideOfIcon")) {
                            this.coreAllOnOneSide = true;
                            continue;
                        }
                        System.out.println("Line " + this.lineno + ": unknown keyword'" + keyWord + "'");
                        break;
                    } while (str.hasMoreTokens());
                }
                lineRead = readLine.readLine();
                ++this.lineno;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        Cell frameCell = this.createPadFrames(job);
        return frameCell;
    }

    private boolean processCellLibrary(StringTokenizer str) {
        String keyWord;
        if (str.hasMoreTokens()) {
            keyWord = str.nextToken();
            URL fileURL = TextUtils.makeURLToFile(keyWord);
            this.cellLib = Library.findLibrary(TextUtils.getFileNameWithoutExtension(fileURL));
            if (this.cellLib == null) {
                StringBuilder errmsg = new StringBuilder();
                String fileDir = TextUtils.getFilePath(TextUtils.makeURLToFile(this.fileName));
                fileURL = TextUtils.makeURLToFile(fileDir + keyWord);
                if (!(TextUtils.URLExists(fileURL, errmsg) || TextUtils.URLExists(fileURL, errmsg) || TextUtils.URLExists(fileURL = LibFile.getLibFile(keyWord), errmsg))) {
                    System.out.println(errmsg.toString());
                    return false;
                }
                FileType style = FileType.DEFAULTLIB;
                if (TextUtils.getExtension(fileURL).equals("txt")) {
                    style = FileType.READABLEDUMP;
                }
                if (TextUtils.getExtension(fileURL).equals("elib")) {
                    style = FileType.ELIB;
                }
                this.cellLib = LibraryFiles.readLibrary(fileURL, null, style, false);
                if (this.cellLib == null) {
                    this.err("cannot read library " + keyWord);
                    return false;
                }
            }
        }
        if (str.hasMoreTokens() && (keyWord = str.nextToken()).equals("copy")) {
            this.copycells = true;
        }
        return true;
    }

    private boolean processViews(StringTokenizer str) {
        while (str.hasMoreTokens()) {
            String keyWord = str.nextToken();
            View view = View.findView(keyWord);
            if (view != null) {
                this.views.add(view);
                continue;
            }
            this.err("Unknown view '" + keyWord + "', ignoring");
        }
        return true;
    }

    private boolean processCell(StringTokenizer str) {
        if (str.hasMoreTokens()) {
            this.padframename = str.nextToken();
            return true;
        }
        return false;
    }

    private boolean processCore(StringTokenizer str) {
        if (str.hasMoreTokens()) {
            this.corename = str.nextToken();
            return true;
        }
        return false;
    }

    private boolean processRotate(StringTokenizer str) {
        int angle = 0;
        if (str.hasMoreTokens()) {
            String keyWord = str.nextToken();
            if (keyWord.equals("c")) {
                angle = 2700;
            } else if (keyWord.equals("cc")) {
                angle = 900;
            } else {
                System.out.println("Line " + this.lineno + ": incorrect rotation " + keyWord);
                return false;
            }
            Rotation rot = new Rotation();
            rot.angle = angle;
            this.orderedCommands.add(rot);
            return true;
        }
        return false;
    }

    private boolean processReverse(StringTokenizer str) {
        this.orderedCommands.add(new ReverseDirection());
        return true;
    }

    private boolean processAlign(StringTokenizer str) {
        ArrayAlign aa = new ArrayAlign();
        aa.lineno = this.lineno;
        String keyWord = str.nextToken();
        if (keyWord.equals("")) {
            System.out.println("Line " + this.lineno + ": missing 'cell' name");
            return false;
        }
        aa.cellname = keyWord;
        keyWord = str.nextToken();
        if (keyWord.equals("")) {
            System.out.println("Line " + this.lineno + ": missing 'in port' name");
            return false;
        }
        aa.inport = keyWord;
        keyWord = str.nextToken();
        if (keyWord.equals("")) {
            System.out.println("Line " + this.lineno + ": missing 'out port' name");
            return false;
        }
        aa.outport = keyWord;
        this.alignments.put(aa.cellname, aa);
        return true;
    }

    private boolean processExport(StringTokenizer str) {
        PadExports pe = new PadExports();
        pe.lineno = this.lineno;
        pe.padname = null;
        pe.corename = null;
        String keyWord = str.nextToken();
        if (keyWord.equals("")) {
            System.out.println("Line " + this.lineno + ": missing 'cell' name");
            return false;
        }
        pe.cellname = keyWord;
        if (str.hasMoreTokens()) {
            pe.padname = keyWord = str.nextToken();
            if (str.hasMoreTokens()) {
                pe.corename = keyWord = str.nextToken();
            }
        }
        this.exports.put(pe.cellname, pe);
        return true;
    }

    private boolean processPlace(StringTokenizer str) {
        PlacePad pad = new PlacePad();
        pad.lineno = this.lineno;
        pad.exportsname = null;
        pad.gap = 0;
        pad.ni = null;
        pad.associations = new ArrayList<PortAssociate>();
        pad.exportAssociations = new ArrayList<ExportAssociate>();
        pad.locx = null;
        pad.locy = null;
        if (!str.hasMoreTokens()) {
            this.err("Cell name missing");
            return false;
        }
        pad.cellname = str.nextToken();
        while (str.hasMoreTokens()) {
            String keyWord = str.nextToken();
            if (keyWord.equals("export")) {
                if (!str.hasMoreTokens()) {
                    this.err("Missing export assignment after 'export' keyword");
                    return false;
                }
                keyWord = str.nextToken();
                ExportAssociate ea = new ExportAssociate();
                ea.padportName = this.getLHS(keyWord);
                if (ea.padportName == null) {
                    this.err("Bad export assignment after 'export' keyword");
                    return false;
                }
                ea.exportName = this.getRHS(keyWord, str);
                if (ea.exportName == null) {
                    this.err("Bad export assignment after 'export' keyword");
                    return false;
                }
                pad.exportAssociations.add(ea);
                continue;
            }
            String lhs = this.getLHS(keyWord);
            String rhs = this.getRHS(keyWord, str);
            if (lhs == null || rhs == null) {
                this.err("Parse error on assignment of " + keyWord);
                return false;
            }
            if (lhs.equals("gap")) {
                try {
                    pad.gap = Integer.parseInt(rhs);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.err("Error parsing integer for 'gap' = " + rhs);
                    return false;
                }
            }
            if (lhs.equals("name")) {
                pad.exportsname = rhs;
                continue;
            }
            if (lhs.equals("x")) {
                try {
                    pad.locx = new Double(rhs);
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                    pad.locx = null;
                }
                continue;
            }
            if (lhs.equals("y")) {
                try {
                    pad.locy = new Double(rhs);
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                    pad.locy = null;
                }
                continue;
            }
            PortAssociate pa = new PortAssociate();
            pa.export = false;
            pa.portname = lhs;
            pa.assocname = rhs;
            pad.associations.add(pa);
        }
        this.orderedCommands.add(pad);
        return true;
    }

    private String getLHS(String keyword2) {
        if (keyword2.indexOf("=") != -1) {
            return keyword2.substring(0, keyword2.indexOf("="));
        }
        return keyword2;
    }

    private String getRHS(String keyword2, StringTokenizer str) {
        if (keyword2.indexOf("=") != -1) {
            if (keyword2.substring(keyword2.indexOf("=") + 1).equals("")) {
                if (!str.hasMoreTokens()) {
                    return null;
                }
                return str.nextToken();
            }
            return keyword2.substring(keyword2.indexOf("=") + 1);
        }
        if (!str.hasMoreTokens()) {
            return null;
        }
        keyword2 = str.nextToken();
        if (keyword2.equals("=")) {
            if (!str.hasMoreTokens()) {
                return null;
            }
            return str.nextToken();
        }
        return keyword2.substring(keyword2.indexOf("=") + 1);
    }

    private void err(String msg) {
        System.out.println("Line " + this.lineno + ": " + msg);
    }

    private Cell createPadFrames(Job job) {
        Cell frameCell = null;
        if (this.views.size() == 0) {
            frameCell = this.createPadFrame(this.padframename, View.LAYOUT, job);
        } else {
            for (View view : this.views) {
                if (view == View.SCHEMATIC) {
                    view = View.ICON;
                }
                frameCell = this.createPadFrame(this.padframename, view, job);
            }
        }
        return frameCell;
    }

    private Cell createPadFrame(String name, View view, Job job) {
        Cell framecell;
        this.angle = 0;
        CellName n = CellName.parseName(name);
        if (n != null && (n.getView() == null || n.getView() == View.UNKNOWN)) {
            name = view == null ? name + "{lay}" : (view == View.ICON ? name + "{sch}" : name + "{" + view.getAbbreviation() + "}");
        }
        if ((framecell = Cell.makeInstance(this.destLib, name)) == null) {
            System.out.println("Could not create pad frame Cell: " + name);
            return null;
        }
        EditingPreferences ep = framecell.getEditingPreferences();
        ArrayList<Export> padPorts = new ArrayList<Export>();
        ArrayList<Export> corePorts = new ArrayList<Export>();
        NodeInst lastni = null;
        int lastRotate = 0;
        String lastpadname = null;
        boolean reversed2 = false;
        for (Object obj : this.orderedCommands) {
            TextDescriptor td;
            PadExports pe;
            ArrayAlign aa;
            Cell cell;
            if (obj instanceof Rotation) {
                this.angle = (this.angle + ((Rotation)obj).angle) % 3600;
                continue;
            }
            if (obj instanceof ReverseDirection) {
                reversed2 = !reversed2;
                continue;
            }
            PlacePad pad = (PlacePad)obj;
            this.lineno = pad.lineno;
            String cellname = pad.cellname;
            if (!cellname.endsWith("}") && view != null) {
                cellname = cellname + "{" + view.getAbbreviation() + "}";
            }
            if ((cell = this.cellLib.findNodeProto(cellname)) == null) {
                this.err("Could not create pad Cell: " + cellname);
                continue;
            }
            if (this.copycells) {
                Cell existing = cell;
                cell = null;
                Iterator<Cell> cIt = this.destLib.getCells();
                while (cIt.hasNext()) {
                    Cell thereCell = cIt.next();
                    if (!thereCell.getName().equals(existing.getName()) || thereCell.getView() != existing.getView()) continue;
                    cell = thereCell;
                    break;
                }
                if (cell == null) {
                    ArrayList<Cell> fromCells = new ArrayList<Cell>();
                    fromCells.add(existing);
                    CellChangeJobs.copyRecursively(fromCells, this.destLib, false, false, false, true, true, null);
                    Iterator<Cell> cIt2 = this.destLib.getCells();
                    while (cIt2.hasNext()) {
                        Cell thereCell = cIt2.next();
                        if (!thereCell.getName().equals(existing.getName()) || thereCell.getView() != existing.getView()) continue;
                        cell = thereCell;
                        break;
                    }
                    if (cell == null) {
                        this.err("Could not copy in pad Cell " + cellname);
                        continue;
                    }
                }
            }
            if ((aa = this.alignments.get(pad.cellname)) == null) {
                this.err("No port alignment for cell " + pad.cellname);
                continue;
            }
            int gapx = 0;
            int gapy = 0;
            double centerX = 0.0;
            double centerY = 0.0;
            if (lastni != null) {
                ArrayAlign lastaa = this.alignments.get(lastpadname);
                PortProto pp = lastni.getProto().findPortProto(lastaa.outport);
                if (pp == null) {
                    this.err("no port called '" + lastaa.outport + "' on " + lastni);
                    continue;
                }
                Poly poly = lastni.findPortInstFromProto(pp).getPoly();
                centerX = poly.getCenterX();
                centerY = poly.getCenterY();
            }
            Point2D.Double pointCenter = new Point2D.Double(centerX, centerY);
            boolean flipLR = false;
            boolean flipUD = false;
            if (reversed2) {
                flipUD = true;
            }
            Orientation orient = Orientation.fromJava(this.angle, flipLR, flipUD);
            NodeInst ni = NodeInst.makeInstance(cell, pointCenter, cell.getDefWidth(), cell.getDefHeight(), framecell, orient, null);
            if (ni == null) {
                this.err("problem creating" + cell + " instance");
                continue;
            }
            if (lastni != null) {
                int gap = pad.gap;
                if (reversed2) {
                    gap = -gap;
                }
                switch (lastRotate) {
                    case 0: {
                        gapx = gap;
                        gapy = 0;
                        break;
                    }
                    case 900: {
                        gapx = 0;
                        gapy = gap;
                        break;
                    }
                    case 1800: {
                        gapx = -gap;
                        gapy = 0;
                        break;
                    }
                    case 2700: {
                        gapx = 0;
                        gapy = -gap;
                    }
                }
                PortProto inport = cell.findPortProto(aa.inport);
                if (inport == null) {
                    this.err("No port called '" + aa.inport + "' on " + cell);
                    continue;
                }
                Poly poly = ni.findPortInstFromProto(inport).getPoly();
                double tempx = centerX - poly.getCenterX() + (double)gapx;
                double tempy = centerY - poly.getCenterY() + (double)gapy;
                ni.move(tempx, tempy);
            }
            double dx = 0.0;
            double dy = 0.0;
            if (pad.locx != null) {
                dx = pad.locx - ni.getAnchorCenterX();
            }
            if (pad.locy != null) {
                dy = pad.locy - ni.getAnchorCenterY();
            }
            ni.move(dx, dy);
            if (pad.exportsname != null && (pe = this.exports.get(pad.cellname)) != null) {
                Export pppad = cell.findExport(pe.padname);
                if (pppad == null) {
                    this.err("no port called '" + pe.padname + "' on Cell " + cell.noLibDescribe());
                } else if ((pppad = Export.newInstance(framecell, ni.findPortInstFromProto(pppad), pad.exportsname)) == null) {
                    this.err("Creating export " + pad.exportsname);
                } else {
                    TextDescriptor td2 = pppad.getTextDescriptor(Export.EXPORT_NAME);
                    pppad.setTextDescriptor(Export.EXPORT_NAME, td2.withAbsSize(14));
                    padPorts.add(pppad);
                }
                if (pe.corename != null) {
                    Export ppcore = cell.findExport(pe.corename);
                    if (ppcore == null) {
                        this.err("no port called '" + pe.corename + "' on Cell " + cell.noLibDescribe());
                    } else if ((ppcore = Export.newInstance(framecell, ni.findPortInstFromProto(ppcore), "core_" + pad.exportsname)) == null) {
                        this.err("Creating export core_" + pad.exportsname);
                    } else {
                        td = ppcore.getTextDescriptor(Export.EXPORT_NAME).withAbsSize(14);
                        corePorts.add(ppcore);
                        ppcore.setTextDescriptor(Export.EXPORT_NAME, td);
                    }
                } else {
                    corePorts.add(null);
                }
            }
            for (ExportAssociate ea : pad.exportAssociations) {
                Export pp = cell.findExport(ea.padportName);
                if (pp == null) {
                    this.err("no port called '" + ea.padportName + "' on Cell " + cell.noLibDescribe());
                    continue;
                }
                if ((pp = Export.newInstance(framecell, ni.findPortInstFromProto(pp), ea.exportName)) == null) {
                    this.err("Creating export " + ea.exportName);
                    continue;
                }
                td = pp.getTextDescriptor(Export.EXPORT_NAME).withAbsSize(14);
                corePorts.add(pp);
                pp.setTextDescriptor(Export.EXPORT_NAME, td);
            }
            lastni = ni;
            lastRotate = this.angle;
            lastpadname = pad.cellname;
            pad.ni = ni;
        }
        AutoStitch.AutoOptions prefs = new AutoStitch.AutoOptions(true);
        prefs.createExports = false;
        AutoStitch.runAutoStitch(framecell, null, null, job, null, null, true, false, prefs, false, null);
        if (this.corename != null) {
            Cell corenp;
            String corenameview = this.corename;
            CellName coreName = CellName.parseName(this.corename);
            if (view != null && coreName.getView() == View.UNKNOWN) {
                corenameview = this.corename + "{" + view.getAbbreviation() + "}";
            }
            if ((corenp = this.destLib.findNodeProto(corenameview)) == null) {
                System.out.println("Line " + this.lineno + ": cannot find core cell " + corenameview);
            } else {
                ERectangle bounds = framecell.getBounds();
                Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                DBMath.gridAlign(center, this.alignment);
                NodeInst ni = NodeInst.makeInstance(corenp, center, corenp.getDefWidth(), corenp.getDefHeight(), framecell);
                HashMap<Export, PortInst> trueBusEnd = new HashMap<Export, PortInst>();
                for (Object obj : this.orderedCommands) {
                    if (!(obj instanceof PlacePad)) continue;
                    PlacePad pad = (PlacePad)obj;
                    for (PortAssociate pa : pad.associations) {
                        if (pad.ni == null) continue;
                        boolean nameArc = false;
                        PortInst pi1 = null;
                        PortProto corepp = corenp.findPortProto(pa.assocname);
                        if (corepp != null) {
                            pi1 = ni.findPortInstFromProto(corepp);
                        }
                        if (pi1 == null) {
                            Iterator<PortProto> it = corenp.getPorts();
                            while (it.hasNext()) {
                                Export e = (Export)it.next();
                                Name eName = e.getNameKey();
                                int wid = eName.busWidth();
                                if (wid <= 1) continue;
                                for (int i = 0; i < wid; ++i) {
                                    if (!eName.subname(i).toString().equals(pa.assocname)) continue;
                                    pi1 = (PortInst)trueBusEnd.get(e);
                                    if (pi1 == null) {
                                        PortInst pi = ni.findPortInstFromProto(e);
                                        Poly portPoly = pi.getPoly();
                                        Rectangle2D portRect = portPoly.getBounds2D();
                                        PrimitiveNode busPinProto = Schematics.tech().busPinNode;
                                        NodeInst busPin = NodeInst.makeInstance(busPinProto, new EPoint(portRect.getCenterX(), portRect.getCenterY()), busPinProto.getDefWidth(), busPinProto.getDefHeight(), framecell);
                                        pi1 = busPin.getOnlyPortInst();
                                        ArcProto busArcProto = Schematics.tech().bus_arc;
                                        ArcInst.makeInstance(busArcProto, pi, pi1);
                                        trueBusEnd.put(e, pi1);
                                    }
                                    nameArc = true;
                                    break;
                                }
                                if (pi1 == null) continue;
                                break;
                            }
                        }
                        if (pi1 == null) {
                            PortInst pi = pad.ni.findPortInst(pa.portname);
                            Export.newInstance(pad.ni.getParent(), pi, pa.assocname);
                            continue;
                        }
                        PortInst pi2 = pad.ni.findPortInst(pa.portname);
                        if (pi2 == null) {
                            this.err("no port called '" + pa.portname + "' on Cell " + pad.cellname);
                            continue;
                        }
                        ArcProto ap = Generic.tech().unrouted_arc;
                        ArcInst ai = ArcInst.newInstanceBase(ap, ap.getDefaultLambdaBaseWidth(), pi1, pi2);
                        if (nameArc) {
                            ai.setName(pa.assocname);
                            continue;
                        }
                        String netName = "PADFRAME";
                        if (pad.exportAssociations != null && pad.exportAssociations.size() > 0) {
                            netName = netName + "_" + pad.exportAssociations.get((int)0).exportName;
                        }
                        netName = netName + "_" + pa.assocname;
                        ai.setName(netName);
                    }
                }
            }
        }
        if (view == View.ICON) {
            int rotation;
            double yBBPos;
            double xBBPos;
            double leadLength = ep.getIconGenLeadLength();
            double leadSpacing = ep.getIconGenLeadSpacing();
            String iconCellName = framecell.getName() + "{ic}";
            Cell iconCell = Cell.makeInstance(this.destLib, iconCellName);
            if (iconCell == null) {
                Job.getUserInterface().showErrorMessage("Cannot create Icon cell " + iconCellName, "Icon creation failed");
                return framecell;
            }
            iconCell.setWantExpanded();
            double ySize = (double)Math.max(Math.max(padPorts.size(), corePorts.size()), 5) * leadSpacing;
            double xSize = 3.0 * leadSpacing;
            NodeInst bbNi = null;
            if (ep.isIconGenDrawBody()) {
                bbNi = NodeInst.newInstance(Artwork.tech().openedThickerPolygonNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
                if (bbNi == null) {
                    return framecell;
                }
                bbNi.newVar(Artwork.ART_COLOR, (Object)new Integer(10));
                Point2D[] points = new EPoint[]{new EPoint(-0.5 * xSize, -0.5 * ySize), new EPoint(-0.5 * xSize, 0.5 * ySize), new EPoint(0.5 * xSize, 0.5 * ySize), new EPoint(0.5 * xSize, -0.5 * ySize), new EPoint(-0.5 * xSize, -0.5 * ySize)};
                bbNi.setTrace(points);
                bbNi.newDisplayVar(Schematics.SCHEM_FUNCTION, framecell.getName());
            }
            int exportTech = ep.getIconGenExportTech();
            boolean drawLeads = ep.isIconGenDrawLeads();
            int exportStyle = ep.getIconGenExportStyle();
            int exportLocation = ep.getIconGenExportLocation();
            boolean ad = ep.isIconsAlwaysDrawn();
            if (this.coreAllOnOneSide) {
                ArrayList<Export> padTemp = new ArrayList<Export>();
                ArrayList<Export> coreTemp = new ArrayList<Export>();
                for (Export pp : padPorts) {
                    if (pp.getName().startsWith("core_")) {
                        coreTemp.add(pp);
                        continue;
                    }
                    padTemp.add(pp);
                }
                for (Export pp : corePorts) {
                    if (pp == null) {
                        coreTemp.add(pp);
                        continue;
                    }
                    if (pp.getName().startsWith("core_")) {
                        coreTemp.add(pp);
                        continue;
                    }
                    padTemp.add(pp);
                }
                padPorts = padTemp;
                corePorts = coreTemp;
            }
            int total = 0;
            int leftSide = padPorts.size();
            int rightSide = corePorts.size();
            for (Export pp : padPorts) {
                if (pp.isBodyOnly()) continue;
                double spacing = leadSpacing;
                double xPos = 0.0;
                double yPos = 0.0;
                xBBPos = 0.0;
                yBBPos = 0.0;
                xBBPos = -xSize / 2.0;
                xPos = xBBPos - leadLength;
                if (leftSide * 2 < rightSide) {
                    spacing = leadSpacing * 2.0;
                }
                if (!IconParameters.makeIconExport(pp, 0, xPos, yPos, xBBPos, yBBPos = (yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)total * spacing)), iconCell, rotation = ViewChanges.iconTextRotation(pp))) continue;
                ++total;
            }
            total = 0;
            for (Export pp : corePorts) {
                if (pp == null) {
                    ++total;
                    continue;
                }
                if (pp.isBodyOnly()) continue;
                double spacing = leadSpacing;
                double xPos = 0.0;
                double yPos = 0.0;
                xBBPos = 0.0;
                yBBPos = 0.0;
                xBBPos = xSize / 2.0;
                xPos = xBBPos + leadLength;
                if (rightSide * 2 < leftSide) {
                    spacing = leadSpacing * 2.0;
                }
                if (!IconParameters.makeIconExport(pp, 1, xPos, yPos, xBBPos, yBBPos = (yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)total * spacing)), iconCell, rotation = ViewChanges.iconTextRotation(pp))) continue;
                ++total;
            }
            if (!ep.isIconGenDrawBody() && !ep.isIconGenDrawLeads() && ep.isPlaceCellCenter() && total <= 1) {
                NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
            }
            int exampleLocation = ep.getIconGenInstanceLocation();
            Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
            ERectangle cellBounds = framecell.getBounds();
            ERectangle iconBounds = iconCell.getBounds();
            double halfWidth = ((RectangularShape)iconBounds).getWidth() / 2.0;
            double halfHeight = ((RectangularShape)iconBounds).getHeight() / 2.0;
            switch (exampleLocation) {
                case 0: {
                    ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                    break;
                }
                case 1: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                    break;
                }
                case 2: {
                    ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, cellBounds.getMinY() - halfHeight);
                    break;
                }
                case 3: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMinY() - halfHeight);
                }
            }
            DBMath.gridAlign(iconPos, this.alignment);
            double px = iconCell.getBounds().getWidth();
            double py = iconCell.getBounds().getHeight();
            NodeInst.makeInstance(iconCell, iconPos, px, py, framecell);
        }
        return framecell;
    }

    private static class ExportAssociate {
        String padportName;
        String exportName;

        private ExportAssociate() {
        }
    }

    private static class PortAssociate {
        boolean export;
        String portname;
        String assocname;

        private PortAssociate() {
        }
    }

    private static class ReverseDirection {
        private ReverseDirection() {
        }
    }

    private static class Rotation {
        int angle;

        private Rotation() {
        }
    }

    private static class PlacePad {
        int lineno;
        String cellname;
        String exportsname;
        int gap;
        NodeInst ni;
        List<PortAssociate> associations;
        List<ExportAssociate> exportAssociations;
        Double locx;
        Double locy;

        private PlacePad() {
        }
    }

    private static class PadExports {
        int lineno;
        String cellname;
        String padname;
        String corename;

        private PadExports() {
        }
    }

    private static class ArrayAlign {
        int lineno;
        String cellname;
        String inport;
        String outport;

        private ArrayAlign() {
        }
    }

    private static class MakePadFrame
    extends Job {
        private Library destLib;
        private String fileName;
        private Cell frameCell;
        private Dimension2D alignment;

        private MakePadFrame(Library destLib, String fileName, Dimension2D alignment) {
            super("Pad Frame Generator", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.destLib = destLib;
            this.fileName = fileName;
            this.alignment = alignment;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.frameCell = PadGenerator.makePadFrameUseJob(this.destLib, this.fileName, this.alignment, this);
            this.fieldVariableChanged("frameCell");
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            ui.displayCell(this.frameCell);
        }
    }
}

