/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;

class ViaStack {
    private PortInst port1;
    private PortInst port2;
    private final TechType tech;

    private void swap() {
        PortInst tp = this.port1;
        this.port1 = this.port2;
        this.port2 = tp;
    }

    private void buildStack(int hLo, int hHi, double x2, double y, double width, double height, Cell f2) {
        PortInst viaBelow = null;
        for (int h = hLo; h < hHi; ++h) {
            PrimitiveNode via = this.tech.viaAbove(h);
            double wid = Math.max(width, LayoutLib.getNodeProtoWidth(via));
            double hei = Math.max(height, LayoutLib.getNodeProtoHeight(via));
            PortInst viaAbove = LayoutLib.newNodeInst(via, x2, y, wid, hei, 0.0, f2).getOnlyPortInst();
            if (viaBelow == null) {
                this.port1 = viaAbove;
            } else {
                LayoutLib.newArcInst(this.tech.layerAtHeight(h), 1.0, viaBelow, viaAbove);
            }
            this.port2 = viaAbove;
            viaBelow = viaAbove;
        }
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x2, double y, double width, TechType tech, Cell f2) {
        this(arc1, arc2, x2, y, width, width, tech, f2);
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x2, double y, double width, double height, TechType tech, Cell f2) {
        this.tech = tech;
        int h1 = tech.layerHeight(arc1);
        int h2 = tech.layerHeight(arc2);
        int deltaZ = h2 - h1;
        if (arc1 == arc2) {
            EditingPreferences ep = f2.getEditingPreferences();
            PrimitiveNode pin = arc1.findOverridablePinProto(ep);
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, x2, y, defSz, defSz, 0.0, f2);
            this.port1 = this.port2 = pinInst.getOnlyPortInst();
        } else if (deltaZ > 0) {
            this.buildStack(h1, h2, x2, y, width, height, f2);
        } else {
            this.buildStack(h2, h1, x2, y, width, height, f2);
            this.swap();
        }
    }

    public PortInst getPort1() {
        return this.port1;
    }

    public PortInst getPort2() {
        return this.port2;
    }

    public double getCenterX() {
        return this.port1.getCenter().getX();
    }

    public double getCenterY() {
        return this.port1.getCenter().getY();
    }
}

