/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IStructure;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.LockFreeQueue;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stage {
    private List<StageWorker> layers;
    private IStructure<PlacementDTO> input;
    private IStructure<PlacementDTO> altInput;
    private List<Stage> nextStages;
    private List<Thread> threads;
    private int objectCounter = 0;
    private Map<StageWorker, Integer> balancingCounter = new HashMap<StageWorker, Integer>();

    public Stage(List<StageWorker> layer) {
        this.nextStages = new ArrayList<Stage>();
        this.layers = layer;
        this.input = new LockFreeQueue<PlacementDTO>();
        for (StageWorker worker : this.layers) {
            worker.setStage(this);
        }
    }

    public IStructure<PlacementDTO> getAltInput() {
        return this.altInput;
    }

    public IStructure<PlacementDTO> getInput(StageWorker worker) {
        return this.input;
    }

    public List<Stage> getNextStages() {
        return this.nextStages;
    }

    public synchronized int getObjectCounter() {
        return this.objectCounter;
    }

    protected List<Thread> getThreads() {
        return this.threads;
    }

    public synchronized void incObjectCounter() {
        ++this.objectCounter;
    }

    public void join() throws InterruptedException {
        List<Thread> threads = this.getThreads();
        for (Thread t : threads) {
            t.join();
        }
    }

    public void sendToNextStage(PlacementDTO data2) {
        for (Stage stage : this.nextStages) {
            stage.input.add(data2);
        }
    }

    public void setAltInput(IStructure<PlacementDTO> altInput) {
        this.altInput = altInput;
    }

    public void start() {
        this.threads = new ArrayList<Thread>();
        for (StageWorker worker : this.layers) {
            Thread t = new Thread(worker);
            this.threads.add(t);
            t.start();
        }
    }

    public void stop() {
        int sum2 = 0;
        for (StageWorker worker : this.layers) {
            worker.shutdown();
            if (!this.balancingCounter.containsKey(worker)) continue;
            sum2 += this.balancingCounter.get(worker).intValue();
        }
    }
}

