/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.machine;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStar;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.machine.AStarMachine;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarClosedListReferencing;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarOpenListCheapList;
import java.util.List;

public class AStarMachineFast
implements AStarMachine<AStarNode>,
AStarMapVisitorBase<AStarNode> {
    private ObjectPool<AStarNode> nodePool;
    private AStarOpenListCheapList<AStarNode> openList;
    private AStarClosedListReferencing<AStarNode> closedList;
    private AStarMapBase<AStarNode> map = null;
    private AStarGoalBase<AStarNode> goal = null;

    public AStarMachineFast(ObjectPool<AStarNode> nodePool) {
        this.nodePool = nodePool;
        this.openList = new AStarOpenListCheapList();
        this.closedList = new AStarClosedListReferencing();
    }

    @Override
    public List<AStarNode> findPath(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        if (this.map == null) {
            throw new IllegalStateException("The searched map must be specified before path search can be done.");
        }
        if (this.goal == null) {
            throw new IllegalStateException("The goal object must be specified before path search can be done.");
        }
        AStarNode goalNode = this.map.nodeAt(endX, endY, endZ);
        int goalDistance = this.goal.getNodeCost(goalNode, startX, startY, startZ);
        goalNode.initialize(null, goalDistance, 0, goalDistance, endX, endY, endZ);
        this.goal.setGoalNode(goalNode);
        AStarNode startNode = this.map.nodeAt(startX, startY, startZ);
        startNode.initialize(null, 0, goalDistance, goalDistance, startX, startY, startZ);
        this.openList.addNodeToOpenList(startNode);
        return AStar.findPath(this.openList, this.closedList, this.map, this.goal, this.nodePool, this);
    }

    @Override
    public void setUpSearchSpace(AStarMapBase<AStarNode> newMap, AStarGoalBase<AStarNode> newGoal) {
        if (newMap == null) {
            throw new IllegalArgumentException("The map to search may not be null.");
        }
        if (newGoal == null) {
            throw new IllegalArgumentException("The goal object may not be null.");
        }
        this.map = newMap;
        this.openList.setMap(this.map);
        this.closedList.setMap(this.map);
        this.goal = newGoal;
        this.goal.setNodeStorage(this.openList);
    }

    @Override
    public void visitNeighbour(AStarNode origin, int x2, int y, int z) {
        int costFromStart = origin.getCostFromStart() + this.goal.getNodeCost(origin, x2, y, z);
        int costToGoal = this.goal.distanceToGoal(x2, y, z);
        int totalCost = costFromStart + costToGoal;
        AStarNode foundNode = this.openList.findOpenNode(x2, y, z);
        boolean foundCheaperPath = false;
        if (foundNode != null) {
            if (totalCost < foundNode.getTotalCost()) {
                foundCheaperPath = true;
                this.openList.removeNodeFromOpenList(foundNode);
            }
        } else {
            foundNode = this.closedList.findClosedNode(x2, y, z);
            if (foundNode != null) {
                if (totalCost < foundNode.getTotalCost()) {
                    foundCheaperPath = true;
                    this.closedList.removeNodeFromClosedList(foundNode);
                }
            } else {
                foundNode = this.map.nodeAt(x2, y, z);
                foundCheaperPath = true;
            }
        }
        if (foundCheaperPath) {
            foundNode.initialize(origin, costFromStart, costToGoal, totalCost, x2, y, z);
            this.openList.addNodeToOpenList(foundNode);
        }
    }
}

