/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.gns.records;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.gns.records.RecordData;

public class ARecordData
implements RecordData {
    @FixedSizeIntegerArray(length=4, bitSize=8, signed=false)
    public byte[] addr;
    public static String recordTypeString = "A";

    public static ARecordData fromString(String s) {
        InetAddress addr = InetAddresses.forString((String)s);
        byte[] addrBytes = addr.getAddress();
        if (addrBytes.length != 4) {
            return null;
        }
        ARecordData recordData = new ARecordData();
        recordData.addr = addrBytes;
        return recordData;
    }

    @Override
    public String asRecordString() {
        InetAddress inetAddress;
        if (this.addr.length != 4) {
            return null;
        }
        try {
            inetAddress = Inet4Address.getByAddress(this.addr);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return inetAddress.getHostAddress();
    }
}

