/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Connection;
import org.gnunet.util.Continuation;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageReceiver;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutUtil;
import org.gnunet.util.Scheduler;
import org.gnunet.util.UnknownMessageBody;
import org.grothoff.Runabout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final RelativeTime idleTimeout;
    private final boolean requireFound;
    private List<ServerSocketChannel> listenSockets = new ArrayList<ServerSocketChannel>();
    private List<ClientHandle> clientHandles = new LinkedList<ClientHandle>();
    private MessageRunabout receivedMessageHandler;
    private List<DisconnectHandler> disconnectHandlers = new LinkedList<DisconnectHandler>();
    private List<Class> expectedMessages = Collections.emptyList();
    private boolean inSoftShutdown;
    private Cancelable acceptTask;
    private boolean destroyed;

    public Server(List<SocketAddress> addresses, RelativeTime idleTimeout, boolean requireFound) {
        this.idleTimeout = idleTimeout;
        this.requireFound = requireFound;
        try {
            for (SocketAddress addr : addresses) {
                ServerSocketChannel socket = ServerSocketChannel.open();
                socket.configureBlocking(false);
                socket.socket().bind(addr);
                logger.debug("socket listening on {}", (Object)addr.toString());
                this.listenSockets.add(socket);
                this.addAcceptSocket(socket);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("could not bind", e);
        }
    }

    public Server(RelativeTime idleTimeout, boolean requireFound) {
        this.idleTimeout = idleTimeout;
        this.requireFound = requireFound;
    }

    public final void addAcceptSocket(final ServerSocketChannel sock) {
        Scheduler.TaskConfiguration b = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                Server.this.acceptTask = null;
                try {
                    SocketChannel cli = sock.accept();
                    if (cli != null) {
                        logger.debug("client connected");
                        cli.configureBlocking(false);
                        ClientHandle clientHandle = new ClientHandle(cli);
                        Server.this.clientHandles.add(clientHandle);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("accept failed", e);
                }
                Server.this.addAcceptSocket(sock);
            }
        });
        b.addSelectEvent(sock, 16);
        this.acceptTask = b.schedule();
    }

    public void setHandler(MessageRunabout msgRunabout) {
        this.receivedMessageHandler = msgRunabout;
        this.expectedMessages = RunaboutUtil.getRunaboutVisitees(msgRunabout);
    }

    public Cancelable notifyDisconnect(final DisconnectHandler disconnectHandler) {
        this.disconnectHandlers.add(disconnectHandler);
        return new Cancelable(){

            @Override
            public void cancel() {
                Server.this.disconnectHandlers.remove(disconnectHandler);
            }
        };
    }

    public void stopListening() {
        this.inSoftShutdown = true;
        if (this.acceptTask != null) {
            this.acceptTask.cancel();
            this.acceptTask = null;
        }
        this.testForSoftShutdown();
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        for (ClientHandle h : this.clientHandles) {
            h.disconnect();
        }
        this.clientHandles.clear();
        if (this.acceptTask != null) {
            this.acceptTask.cancel();
            this.acceptTask = null;
        }
        for (ServerSocketChannel ssc : this.listenSockets) {
            try {
                ssc.close();
            }
            catch (IOException e) {
                logger.error("closing listen socket failed", (Throwable)e);
            }
        }
    }

    private void testForSoftShutdown() {
        if (this.destroyed) {
            return;
        }
        if (this.inSoftShutdown) {
            System.out.println("" + this.clientHandles.size());
            boolean done = true;
            for (ClientHandle clientHandle : this.clientHandles) {
                if (clientHandle.isMonitor) continue;
                done = false;
            }
            if (done) {
                this.destroy();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.destroyed) {
            logger.warn("Server instance not destroyed, but finalizer called");
        }
        this.destroy();
    }

    public static abstract class MessageRunabout
    extends Runabout {
        private ClientHandle currentSender;

        public final ClientHandle getSender() {
            return this.currentSender;
        }

        private void setSender(ClientHandle clientHandle) {
            this.currentSender = clientHandle;
        }
    }

    public class ClientHandle {
        private Connection connection;
        private int referenceCount = 0;
        private boolean isMonitor;
        private boolean disconnectRequested;

        private ClientHandle(SocketChannel sock) {
            this.connection = new Connection(sock);
            this.receiveDone(true);
        }

        public Cancelable notifyTransmitReady(int size, RelativeTime timeout, MessageTransmitter transmitter) {
            return this.connection.notifyTransmitReady(size, timeout, transmitter);
        }

        public Cancelable transmitWhenReady(RelativeTime timeout, final GnunetMessage.Body message, final Continuation cont) {
            return this.notifyTransmitReady(0, timeout, new MessageTransmitter(){

                @Override
                public void transmit(Connection.MessageSink sink) {
                    sink.send(message);
                    if (cont != null) {
                        cont.cont(true);
                    }
                }

                @Override
                public void handleError() {
                    if (cont != null) {
                        cont.cont(false);
                    }
                }
            });
        }

        public void receiveDone(boolean stayConnected) {
            if (stayConnected) {
                this.connection.receive(RelativeTime.FOREVER, new MessageReceiver(){

                    @Override
                    public void process(GnunetMessage.Body msg) {
                        if ((msg instanceof UnknownMessageBody || !Server.this.expectedMessages.contains(msg.getClass())) && Server.this.requireFound) {
                            logger.info("disconnecting client sending unknown message");
                            ClientHandle.this.disconnect();
                        }
                        if (Server.this.receivedMessageHandler == null) {
                            throw new AssertionError((Object)"received message, but no handler installed");
                        }
                        Server.this.receivedMessageHandler.setSender(ClientHandle.this);
                        Server.this.receivedMessageHandler.visitAppropriate(msg);
                    }

                    @Override
                    public void handleError() {
                        logger.warn("error receiving from client");
                        ClientHandle.this.disconnect();
                    }
                });
            } else if (this.referenceCount > 0) {
                this.disconnectRequested = true;
            } else {
                System.out.println("disconnecting " + this.isMonitor);
                this.disconnect();
            }
        }

        public void disconnect() {
            this.connection.disconnect();
            if (!Server.this.destroyed) {
                Server.this.clientHandles.remove(this);
            }
            for (DisconnectHandler dh : Server.this.disconnectHandlers) {
                dh.onDisconnect(this);
            }
            Server.this.testForSoftShutdown();
        }

        public void keep() {
            ++this.referenceCount;
        }

        public void drop() {
            assert (this.referenceCount > 0);
            --this.referenceCount;
            if (this.referenceCount == 0 && this.disconnectRequested) {
                this.disconnect();
            }
        }

        public void markMonitor() {
            this.isMonitor = true;
        }

        public boolean isMonitor() {
            return this.isMonitor;
        }
    }

    public static interface DisconnectHandler {
        public void onDisconnect(ClientHandle var1);
    }
}

