/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import java.math.BigInteger;
import org.gnunet.util.Program;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.gnunet.voting.CryptoUtil;

public class VotingParameters {
    public final BigInteger p;
    public final BigInteger q;
    public final BigInteger g;
    public final int authorityCount;
    public final int authorityThreshold;

    public VotingParameters(BigInteger p, BigInteger q, BigInteger g, int authorityCount, int authorityThreshold) {
        this.p = p;
        this.q = q;
        this.g = g;
        this.authorityCount = authorityCount;
        this.authorityThreshold = authorityThreshold;
    }

    public static VotingParameters generateRandomParameters(int p_bitlen, int certainty, int authorityCount, int authorityThreshold) {
        BigInteger q;
        BigInteger[] safePrimes = VotingParameters.generateSafePrimes(p_bitlen, certainty);
        BigInteger p = safePrimes[0];
        BigInteger g = VotingParameters.selectSubgroupGenerator(p, q = safePrimes[1]);
        if (!g.modPow(q, p).equals(BigInteger.ONE)) {
            throw new AssertionError();
        }
        if (g.compareTo(p) >= 0) {
            throw new AssertionError();
        }
        return new VotingParameters(p, q, g, authorityCount, authorityThreshold);
    }

    private static BigInteger[] generateSafePrimes(int pBitlength, int certainty) {
        BigInteger q;
        BigInteger p;
        int qBitlength = pBitlength - 1;
        while (!(p = (q = new BigInteger(qBitlength, certainty, CryptoUtil.random)).shiftLeft(1).add(BigInteger.ONE)).isProbablePrime(certainty)) {
        }
        return new BigInteger[]{p, q};
    }

    private static BigInteger selectSubgroupHigherOrderElement(BigInteger alpha, BigInteger p, BigInteger q) {
        return alpha.modPow(p.subtract(BigInteger.ONE).divide(q), p);
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public static BigInteger selectSubgroupGenerator(BigInteger p, BigInteger q) {
        BigInteger alpha = VotingParameters.selectGenerator(p, q);
        return VotingParameters.selectSubgroupHigherOrderElement(alpha, p, q);
    }

    public static BigInteger selectGenerator(BigInteger p, BigInteger q) {
        BigInteger g;
        BigInteger pMinusTwo = p.subtract(BigInteger.valueOf(2L));
        while ((g = CryptoUtil.createRandomInRange(BigInteger.valueOf(2L), pMinusTwo)).modPow(BigInteger.valueOf(2L), p).equals(BigInteger.ONE) || g.modPow(q, p).equals(BigInteger.ONE)) {
        }
        return g;
    }

    public BigInteger generateZq() {
        return CryptoUtil.createRandomInRange(BigInteger.ZERO, this.q.subtract(BigInteger.ONE));
    }

    public static void main(String ... args) {
        new Program(){
            @Argument(shortname="b", longname="bits", action=ArgumentAction.STORE_NUMBER, description="bit length of q")
            int bitlength = 512;
            @Argument(shortname="C", longname="certainty", action=ArgumentAction.STORE_NUMBER, description="certainty")
            int certainty = 2;

            @Override
            protected void run() {
                System.out.println(String.format("Generating parameters with bitlength %s and certainty %s", this.bitlength, this.certainty));
                VotingParameters vp = VotingParameters.generateRandomParameters(this.bitlength, this.certainty, 3, 2);
                System.out.println("p: 0x0" + vp.getP().toString(16));
                System.out.println("q: 0x0" + vp.getQ().toString(16));
                System.out.println("g: 0x0" + vp.getG().toString(16));
            }
        }.startWithoutScheduler(args);
    }
}

