#include <stdio.h>
#include <string.h>

#define MIN 0
#define MAX 1
#define VAL 2


char   a[40];
char   x[40];
int    nb,nbl;
int    sign_c;
char   c;
int    c1;

int    full_ac;

char  *pos[]={ "min", "max", "val" };
char  *neg[]={ "max", "min", "val" };


#define IsCoef(c)     ((c)>='a' && (c)<='k')
#define IsVar(c)      ((c)>='t' && (c)<='z')




/*-------------------------------------------------------------------------*/
/* LEFT                                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Left(int mmv,int j)

{
 int i;
 int wr=0;

 if (a[j])
     printf("(");

 for(i=nbl;i<nb;i++)
    {
     if (wr)
         printf(" + ");

     if (a[i])
         printf("%c*%s(%c)",a[i],pos[mmv],x[i]);
      else
         printf("%s(%c)",pos[mmv],x[i]);
     wr=1; 
    }

 if (sign_c>0)
    {
     printf("%s%c",(wr) ? " + " : "",c);
     wr=1;
    }
     
 if (c1>0)
    {
     printf("%s1",(wr) ? " + " : "");
     wr=1;
    }
     
 for(i=0;i<nbl;i++)
    {
     if (i==j)
         continue;

     printf(" - ");
     if (a[i])
         printf("%c*%s(%c)",a[i],neg[mmv],x[i]);
      else
         printf("%s(%c)",neg[mmv],x[i]);
    }

 if (sign_c<0)
     printf(" - %c",c);

 if (c1<0)
     printf(" - 1");

 if (a[j])
     printf(") %s %c",(mmv==MIN) ? "/>" : "/<",a[j]);

}




/*-------------------------------------------------------------------------*/
/* RIGHT                                                                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Right(int mmv,int j)

{
 int i;
 int wr=0;
 
 if (a[j])
     printf("(");

 for(i=0;i<nbl;i++)
    {
     if (wr)
         printf(" + ");

     if (a[i])
         printf("%c*%s(%c)",a[i],pos[mmv],x[i]);
      else
         printf("%s(%c)",pos[mmv],x[i]);
     wr=1; 
    }

 if (sign_c<0)
    {
     printf("%s%c",(wr) ? " + " : "",c);
     wr=1;
    }

 if (c1<0)
    {
     printf("%s1",(wr) ? " + " : "");
     wr=1;
    }

 for(i=nbl;i<nb;i++)
    {
     if (i==j)
         continue;

     printf(" - ");
     if (a[i])
         printf("%c*%s(%c)",a[i],neg[mmv],x[i]);
      else
         printf("%s(%c)",neg[mmv],x[i]);
    }

 if (sign_c>0)
     printf(" - %c",c);

 if (c1>0)
     printf(" - 1");

 if (a[j])
     printf(") %s %c",(mmv==MIN) ? "/>" : "/<",a[j]);

}




/*-------------------------------------------------------------------------*/
/* LR                                                                      */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void LR(int mmv,int j)

{
 if (j<nbl)
     Left(mmv,j);
  else
     Right(mmv,j);

}




/*-------------------------------------------------------------------------*/
/* FULL_AC_LEFT                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Full_AC_Left(int j)

{
 int i;
 int wr=0;

 if (a[j])
     printf("(");

 for(i=nbl;i<nb;i++)
    {
     if (wr)
         printf(" + ");

     if (a[i])
         printf("dom(%c)*%c",x[i],a[i]);
      else
         printf("dom(%c)",x[i]);
     wr=1; 
    }

 if (sign_c>0)
    {
     printf("%s%c",(wr) ? " + " : "",c);
     wr=1;
    }
     
 if (c1>0)
    {
     printf("%s1",(wr) ? " + " : "");
     wr=1;
    }
     
 for(i=0;i<nbl;i++)
    {
     if (i==j)
         continue;

     printf(" - ");
     if (a[i])
         printf("dom(%c)*%c",x[i],a[i]);
      else
         printf("dom(%c)",x[i]);
    }

 if (sign_c<0)
     printf(" - %c",c);

 if (c1<0)
     printf(" - 1");

 if (a[j])
     printf(") / %c",a[j]);

}




/*-------------------------------------------------------------------------*/
/* FULL_AC_RIGHT                                                           */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Full_AC_Right(int j)

{
 int i;
 int wr=0;
 
 if (a[j])
     printf("(");

 for(i=0;i<nbl;i++)
    {
     if (wr)
         printf(" + ");

     if (a[i])
         printf("dom(%c)*%c",x[i],a[i]);
      else
         printf("dom(%c)",x[i]);
     wr=1; 
    }

 if (sign_c<0)
    {
     printf("%s%c",(wr) ? " + " : "",c);
     wr=1;
    }

 if (c1<0)
    {
     printf("%s1",(wr) ? " + " : "");
     wr=1;
    }

 for(i=nbl;i<nb;i++)
    {
     if (i==j)
         continue;

     printf(" - ");
     if (a[i])
         printf("dom(%c)*%c",x[i],a[i]);
      else
         printf("dom(%c)",x[i]);
    }

 if (sign_c>0)
     printf(" - %c",c);

 if (c1>0)
     printf(" - 1");

 if (a[j])
     printf(") / %c",a[j]);

}




/*-------------------------------------------------------------------------*/
/* FULL_AC_LR                                                              */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Full_AC_LR(int j)

{
 if (j<nbl)
     Full_AC_Left(j);
  else
     Full_AC_Right(j);

}




/*-------------------------------------------------------------------------*/
/* CONSTR                                                                  */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Constr(char *str)

{
 char  *p;
 char  *s1[]={ "plus","eq","neq","lte","lt","gte","gt",NULL };
 char  *s2[]={ "+",   "=", "\\=","<=", "<" ,">=", ">" };
 char **s;
 int    op;
 int    i;
 int    wr;
 int    l;


 printf("\n%s(",str);
 wr=0;
 l=0;
 sign_c=c1=0;
 op=-1;
 nb=0;
 for(p=str+2*full_ac;*p;p++)
    {
     if (*p=='_')
        {
         for(s=s1;*s;s++)
            {
             i=strlen(*s);
             if (strncmp(*s,p+1,i)==0)
                 break;
            }

         if (*s && p[1+i]=='_')
            {
             p+=1+i;
             if (s>s1)
                {
                 op=s-s1-1;
                 nbl=nb;
                }
             continue;
            }
        }

     if (wr)
         printf(",");
     printf("%s %c",IsCoef(*p) ? "int" : "fdv",*p - 'a' + 'A');
     l++;
     wr=1;

     if (IsCoef(*p) && IsVar(p[1]))
        {
         a[nb]=*p++ - 'a' + 'A';
         x[nb]=*p - 'a' + 'A';
         printf(",fdv %c",x[nb]);
         l++;
         nb++;
         continue;
        }

     if (IsVar(*p))
        {
         a[nb]=0;
         x[nb]=*p - 'a' + 'A';
         nb++;
         continue;
        }

     if (IsCoef(*p))
        {
         if (sign_c)
             fprintf(stderr,
                     "\nERROR coef %c already specified when reading %c\n",
                    c,*p - 'a' + 'A');

         sign_c=(op<0) ? -1 : +1;
         c=*p - 'a' + 'A';
         continue;
        }

     fprintf(stderr,"\nERROR char(%c)\n",*p);
    }
 
 printf(")\n");
 printf("\t/* ");
 for(i=0;i<nbl;i++)
    {
     if (i)
         printf(" + ");

     if (a[i])
         printf("%c%c",a[i],x[i]);
      else
         printf("%c",x[i]);
    }

 if (sign_c<0)
    {
     if (nbl>0)
         printf(" + ");

     printf("%c",c);
    }

 printf(" %s ",s2[op+1]);

 for(;i<nb;i++)
    {
     if (i>nbl)
         printf(" + ");

     if (a[i])
         printf("%c%c",a[i],x[i]);
      else
         printf("%c",x[i]);
    }

 if (sign_c>0)
    {
     if (nb>nbl)
         printf(" + ");

     printf("%c",c);
    }

 printf(" */\n");

 printf("{\n");


 for(i=0;i<nb;i++)
    {
     printf(" start %c in ",x[i]);

     switch(op)
        {
         case 0:
             if (full_ac)
                {
                 Full_AC_LR(i);
                 break;
                }
             LR(MIN,i);
             printf(" .. ");
             LR(MAX,i);
             break;

         case 1:
             printf("~{");
             LR(VAL,i);
             printf("}");
             break;

         case 3:
             c1=-1;
         case 2:
             if (i<nbl)
                 printf("0");
              else
                 LR(MIN,i);
             printf(" .. ");
             if (i<nbl)
                 LR(MAX,i);
              else
                 printf("max_integer");
             break;

         case 5:
             c1=+1;
         case 4:
             if (i<nbl)
                 LR(MIN,i);
              else
                 printf("0");
             printf(" .. ");
             if (i<nbl)
                 printf("max_integer");
              else
                 LR(MAX,i);
             break;


        }

     printf("\n");
    }

 printf("}\n");
}




/*-------------------------------------------------------------------------*/
/* PROTO                                                                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Proto(char *str)

{
 char  *p;
 char  *s1[]={ "plus","eq","neq","lte","lt","gte","gt",NULL };
 char **s;
 int    i;
 int    wr;


 printf("Bool      %s%*s(",str,22-strlen(str),"");
 wr=0;
 for(p=str+2*full_ac;*p;p++)
    {
     if (*p=='_')
        {
         for(s=s1;*s;s++)
            {
             i=strlen(*s);
             if (strncmp(*s,p+1,i)==0)
                 break;
            }

         if (*s && p[1+i]=='_')
            {
             p+=1+i;
             continue;
            }
        }

     if (wr)
         printf(",");
     printf("WamWord %c",*p);
     wr=1;
    }
 
 printf(");\n");
}




/*-------------------------------------------------------------------------*/
/* MAIN                                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int main(int argc,char *argv[])

{
 char  buff[80]="F_";
 char *str;
 int   proto=0;
 int   i;


 full_ac=0;

 for(i=1;i<argc;i++)
    {
     if (argv[i][0]!='-')
        {
error:
         printf("unrecognize argument : %s\n",argv[i]);
         return 1;
        }
     switch(argv[i][1])
        {
         case 'p':
             proto=1;
             break;

         case 'f':
             full_ac=1;
             break;

         default:
             goto error;
        }
    }



 str=(full_ac) ? buff+2 : buff;

 for(;;)
    {
     if ((scanf("%s",str))==EOF)
         break;

     if (proto)
        Proto(buff);
     else
        Constr(buff);
    }

 return 0;
}
