
;;; emergency-bindings.el --- Some emergency keybindings

;; Copyright (C) 2006-2011 Davin Pearson

;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Emergency keybindings
;; Package: dlisp (Davin's version of elisp)
;; Version: 1.0

;; This program is part of GNU Java Training Wheels.

;;; Limitation of Warranty:

;; This program is free software: you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation, either version 3 of the
;; License, or (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more detail.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.

;;; Commentary:

;; This file provides some emergency bindings in case your .emacs
;; has a bug in it.  Simply invoke emacs with the following arguments:

;; emacs --no-init-file --load ~/dlisp/emergency-bindings.el
;;
;;; Known Bugs:

;; none so far!

;;; Code:

(global-set-key [f1] 'info)
(global-set-key [f2] (function (lambda () (interactive) (save-some-buffers 'NO-QUESTIONS))))
(global-set-key [f4] 'delete-other-windows)
(global-set-key [f7] 'read-only-mode)
(global-set-key [f8] 'undo)
(global-set-key [f12] 'eval-last-sexp)
(global-set-key [insert] 'electric-buffer-list)
(global-set-key [delete] 'delete-char)
(global-set-key "\C-d" 'd-find-file0)
(global-set-key "\C-f" 'd-find-file0)
(global-set-key [(control tab)] 'other-window)
;; -------------------------------------------------
(global-set-key [(control right)] 'forward-sexp )
(global-set-key [(meta right   )] 'forward-sexp )
(global-set-key [(shift right  )] 'forward-sexp )
(global-set-key [(control left )] 'backward-sexp)
(global-set-key [(meta left    )] 'backward-sexp)
(global-set-key [(shift left   )] 'backward-sexp)
;; ------------------------------------------------
(global-set-key [(control w)] nil)
(global-set-key "\C-e" 'call-last-kbd-macro)
(global-set-key "`" 'dabbrev-expand)

(defalias 'eb 'eval-buffer)

(setq kill-whole-line t)

(setq file-name-history (cons "~/" file-name-history))

(setq track-eol t)
(setq os-type--msdos-p   (if (and (string= (getenv "IS_DOS") "1") (memq system-type '(ms-dos))) t))
(setq os-type--windows-p (memq system-type '(windows-nt ms-dos)))
(setq os-type--linux-p   (not os-type--windows-p))
(setq prefs-windows-bindings-p nil)
(setq prefs-advanced-user-p t)
(setq prefs-home-emacs-p t)
(setq c2java-version "1.21")

(blink-cursor-mode -1)

(defun d-find-file0 (f)
  (interactive "FFind file/folder: ")
  (if (string-match "\\*" f)
      (find-file f 'WILDCARDS)
    (find-file f)))

(defun safe-require (f)
  (condition-case err
      (require f)
    (message "Failed to find file %s" (cdr err))))

;;;
;;; NOTE: standard notation follows...
;;;
;;; File/directory spec is  (setq dir-1 "d:/home") or (setq dir-1 "d:") (note no trailing slash)
;;; File access is          (concat dir-1 "/" file-1)
;;; Relative directory spec (setq rel-1 "abc/def")
;;; Therefore joiner is     (concat dir-1 "/" rel-1)
;;; Shell script joiner is  $ABC/$DEF or $ABC/foo (note $ABCfoo is an error)
;;; Makefile joiner is      $$ABC/$$DEF or $$ABC/foo (note $$ABCfoo is an error)
;;; Makefile joiner is      $(ABC)/$(DEF) or $(ABC)/foo (note $(ABC)foo works without error)
;;;
;;; BUG: d: denotes the current directory in the d drive in some cases (outside of Emacs)
;;;
;;; (safe-expand-file-name nil)
;;; (safe-expand-file-name "d:/")
;;; (safe-expand-file-name (setq file "d:/home/"))
;;; (safe-expand-file-name "d:/home")
;;; (safe-expand-file-name "d:/home/.emacs")
;;; (safe-expand-file-name "d:/home//text/..")
;;;
;;; NOTE: never returns a trailing slash
;;;
;;; (setenv "HOME" "d:/")
;;; (safe-expand-file-name "d:/")
;;; (safe-expand-file-name "d:/frog")
;;; (safe-expand-file-name "d:/FROG")
;;; (safe-expand-file-name "~/.emacs")
;;; (safe-expand-file-name "~/dlisp")
;;;
(defun d-safe-expand-file-name (filename)
  "Replaces ~/ with expanded file name"

  (save-match-data
    (setq filename (if filename (expand-file-name filename)))
    ;;
    ;; NOTE: adds trailing slash
    ;;
    (if (and filename (not (string-match "/$" filename)))
        (setq filename (concat filename "/")))

    filename))

(defun d-emergency-set-load-path ()
  (cond
   ((string= user-login-name "root")
    (setq load-path (cons "~www/dlisp/" load-path)))
   ((memq system-type '(windows-nt))
    (setq load-path (cons (d-safe-expand-file-name "~/dlisp/") load-path)))
   (t
    (setq load-path (cons (d-safe-expand-file-name "~/dlisp") load-path)))))

(d-emergency-set-load-path)

;;(set-default-font "-*-courier new-normal-r-*-*-22-*-*-*-c-*-fontset-standard")
;;(require 'd-scratch)

(provide 'emergency-bindings)
;;; emergency-bindings.el ends here

