/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.NameLookup;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.xml.DescendantOrSelfAxis;
import gnu.kawa.xml.ElementType;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeElement;
import gnu.kawa.xml.NodeType;
import gnu.kawa.xml.ParentAxis;
import gnu.mapping.InPort;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.NamespaceBinding;
import gnu.xquery.lang.XQResolveNames;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.NamedCollator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Stack;
import java.util.Vector;
import kawa.standard.require;

public class XQParser
extends Lexer {
    int curToken;
    Object curValue;
    int curLine;
    int curColumn;
    XQuery interpreter;
    int seenPosition;
    int seenLast;
    public static boolean warnOldVersion = true;
    static final Symbol DOT_VARNAME = Symbol.make(null, "$dot$");
    static final Symbol POSITION_VARNAME = Symbol.make(null, "$position$");
    static final Symbol LAST_VARNAME = Symbol.make(null, "$last$");
    public static final InstanceOf instanceOf = new InstanceOf(XQuery.getInstance(), "instance");
    NameLookup lexical;
    XQResolveNames resolver;
    NamedCollator defaultCollator = null;
    char defaultEmptyOrder = (char)76;
    String baseURI = null;
    boolean preserveBoundarySpace;
    public Namespace[] functionNamespacePath = XQuery.defaultFunctionNamespacePath;
    Declaration[] flworDecls;
    int flworDeclsFirst;
    int flworDeclsCount;
    static final int EOF_TOKEN = -1;
    static final int EOL_TOKEN = 10;
    static final char INTEGER_TOKEN = '0';
    static final char FLOAT_TOKEN = '1';
    static final int STRING_TOKEN = 34;
    static final int SLASHSLASH_TOKEN = 68;
    static final int DOTDOT_TOKEN = 50;
    static final int COLON_EQUAL_TOKEN = 76;
    static final int COLON_COLON_TOKEN = 88;
    static final int NCNAME_TOKEN = 65;
    static final int NCNAME_COLON_TOKEN = 67;
    static final int QNAME_TOKEN = 81;
    static final int ARROW_TOKEN = 82;
    static final int FNAME_TOKEN = 70;
    static final int IMPORT_MODULE_TOKEN = 73;
    static final int IMPORT_SCHEMA_TOKEN = 84;
    static final int MODULE_NAMESPACE_TOKEN = 77;
    static final int DECLARE_NAMESPACE_TOKEN = 78;
    static final int DECLARE_XMLSPACE_TOKEN = 83;
    static final int DEFAULT_ELEMENT_TOKEN = 69;
    static final int DEFAULT_FUNCTION_TOKEN = 79;
    static final int DEFAULT_COLLATION_TOKEN = 71;
    static final int DECLARE_FUNCTION_TOKEN = 80;
    static final int DECLARE_VARIABLE_TOKEN = 86;
    static final int DECLARE_BASE_URI_TOKEN = 66;
    static final int DEFINE_QNAME_TOKEN = 87;
    static final int OP_AXIS_FIRST = 100;
    static final int COUNT_OP_AXIS = 13;
    static final int AXIS_ANCESTOR = 0;
    static final int AXIS_ANCESTOR_OR_SELF = 1;
    static final int AXIS_ATTRIBUTE = 2;
    static final int AXIS_CHILD = 3;
    static final int AXIS_DESCENDANT = 4;
    static final int AXIS_DESCENDANT_OR_SELF = 5;
    static final int AXIS_FOLLOWING = 6;
    static final int AXIS_FOLLOWING_SIBLING = 7;
    static final int AXIS_NAMESPACE = 8;
    static final int AXIS_PARENT = 9;
    static final int AXIS_PRECEDING = 10;
    static final int AXIS_PRECEDING_SIBLING = 11;
    static final int AXIS_SELF = 12;
    static final int OP_WHERE = 196;
    static final int OP_BASE = 400;
    static final int OP_OR = 400;
    static final int OP_AND = 401;
    static final int OP_EQU = 402;
    static final int OP_NEQ = 403;
    static final int OP_LSS = 404;
    static final int OP_GRT = 405;
    static final int OP_LEQ = 406;
    static final int OP_GEQ = 407;
    static final int OP_IS = 408;
    static final int OP_ISNOT = 409;
    static final int OP_GRTGRT = 410;
    static final int OP_LSSLSS = 411;
    static final int OP_RANGE_TO = 412;
    static final int OP_ADD = 413;
    static final int OP_SUB = 414;
    static final int OP_MUL = 415;
    static final int OP_DIV = 416;
    static final int OP_IDIV = 417;
    static final int OP_MOD = 418;
    static final int OP_UNION = 419;
    static final int OP_INTERSECT = 420;
    static final int OP_EXCEPT = 421;
    static final int OP_INSTANCEOF = 422;
    static final int OP_NODE = 231;
    static final int OP_TEXT = 232;
    static final int OP_COMMENT = 233;
    static final int OP_PI = 234;
    static final int OP_DOCUMENT = 235;
    private int saveToken;
    private Object saveValue;
    int count = 0;
    private boolean warnedOldStyleKindTest;
    private final String undefTestErr = "node test when focus is undefined";
    Compilation comp;
    String defaultElementNamespace = "";
    NamespaceBinding namespaceBindings = NamespaceBinding.predefinedXML;
    NamespaceBinding prologNamespaces = NamespaceBinding.predefinedXML;
    public static final String[] axisNames = new String[13];
    static final Expression funcForwardFilter;
    static final Expression funcReverseFilter;
    static final Expression funcExprFilter;
    static final NodeType documentNodeTest;
    static final NodeType textNodeTest;
    static final NodeType commentNodeTest;
    static final NodeType piNodeTest;
    static final NodeType anyNodeTest;

    final int skipSpace() throws IOException, SyntaxException {
        return this.skipSpace(true);
    }

    final int skipSpace(boolean bl) throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) == 40) {
                if (!this.checkNext(':')) {
                    return 40;
                }
                this.skipComment();
                continue;
            }
            if (n == 123) {
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    this.unread(45);
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (bl ? n < 0 || !Character.isWhitespace((char)n) : n != 32 && n != 9) break;
        }
        return n;
    }

    final void skipToSemicolon() throws IOException {
        int n;
        while ((n = this.read()) >= 0 && n != 59) {
        }
    }

    final void skipOldComment() throws IOException, SyntaxException {
        int n = 0;
        int n2 = this.getLineNumber() + 1;
        int n3 = this.getColumnNumber() - 2;
        while (true) {
            int n4;
            if ((n4 = this.read()) == 45) {
                ++n;
                continue;
            }
            if (n4 == 125 && n >= 2) {
                return;
            }
            if (n4 < 0) {
                this.curLine = n2;
                this.curColumn = n3;
                this.eofError("non-terminated comment starting here");
                continue;
            }
            n = 0;
        }
    }

    final void skipComment() throws IOException, SyntaxException {
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() - 1;
        int n3 = 0;
        int n4 = 0;
        char c = this.pushNesting(':');
        while (true) {
            int n5;
            if ((n5 = this.read()) == 58) {
                if (n3 == 40) {
                    ++n4;
                    n5 = 0;
                }
            } else if (n5 == 41 && n3 == 58) {
                if (n4 == 0) {
                    this.popNesting(c);
                    return;
                }
                --n4;
            } else if (n5 < 0) {
                this.curLine = n;
                this.curColumn = n2;
                this.eofError("non-terminated comment starting here");
            }
            n3 = n5;
        }
    }

    final int peekNonSpace(String string) throws IOException, SyntaxException {
        int n = this.skipSpace();
        if (n < 0) {
            this.eofError(string);
        }
        this.unread(n);
        return n;
    }

    public static boolean isNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNamePart(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '-' || c == '.';
    }

    public void mark() throws IOException {
        super.mark();
        this.saveToken = this.curToken;
        this.saveValue = this.curValue;
    }

    public void reset() throws IOException {
        this.curToken = this.saveToken;
        this.curValue = this.saveValue;
        super.reset();
    }

    private int setToken(int n, int n2) {
        this.curToken = n;
        this.curLine = this.port.getLineNumber() + 1;
        this.curColumn = this.port.getColumnNumber() + 1 - n2;
        return n;
    }

    int getRawToken() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                return this.setToken(-1, 0);
            }
            if (n == 10 || n == 13) {
                if (this.nesting > 0) continue;
                return this.setToken(10, 0);
            }
            if (n == 40) {
                if (this.checkNext(':')) {
                    this.skipComment();
                    continue;
                }
                return this.setToken(40, 1);
            }
            if (n == 123) {
                if (!this.checkNext('-')) {
                    return this.setToken(123, 1);
                }
                n = this.read();
                if (n != 45) {
                    this.unread();
                    this.unread();
                    return this.setToken(123, 1);
                }
                this.skipOldComment();
                continue;
            }
            if (n != 32 && n != 9) break;
        }
        this.tokenBufferLength = 0;
        this.curLine = this.port.getLineNumber() + 1;
        this.curColumn = this.port.getColumnNumber();
        int n2 = n;
        switch (n2) {
            case 36: 
            case 41: 
            case 44: 
            case 59: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 125: {
                break;
            }
            case 58: {
                if (this.checkNext('=')) {
                    n2 = 76;
                    break;
                }
                if (!this.checkNext(':')) break;
                n2 = 88;
                break;
            }
            case 124: {
                n2 = 419;
                break;
            }
            case 42: {
                n2 = 415;
                break;
            }
            case 43: {
                n2 = 413;
                break;
            }
            case 45: {
                n2 = 414;
                break;
            }
            case 33: {
                if (!this.checkNext('=')) break;
                n2 = 403;
                break;
            }
            case 47: {
                if (!this.checkNext('/')) break;
                n2 = 68;
                break;
            }
            case 61: {
                if (this.checkNext('>')) {
                    n2 = 82;
                }
                n2 = 402;
                break;
            }
            case 62: {
                n2 = this.checkNext('=') ? 407 : (this.checkNext('>') ? 410 : 405);
                break;
            }
            case 60: {
                n2 = this.checkNext('=') ? 406 : (this.checkNext('<') ? 411 : 404);
                break;
            }
            case 46: {
                if (this.checkNext('.')) {
                    n2 = 50;
                    break;
                }
                n = this.peek();
                if (!Character.isDigit((char)n)) break;
                this.tokenBufferAppend(46);
                do {
                    this.tokenBufferAppend((char)n);
                    this.skip();
                } while (Character.isDigit((char)(n = this.peek())));
                n2 = 49;
                break;
            }
            case 34: 
            case 39: {
                char c = this.pushNesting((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected end-of-file in string starting here");
                    }
                    if (n == 38) {
                        this.parseEntityOrCharRef();
                        continue;
                    }
                    if (n2 == n && n2 != (n = this.read())) break;
                    this.tokenBufferAppend((char)n);
                }
                this.unread(n);
                this.popNesting(c);
                n2 = 34;
                break;
            }
            default: {
                if (Character.isDigit((char)n2)) {
                    boolean bl = false;
                    while (true) {
                        this.tokenBufferAppend(n2);
                        n = this.read();
                        if (n < 0) break;
                        n2 = (char)n;
                        if (n2 == 46) {
                            if (bl) break;
                            bl = true;
                            continue;
                        }
                        if (!Character.isDigit((char)n2)) break;
                    }
                    if (n == 101 || n == 69) {
                        this.tokenBufferAppend((char)n);
                        n = this.read();
                        if (n == 43 || n == 45) {
                            this.tokenBufferAppend((char)n);
                            n = this.read();
                        }
                        int n3 = 0;
                        while (n >= 0) {
                            n2 = (char)n;
                            if (!Character.isDigit((char)n2)) {
                                this.unread();
                                break;
                            }
                            this.tokenBufferAppend(n2);
                            n = this.read();
                            ++n3;
                        }
                        if (n3 == 0) {
                            this.error("no digits following exponent");
                        }
                        n2 = 49;
                        break;
                    }
                    int n4 = n2 = bl ? 49 : 48;
                    if (n < 0) break;
                    this.unread(n);
                    break;
                }
                if (XQParser.isNameStart((char)n2)) {
                    do {
                        this.tokenBufferAppend(n2);
                    } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                    if (n < 0) {
                        n2 = 65;
                        break;
                    }
                    if (n != 58) {
                        n2 = 65;
                    } else {
                        n = this.read();
                        if (n < 0) {
                            this.eofError("unexpected end-of-file after NAME ':'");
                        }
                        if (XQParser.isNameStart((char)(n2 = (int)((char)n)))) {
                            this.tokenBufferAppend(58);
                            do {
                                this.tokenBufferAppend(n2);
                            } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                            n2 = 81;
                        } else if (n2 == 61) {
                            this.unread(n2);
                            n2 = 65;
                        } else {
                            n2 = 67;
                        }
                    }
                    this.unread(n);
                    break;
                }
                if (n2 >= 32 && n2 < 127) {
                    this.syntaxError("invalid character '" + (char)n2 + '\'');
                    break;
                }
                this.syntaxError("invalid character '\\u" + Integer.toHexString(n2) + '\'');
            }
        }
        this.curToken = n2;
        return n2;
    }

    public void getDelimited(String string) throws IOException, SyntaxException {
        this.tokenBufferLength = 0;
        int n = string.length();
        char c = string.charAt(n - 1);
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = this.read()) < 0) {
                this.eofError("unexpected end-of-file looking for '" + string + '\'');
            }
            if (n4 == c && (n3 = this.tokenBufferLength - (n2 = n - 1)) >= 0) {
                do {
                    if (n2 != 0) continue;
                    this.tokenBufferLength = n3;
                    return;
                } while (this.tokenBuffer[n3 + --n2] == string.charAt(n2));
            }
            this.tokenBufferAppend((char)n4);
        }
    }

    public void appendNamedEntity(String string) {
        string = string.intern();
        int n = 63;
        if (string == "lt") {
            n = 60;
        } else if (string == "gt") {
            n = 62;
        } else if (string == "amp") {
            n = 38;
        } else if (string == "quot") {
            n = 34;
        } else if (string == "apos") {
            n = 39;
        } else {
            this.error("unknown enity reference: '" + string + "'");
        }
        this.tokenBufferAppend(n);
    }

    int peekOperator() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            if (this.nesting == 0) {
                return 10;
            }
            this.getRawToken();
        }
        if (this.curToken == 65) {
            int n = this.tokenBufferLength;
            switch (n) {
                case 2: {
                    char c = this.tokenBuffer[0];
                    char c2 = this.tokenBuffer[1];
                    if (c == 'o' && c2 == 'r') {
                        this.curToken = 400;
                        break;
                    }
                    if (c == 't' && c2 == 'o') {
                        this.curToken = 412;
                        break;
                    }
                    if (c == 'i' && c2 == 's') {
                        this.curToken = 408;
                        break;
                    }
                    if (c == 'e' && c2 == 'q') {
                        this.curToken = 402;
                        break;
                    }
                    if (c == 'n' && c2 == 'e') {
                        this.curToken = 403;
                        break;
                    }
                    if (c == 'g') {
                        if (c2 == 'e') {
                            this.curToken = 407;
                            break;
                        }
                        if (c2 != 't') break;
                        this.curToken = 405;
                        break;
                    }
                    if (c != 'l') break;
                    if (c2 == 'e') {
                        this.curToken = 406;
                        break;
                    }
                    if (c2 != 't') break;
                    this.curToken = 404;
                    break;
                }
                case 3: {
                    char c = this.tokenBuffer[0];
                    char c3 = this.tokenBuffer[1];
                    char c4 = this.tokenBuffer[2];
                    if (c == 'a') {
                        if (c3 != 'n' || c4 != 'd') break;
                        this.curToken = 401;
                        break;
                    }
                    if (c == 'm') {
                        if (c3 == 'u' && c4 == 'l') {
                            this.curToken = 415;
                        }
                        if (c3 != 'o' || c4 != 'd') break;
                        this.curToken = 418;
                        break;
                    }
                    if (c != 'd' || c3 != 'i' || c4 != 'v') break;
                    this.curToken = 416;
                    break;
                }
                case 4: {
                    if (!this.match("idiv")) break;
                    this.curToken = 417;
                    break;
                }
                case 5: {
                    if (this.match("where")) {
                        this.curToken = 196;
                        break;
                    }
                    if (this.match("isnot")) {
                        this.curToken = 409;
                        break;
                    }
                    if (!this.match("union")) break;
                    this.curToken = 419;
                    break;
                }
                case 6: {
                    if (!this.match("except")) break;
                    this.curToken = 421;
                    break;
                }
                case 8: {
                    if (!this.match("instance")) break;
                    this.curToken = 422;
                    break;
                }
                case 9: {
                    if (!this.match("intersect")) break;
                    this.curToken = 420;
                    break;
                }
                case 10: {
                    if (!this.match("instanceof")) break;
                    this.curToken = 422;
                    break;
                }
            }
        }
        return this.curToken;
    }

    private boolean lookingAt(String string, String string2) throws IOException, SyntaxException {
        int n;
        if (!string.equals(this.curValue)) {
            return false;
        }
        int n2 = 0;
        int n3 = string2.length();
        do {
            n = this.read();
            if (n2 != n3) continue;
            if (n < 0) {
                return true;
            }
            if (!XQParser.isNamePart((char)n)) {
                this.unread();
                return true;
            }
            ++n2;
            break;
        } while (n >= 0 && n == string2.charAt(n2++));
        this.port.skip(-n2);
        return false;
    }

    int getAxis() {
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
        int n = 13;
        while (--n >= 0 && axisNames[n] != string) {
        }
        if (n < 0) {
            this.error("unknown axis name '" + string + '\'');
            n = 3;
        }
        return (char)(100 + n);
    }

    int peekOperand() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65 || this.curToken == 81) {
            int n = this.skipSpace(this.nesting != 0);
            if (n == 40 && this.peek() != 58) {
                int n2 = 70;
                switch (this.tokenBuffer[0]) {
                    case 'c': {
                        if (!this.match("comment")) break;
                        n2 = 233;
                        break;
                    }
                    case 'd': {
                        if (!this.match("document-node")) break;
                        n2 = 235;
                        break;
                    }
                    case 'i': {
                        if (!this.match("if")) break;
                        this.unread();
                        return this.curToken;
                    }
                    case 'n': {
                        if (!this.match("node")) break;
                        n2 = 231;
                        break;
                    }
                    case 'p': {
                        if (!this.match("processing-instruction")) break;
                        n2 = 234;
                        break;
                    }
                    case 't': {
                        if (!this.match("text")) break;
                        n2 = 232;
                    }
                }
                this.curToken = n2;
                return this.curToken;
            }
            if (n == 58 && this.peek() == 58) {
                this.curToken = this.getAxis();
                return this.curToken;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.curValue = string;
            switch (n) {
                case 98: {
                    if (!this.lookingAt("declare", "ase-uri")) break;
                    this.curToken = 66;
                    return 66;
                }
                case 100: {
                    if (this.lookingAt("declare", "efault")) {
                        this.getRawToken();
                        if (this.match("function")) {
                            this.curToken = 79;
                            return 79;
                        }
                        if (this.match("element")) {
                            this.curToken = 69;
                            return 69;
                        }
                        if (this.match("collation")) {
                            this.curToken = 71;
                            return 71;
                        }
                        this.error("unrecognized/unimplemented 'declare default'");
                        this.skipToSemicolon();
                        return this.peekOperand();
                    }
                }
                case 101: {
                    if (!this.lookingAt("default", "lement")) break;
                    if (warnOldVersion) {
                        this.error('w', "replace 'default element' by 'declare default element namespace'");
                    }
                    this.curToken = 69;
                    return 69;
                }
                case 102: {
                    if (this.lookingAt("declare", "unction")) {
                        this.curToken = 80;
                        return 80;
                    }
                    if (this.lookingAt("define", "unction")) {
                        if (warnOldVersion) {
                            this.error('w', "replace 'define function' by 'declare function'");
                        }
                        this.curToken = 80;
                        return 80;
                    }
                    if (!this.lookingAt("default", "unction")) break;
                    if (warnOldVersion) {
                        this.error('w', "replace 'default function' by 'declare default function namespace'");
                    }
                    this.curToken = 79;
                    return 79;
                }
                case 109: {
                    if (!this.lookingAt("import", "odule")) break;
                    this.curToken = 73;
                    return 73;
                }
                case 110: {
                    if (this.lookingAt("declare", "amespace")) {
                        this.curToken = 78;
                        return 78;
                    }
                    if (this.lookingAt("default", "amespace")) {
                        if (warnOldVersion) {
                            this.error('w', "replace 'default namespace' by 'declare default element namespace'");
                        }
                        this.curToken = 69;
                        return 69;
                    }
                    if (!this.lookingAt("module", "amespace")) break;
                    this.curToken = 77;
                    return 77;
                }
                case 118: {
                    if (this.lookingAt("declare", "ariable")) {
                        this.curToken = 86;
                        return 86;
                    }
                    if (!this.lookingAt("define", "ariable")) break;
                    if (warnOldVersion) {
                        this.error('w', "replace 'define variable' by 'declare variable'");
                    }
                    this.curToken = 86;
                    return 86;
                }
                case 120: {
                    if (!this.lookingAt("declare", "mlspace")) break;
                    this.curToken = 83;
                    return 83;
                }
            }
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n) && this.curValue.equals("define")) {
                    this.getRawToken();
                    this.curToken = 87;
                }
            }
            return this.curToken;
        }
        if (this.curToken == 67) {
            int n = this.read();
            if (n == 58) {
                this.curToken = this.getAxis();
            } else {
                this.unread(n);
            }
        }
        return this.curToken;
    }

    Declaration pushNamespace(String string, String string2) {
        Declaration declaration = this.makeNamespaceDecl(string, string2);
        this.lexical.push(declaration);
        if (string == "functions$") {
            return declaration;
        }
        string = string == "elements$" ? null : string.intern();
        this.prologNamespaces = new NamespaceBinding(string, string2, this.prologNamespaces);
        return declaration;
    }

    private void pushStandardNamespaces() {
        this.pushNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.pushNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.pushNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.pushNamespace("fn", "http://www.w3.org/2004/10/xpath-functions");
        this.pushNamespace("kawa", "http://kawa.gnu.org/");
        this.pushNamespace("qexo", "http://qexo.gnu.org/");
        this.pushNamespace("local", "http://www.w3.org/2004/10/xquery-local-functions");
    }

    public XQParser(InPort inPort, SourceMessages sourceMessages, XQuery xQuery) {
        super(inPort, sourceMessages);
        this.interpreter = xQuery;
        this.lexical = new NameLookup(xQuery);
        this.nesting = 1;
        this.pushStandardNamespaces();
    }

    public void setInteractive(boolean bl) {
        if (this.interactive != bl) {
            this.nesting = bl ? --this.nesting : ++this.nesting;
        }
        this.interactive = bl;
    }

    private static final int priority(int n) {
        switch (n) {
            case 400: {
                return 1;
            }
            case 401: {
                return 2;
            }
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: {
                return 3;
            }
            case 412: {
                return 4;
            }
            case 413: 
            case 414: {
                return 5;
            }
            case 415: 
            case 416: 
            case 417: 
            case 418: {
                return 6;
            }
            case 419: {
                return 7;
            }
            case 420: 
            case 421: {
                return 8;
            }
            case 422: {
                return 9;
            }
        }
        return 0;
    }

    static Expression makeBinary(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        return new ApplyExp(expression, expressionArray);
    }

    static Expression makeExprSequence(Expression expression, Expression expression2) {
        return XQParser.makeBinary(XQParser.makeFunctionExp("gnu.kawa.functions.AppendValues", "appendValues"), expression, expression2);
    }

    Expression makeBinary(int n, Expression expression, Expression expression2) throws IOException, SyntaxException {
        Expression expression3;
        switch (n) {
            case 413: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "+");
                break;
            }
            case 414: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "-");
                break;
            }
            case 415: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.MultiplyOp", "$St", "mul");
                break;
            }
            case 416: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.DivideOp", "$Sl", "div");
                break;
            }
            case 417: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.DivideOp", "idiv", "idiv");
                break;
            }
            case 418: {
                expression3 = new QuoteExp(new PrimProcedure(ClassType.make("gnu.math.IntNum").getDeclaredMethod("remainder", 2)));
                break;
            }
            case 402: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "=");
                break;
            }
            case 403: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "!=");
                break;
            }
            case 404: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<");
                break;
            }
            case 406: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<=");
                break;
            }
            case 405: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">");
                break;
            }
            case 407: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">=");
                break;
            }
            case 408: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Eq", "is");
                break;
            }
            case 409: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ne", "isnot");
                break;
            }
            case 410: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Gr", ">>");
                break;
            }
            case 411: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ls", "<<");
                break;
            }
            case 412: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.IntegerRange", "integerRange");
                break;
            }
            case 419: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.UnionNodes", "unionNodes");
                break;
            }
            case 420: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "intersectNodes");
                break;
            }
            case 421: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "exceptNodes");
                break;
            }
            default: {
                return this.syntaxError("unimplemented binary op: " + n);
            }
        }
        return XQParser.makeBinary(expression3, expression, expression2);
    }

    private void parseSimpleKindType() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                this.getRawToken();
            } else {
                this.error("expected ')'");
            }
        } else {
            this.warnOldStyleKindTest();
        }
    }

    public Type parseElementType() throws IOException, SyntaxException {
        Symbol symbol;
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                symbol = new Symbol(null);
                this.getRawToken();
            } else {
                symbol = this.parseQName(this.defaultElementNamespace);
                this.getRawToken();
                if (this.curToken == 44) {
                    this.getRawToken();
                    Symbol symbol2 = this.parseQName(this.defaultElementNamespace);
                    this.getRawToken();
                }
                if (this.curToken == 41) {
                    this.getRawToken();
                } else {
                    this.error("expected ')' after element");
                }
            }
        } else {
            this.warnOldStyleKindTest();
            if (this.curToken == 81 || this.curToken == 415 || this.curToken == 65) {
                symbol = this.parseQName(this.defaultElementNamespace);
                this.getRawToken();
            } else {
                symbol = new Symbol(null);
            }
        }
        return new ElementType(symbol);
    }

    private void warnOldStyleKindTest() {
        if (this.warnedOldStyleKindTest) {
            return;
        }
        this.error('w', "old-style KindTest - first one here");
        this.warnedOldStyleKindTest = true;
    }

    public Expression parseOptionalTypeDeclaration() throws IOException, SyntaxException {
        if (!this.match("as")) {
            return null;
        }
        this.getRawToken();
        return this.parseDataType();
    }

    public void setType(Declaration declaration, Expression expression) {
        if (expression instanceof QuoteExp) {
            declaration.setType((Type)((QuoteExp)expression).getValue());
        } else if (expression != null) {
            this.error('w', "type is too complex");
        }
    }

    public Expression parseDataType() throws IOException, SyntaxException {
        int n;
        int n2;
        Type type = this.parseItemType();
        if (type == null) {
            return this.syntaxError("bad syntax - expected DataType");
        }
        if (this.curToken == 63) {
            n2 = 0;
            n = 1;
        } else if (this.curToken == 413) {
            n2 = 1;
            n = -1;
        } else if (this.curToken == 415) {
            n2 = 0;
            n = -1;
        } else {
            n2 = 1;
            n = 1;
        }
        if (n2 != n) {
            this.getRawToken();
            return new QuoteExp(new OccurrenceType(type, n2, n));
        }
        return new QuoteExp(type);
    }

    public Type parseItemType() throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            if (this.match("element")) {
                this.getRawToken();
                return this.parseElementType();
            }
            if (this.match("text")) {
                this.parseSimpleKindType();
                return textNodeTest;
            }
            if (this.match("comment")) {
                this.parseSimpleKindType();
                return commentNodeTest;
            }
            if (this.match("document-node")) {
                this.parseSimpleKindType();
                return documentNodeTest;
            }
            if (this.match("node")) {
                this.parseSimpleKindType();
                return anyNodeTest;
            }
            if (this.match("empty")) {
                this.parseSimpleKindType();
                return Type.void_type;
            }
            if (this.match("item")) {
                this.parseSimpleKindType();
                return Type.pointer_type;
            }
            if (this.match("processing-instruction")) {
                this.parseSimpleKindType();
                return piNodeTest;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.getRawToken();
            Type type = this.interpreter.getTypeFor(string);
            if (type == null) {
                type = ClassType.make(string);
            }
            return type;
        }
        return null;
    }

    Object parseURILiteral() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken != 34) {
            return this.declError("expected a URILiteral");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        return string;
    }

    Expression parseExpr() throws IOException, SyntaxException {
        return this.parseExprSingle();
    }

    final Expression parseExprSingle() throws IOException, SyntaxException {
        return this.parseBinaryExpr(XQParser.priority(400));
    }

    Expression parseBinaryExpr(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpr();
        int n2;
        while ((n2 = this.peekOperator()) != 10 && (n2 != 404 || this.peek() != 47)) {
            Expression[] expressionArray;
            int n3 = XQParser.priority(n2);
            if (n3 < n) {
                return expression;
            }
            char c = this.pushNesting('%');
            boolean bl = false;
            if (n2 == 422) {
                this.curToken = 65;
                bl = this.match("instanceof");
            }
            this.getRawToken();
            this.popNesting(c);
            if (n2 == 422) {
                if (bl) {
                    if (warnOldVersion) {
                        this.error('w', "use 'instanceof of' (two words) instead of 'instanceof'");
                    }
                } else if (this.match("of")) {
                    this.getRawToken();
                } else {
                    this.error('e', "expected 'instance' to be followed by 'of'");
                }
                expressionArray = new Expression[]{expression, this.parseDataType()};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf"), expressionArray);
                continue;
            }
            expressionArray = this.parseBinaryExpr(n3 + 1);
            if (n2 == 401) {
                expression = new IfExp(XQParser.booleanValue(expression), (Expression)expressionArray, QuoteExp.falseExp);
                continue;
            }
            if (n2 == 400) {
                expression = new IfExp(XQParser.booleanValue(expression), QuoteExp.trueExp, (Expression)expressionArray);
                continue;
            }
            expression = this.makeBinary(n2, expression, (Expression)expressionArray);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 414 || this.curToken == 413) {
            int n = this.curToken;
            this.getRawToken();
            expression = this.parseUnionExpr();
            expression = this.makeBinary(n, new QuoteExp(IntNum.zero()), expression);
        } else {
            expression = this.parseUnionExpr();
        }
        return expression;
    }

    Expression parseUnionExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parseIntersectExceptExpr();
        while ((n = this.peekOperator()) == 419) {
            this.getRawToken();
            Expression expression2 = this.parseIntersectExceptExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parsePathExpr();
        while ((n = this.peekOperator()) == 420 || n == 421) {
            this.getRawToken();
            Expression expression2 = this.parsePathExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parsePathExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 47 || this.curToken == 68) {
            Declaration declaration = this.comp.lookup(DOT_VARNAME, -1);
            if (declaration == null) {
                this.error("node test when focus is undefined");
            }
            ReferenceExp referenceExp = new ReferenceExp(DOT_VARNAME, declaration);
            expression = new ApplyExp(ClassType.make("gnu.kawa.xml.Nodes").getDeclaredMethod("root", 1), new Expression[]{referenceExp});
        } else {
            expression = this.parseStepExpr();
        }
        return this.parseRelativePathExpr(expression);
    }

    Expression[] parseNameTest(boolean bl) throws IOException, SyntaxException {
        Expression[] expressionArray = new Expression[2];
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.curToken == 81) {
            int n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            string2 = new String(this.tokenBuffer, 0, n);
            string = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
        } else if (this.curToken == 415) {
            int n = this.read();
            if (n != 58) {
                this.unread(n);
            } else {
                n = this.read();
                if (n < 0) {
                    this.eofError("unexpected end-of-file after '*:'");
                }
                if (XQParser.isNameStart((char)n)) {
                    this.unread();
                    this.getRawToken();
                    if (this.curToken != 65) {
                        this.syntaxError("invalid name test");
                    } else {
                        string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    }
                } else if (n != 42) {
                    this.syntaxError("missing local-name after '*:'");
                }
            }
        } else if (this.curToken == 65) {
            string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string3 = bl ? "" : this.defaultElementNamespace;
        } else if (this.curToken == 67) {
            string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n = this.read();
            if (n != 42) {
                this.syntaxError("invalid characters after 'NCName:'");
            }
            string = null;
        }
        expressionArray[0] = string3 != null ? new QuoteExp((Object)string3) : (string2 == null ? QuoteExp.nullExp : new ReferenceExp((Object)("$Namespace$" + string2).intern()));
        expressionArray[1] = new QuoteExp((Object)(string == null ? null : string.intern()));
        return expressionArray;
    }

    Symbol parseQName(String string) throws IOException, SyntaxException {
        String string2 = null;
        String string3 = null;
        if (this.curToken == 81) {
            return this.resolver.namespaceResolve(new String(this.tokenBuffer, 0, this.tokenBufferLength), false);
        }
        if (this.curToken != 415 && this.curToken == 65) {
            string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string3 = string;
        }
        if (string3 == null) {
            return new Symbol(string2 == null ? null : string2.intern());
        }
        return Symbol.make(string3, string2);
    }

    Expression parseNodeTest(int n) throws IOException, SyntaxException {
        ApplyExp applyExp;
        ClassType classType;
        Object object2;
        Declaration declaration = this.comp.lookup(DOT_VARNAME, -1);
        if (declaration == null) {
            this.error("node test when focus is undefined");
        }
        int n2 = this.peekOperand();
        if (this.curToken == 64 && n < 0) {
            this.getRawToken();
            n = 2;
        }
        Expression[] expressionArray = new Expression[1];
        if (this.curToken == 231 || this.curToken == 232) {
            object2 = this.curToken == 231 ? anyNodeTest : textNodeTest;
            if (this.getRawToken() != 41) {
                return this.syntaxError("missing '()' after node test");
            }
            expressionArray[0] = new QuoteExp(object2);
        } else if (this.curToken == 65 || this.curToken == 81 || this.curToken == 67 || this.curToken == 415) {
            object2 = new Expression[2];
            classType = ClassType.make(n == 2 ? "gnu.kawa.xml.AttributeType" : "gnu.kawa.xml.ElementType");
            applyExp = new ApplyExp(classType.getDeclaredMethod("make", 2), this.parseNameTest(n == 2));
            applyExp.setFlag(2);
            expressionArray[0] = applyExp;
        } else {
            if (n >= 0) {
                return this.syntaxError("unsupported axis '" + axisNames[n] + "::'");
            }
            return null;
        }
        switch (n) {
            default: {
                object2 = "Child";
                break;
            }
            case 4: {
                object2 = "Descendant";
                break;
            }
            case 5: {
                object2 = "DescendantOrSelf";
                break;
            }
            case 12: {
                object2 = "Self";
                break;
            }
            case 9: {
                object2 = "Parent";
                break;
            }
            case 0: {
                object2 = "Ancestor";
                break;
            }
            case 1: {
                object2 = "AncestorOrSelf";
                break;
            }
            case 6: {
                object2 = "Following";
                break;
            }
            case 7: {
                object2 = "FollowingSibling";
                break;
            }
            case 10: {
                object2 = "Preceding";
                break;
            }
            case 11: {
                object2 = "PrecedingSibling";
                break;
            }
            case 2: {
                object2 = "Attribute";
            }
        }
        classType = ClassType.make("gnu.kawa.xml." + (String)object2 + "Axis");
        applyExp = new ApplyExp(classType.getDeclaredMethod("make", 1), expressionArray);
        applyExp.setFlag(2);
        Expression[] expressionArray2 = new Expression[]{new ReferenceExp(DOT_VARNAME, declaration)};
        ApplyExp applyExp2 = new ApplyExp(applyExp, expressionArray2);
        this.getRawToken();
        if (declaration == null) {
            return new ErrorExp("node test when focus is undefined");
        }
        return applyExp2;
    }

    Expression parseRelativePathExpr(Expression expression) throws IOException, SyntaxException {
        while (this.curToken == 47 || this.curToken == 68) {
            Object object2;
            Expression[] expressionArray;
            boolean bl = this.curToken == 68;
            LambdaExp lambdaExp = new LambdaExp(3);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            declaration.setFlag(262144);
            declaration.noteValue(null);
            lambdaExp.addDeclaration(POSITION_VARNAME, LangPrimType.intType);
            lambdaExp.addDeclaration(LAST_VARNAME, LangPrimType.intType);
            this.comp.push(lambdaExp);
            if (bl) {
                this.curToken = 47;
                expressionArray = new ReferenceExp(DOT_VARNAME, declaration);
                object2 = new Expression[]{expressionArray};
                DescendantOrSelfAxis descendantOrSelfAxis = DescendantOrSelfAxis.make(anyNodeTest);
                lambdaExp.body = new ApplyExp(descendantOrSelfAxis, (Expression[])object2);
            } else {
                this.getRawToken();
                lambdaExp.body = this.parseStepExpr();
            }
            this.comp.pop(lambdaExp);
            expressionArray = new Expression[]{expression, lambdaExp};
            object2 = XQParser.makeFunctionExp("gnu.xquery.util.RelativeStep", "relativeStep");
            expression = new ApplyExp((Expression)object2, expressionArray);
        }
        return expression;
    }

    Expression parseStepExpr() throws IOException, SyntaxException {
        if (this.curToken == 46 || this.curToken == 50) {
            int n = this.curToken == 46 ? 12 : 9;
            this.getRawToken();
            Declaration declaration = this.comp.lookup(DOT_VARNAME, -1);
            if (declaration == null) {
                this.error("node test3 when focus is undefined");
            }
            Expression expression = new ReferenceExp(DOT_VARNAME, declaration);
            if (n == 9) {
                Expression[] expressionArray = new Expression[]{expression};
                expression = new ApplyExp(ParentAxis.make(anyNodeTest), expressionArray);
            }
            return this.parseStepQualifiers(expression, n);
        }
        int n = this.peekOperand() - 100;
        if (n >= 0 && n < 13) {
            this.getRawToken();
            return this.parseStepQualifiers(this.parseNodeTest(n), n);
        }
        return this.parseOtherStepExpr();
    }

    Expression parseStepQualifiers(Expression expression, int n) throws IOException, SyntaxException {
        while (this.curToken == 91) {
            Expression expression2;
            int n2;
            int n3 = this.getLineNumber() + 1;
            int n4 = this.getColumnNumber() + 1;
            int n5 = this.seenPosition;
            int n6 = this.seenLast;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(3);
            lambdaExp.setFile(this.getName());
            lambdaExp.setLine(n3, n4);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            lambdaExp.addDeclaration(POSITION_VARNAME, Type.int_type);
            lambdaExp.addDeclaration(LAST_VARNAME, Type.int_type);
            this.comp.push(lambdaExp);
            declaration.noteValue(null);
            Expression expression3 = this.parseExprSequence(93);
            if (n < 0) {
                n2 = 80;
                expression2 = funcExprFilter;
            } else if (n == 0 || n == 1 || n == 9 || n == 10 || n == 11) {
                n2 = 82;
                expression2 = funcReverseFilter;
            } else {
                n2 = 70;
                expression2 = funcForwardFilter;
            }
            expression3.setFile(this.getName());
            expression3.setLine(n3, n4);
            this.comp.pop(lambdaExp);
            lambdaExp.body = expression3;
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(expression2, expressionArray);
        }
        return expression;
    }

    Expression parseOtherStepExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePrimaryExpr();
        expression = this.parseStepQualifiers(expression, -1);
        return expression;
    }

    Expression parsePrimaryExpr() throws IOException, SyntaxException {
        Expression expression = this.parseMaybePrimaryExpr();
        if (expression == null) {
            expression = this.syntaxError("missing expression");
            if (this.curToken != -1) {
                this.getRawToken();
            }
            return expression;
        }
        return expression;
    }

    void parseEntityOrCharRef() throws IOException, SyntaxException {
        int n = this.read();
        if (n == 35) {
            int n2;
            char c;
            int n3;
            int n4;
            n = this.read();
            if (n == 120) {
                n4 = 16;
                n = this.read();
            } else {
                n4 = 10;
            }
            for (n2 = 0; n >= 0 && (n3 = Character.digit(c = (char)n, n4)) >= 0 && n2 < 0x8000000; n2 += n3) {
                n2 *= n4;
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid character reference");
            } else {
                this.tokenBufferAppend(n2);
            }
        } else {
            char c;
            int n5 = this.tokenBufferLength;
            while (n >= 0 && XQParser.isNamePart(c = (char)n)) {
                this.tokenBufferAppend(c);
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid entity reference");
                return;
            }
            String string = new String(this.tokenBuffer, n5, this.tokenBufferLength - n5);
            this.tokenBufferLength = n5;
            this.appendNamedEntity(string);
        }
    }

    void parseContent(char c, Vector vector) throws IOException, SyntaxException {
        boolean bl;
        this.tokenBufferLength = 0;
        int n = vector.size();
        int n2 = n - 1;
        boolean bl2 = bl = !this.preserveBoundarySpace && c == '<';
        Expression expression = XQParser.makeFunctionExp("gnu.kawa.xml.MakeText", "makeText");
        while (true) {
            Object object2;
            int n3;
            block14: {
                block17: {
                    block16: {
                        block15: {
                            if ((n3 = this.read()) == c && c != '<' && this.checkNext(c)) {
                                this.tokenBufferAppend(c);
                                continue;
                            }
                            if (n3 != c && n3 >= 0 && n3 != 123) break block14;
                            if (this.tokenBufferLength <= 0 || bl2) break block15;
                            object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                            if (n3 != c || n != vector.size()) break block16;
                            vector.addElement(new QuoteExp(object2));
                            break block17;
                        }
                        if (n3 != 123 || n2 != vector.size()) break block17;
                        object2 = "";
                    }
                    Expression[] expressionArray = new Expression[]{new QuoteExp(object2)};
                    vector.addElement(new ApplyExp(expression, expressionArray));
                }
                this.tokenBufferLength = 0;
            }
            if (n3 < 0) {
                this.eofError("unexpected end-of-file");
            }
            if (n3 == 123) {
                n3 = this.read();
                if (n3 == 123) {
                    this.tokenBufferAppend(123);
                    bl2 = false;
                    continue;
                }
                this.unread(n3);
                object2 = this.parseEnclosedExpr();
                if (c != '<') {
                    object2 = XQParser.stringValue((Expression)object2);
                }
                vector.addElement(object2);
                this.tokenBufferLength = 0;
                n2 = vector.size();
                bl2 = bl;
                continue;
            }
            if (n3 == 125) {
                n3 = this.read();
                if (n3 == 125) {
                    this.tokenBufferAppend(125);
                    bl2 = false;
                    continue;
                }
                this.error("unexpected '}' in element content");
                this.unread(n3);
                continue;
            }
            if (n3 == c) {
                if (c != '<' || (n3 = this.read()) == 47) break;
                vector.addElement(this.parseXMLConstructor(n3));
                this.tokenBufferLength = 0;
                bl2 = bl;
                continue;
            }
            if (n3 == 38) {
                this.parseEntityOrCharRef();
                bl2 = false;
                continue;
            }
            if (bl2) {
                bl2 = Character.isWhitespace((char)n3);
            }
            this.tokenBufferAppend((char)n3);
        }
    }

    Expression parseEnclosedExpr() throws IOException, SyntaxException {
        char c = this.pushNesting('{');
        this.peekNonSpace("unexpected end-of-file after '{'");
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        this.getRawToken();
        Expression expression = this.parseExpr();
        while (this.curToken != 125) {
            if (this.curToken == -1 || this.curToken == 41 || this.curToken == 93) {
                expression = this.syntaxError("missing '}'");
                break;
            }
            if (this.curToken != 44) {
                expression = this.syntaxError("missing '}' or ','");
            } else {
                this.getRawToken();
            }
            expression = XQParser.makeExprSequence(expression, this.parseExpr());
        }
        expression.setFile(this.getName());
        expression.setLine(n, n2);
        this.popNesting(c);
        return expression;
    }

    public static Expression stringValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.StringValue", "string");
        return new ApplyExp(expression2, expressionArray);
    }

    public static Expression booleanValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.BooleanValue", "booleanValue");
        return new ApplyExp(expression2, expressionArray);
    }

    Expression parseNameSpec(String string, boolean bl) throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            return new QuoteExp((Object)string2.intern());
        }
        if (this.curToken == 123) {
            return this.parseEnclosedExpr();
        }
        return null;
    }

    Declaration makeNamespaceDecl(String string, String string2) {
        String string3 = ("$Namespace$" + string).intern();
        Declaration declaration = new Declaration(string3);
        declaration.setType(Type.tostring_type);
        declaration.setFlag(0x204000);
        declaration.setPrivate(true);
        declaration.noteValue(new QuoteExp((Object)string2));
        return declaration;
    }

    Expression parseXMLConstructor(int n) throws IOException, SyntaxException {
        Expression expression;
        if (n == 33) {
            n = this.read();
            if (n == 45 && this.peek() == 45) {
                this.skip();
                this.getDelimited("-->");
                Expression[] expressionArray = new Expression[]{new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength))};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.CommentConstructor", "commentConstructor"), expressionArray);
            } else if (n == 91 && this.read() == 67 && this.read() == 68 && this.read() == 65 && this.read() == 84 && this.read() == 65 && this.read() == 91) {
                this.getDelimited("]]>");
                Expression[] expressionArray = new Expression[]{new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength))};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.MakeCDATA", "makeCDATA"), expressionArray);
            } else {
                expression = this.syntaxError("'<!' must be followed by '--' or '[CDATA['");
            }
        } else if (n == 63) {
            n = this.peek();
            if (n < 0 || !XQParser.isNameStart((char)n) || this.getRawToken() != 65) {
                this.syntaxError("missing target after '<?'");
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.skipSpace();
            this.unread();
            this.getDelimited("?>");
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            Expression[] expressionArray = new Expression[]{new QuoteExp((Object)string), new QuoteExp((Object)string2)};
            expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.MakeProcInst", "makeProcInst"), expressionArray);
        } else {
            this.unread(n);
            this.getRawToken();
            char c = this.pushNesting('<');
            expression = this.parseElementConstructor();
            this.popNesting(c);
        }
        return expression;
    }

    Expression castQName(Expression expression) {
        return new ApplyExp(new ReferenceExp(XQResolveNames.xsQNameDecl), new Expression[]{expression});
    }

    Expression parseElementConstructor() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        Object object3;
        int n;
        int n2;
        if (this.curToken != 65 && this.curToken != 81) {
            return this.syntaxError("expected QName after '<'");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.castQName(new QuoteExp((Object)string)));
        NamespaceBinding namespaceBinding = this.namespaceBindings;
        while ((n2 = this.skipSpace()) >= 0 && n2 != 62 && n2 != 47) {
            Object object4;
            this.unread(n2);
            this.getRawToken();
            n = vector.size();
            if (this.curToken != 65 && this.curToken != 81) break;
            object3 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n3 = this.getLineNumber() + 1;
            int n4 = this.getColumnNumber() + 1 - this.tokenBufferLength;
            String string2 = null;
            if (this.curToken == 65) {
                if (((String)object3).equals("xmlns")) {
                    string2 = "";
                }
            } else if (((String)object3).startsWith("xmlns:")) {
                string2 = ((String)object3).substring(6).intern();
            }
            object2 = string2 != null ? null : MakeAttribute.makeAttributeExp;
            vector.addElement(this.castQName(new QuoteExp(object3)));
            n2 = this.skipSpace();
            if (n2 != 61) {
                return this.syntaxError("missing '=' after attribute");
            }
            n2 = this.skipSpace();
            if (n2 == 123) {
                if (warnOldVersion) {
                    this.error('w', "enclosed attribute value expression should be quoted");
                }
                vector.addElement(XQParser.stringValue(this.parseEnclosedExpr()));
            } else {
                this.parseContent((char)n2, vector);
            }
            int n5 = vector.size() - n;
            if (string2 != null) {
                object4 = "";
                if (n5 == 1) {
                    object4 = "";
                } else if (n5 > 2 || !(vector.elementAt(n + 1) instanceof QuoteExp)) {
                    this.syntaxError("enclosed expression not allowed in namespace declaration");
                } else {
                    object4 = ((QuoteExp)vector.elementAt(n + 1)).getValue().toString().intern();
                }
                vector.setSize(n);
                if (string2 == "") {
                    string2 = null;
                }
                this.namespaceBindings = new NamespaceBinding(string2, (String)(object4 == "" ? null : object4), this.namespaceBindings);
                continue;
            }
            objectArray = new Expression[n5];
            int n6 = n5;
            while (--n6 >= 0) {
                objectArray[n6] = (Expression)vector.elementAt(n + n6);
            }
            vector.setSize(n);
            object4 = new ApplyExp((Expression)object2, (Expression[])objectArray);
            ((Expression)object4).setFile(this.getName());
            ((Expression)object4).setLine(n3, n4);
            vector.addElement(object4);
        }
        n = 0;
        if (n2 == 47) {
            n2 = this.read();
            if (n2 == 62) {
                n = 1;
            } else {
                this.unread(n2);
            }
        }
        if (n == 0) {
            if (n2 != 62) {
                return this.syntaxError("missing '>' after start element");
            }
            this.parseContent('<', vector);
            n2 = this.skipSpace();
            if (n2 >= 0 && n2 != 62) {
                this.unread(n2);
                this.getRawToken();
                if (this.curToken != 65 && this.curToken != 81) {
                    return this.syntaxError("invalid tag syntax after '</'");
                }
                object3 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (!((String)object3).equals(string)) {
                    return this.syntaxError("'<" + string + ">' closed by '</" + (String)object3 + ">'");
                }
                n2 = this.skipSpace();
            }
            if (n2 != 62) {
                return this.syntaxError("missing '>' after end element");
            }
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        object3 = new MakeElement();
        Expression expression = new ApplyExp(new QuoteExp(object3), (Expression[])objectArray);
        NamespaceBinding namespaceBinding2 = this.namespaceBindings.reversePrefix(namespaceBinding);
        if (namespaceBinding != namespaceBinding2) {
            int n7 = namespaceBinding2.count(namespaceBinding);
            object2 = new Expression[n7];
            LetExp letExp = new LetExp((Expression[])object2);
            int n8 = 0;
            for (NamespaceBinding namespaceBinding3 = namespaceBinding2; namespaceBinding3 != namespaceBinding; namespaceBinding3 = namespaceBinding3.getNext()) {
                Declaration declaration = this.makeNamespaceDecl(namespaceBinding3.getPrefix(), namespaceBinding3.getUri());
                letExp.addDeclaration(declaration);
                object2[n8++] = declaration.getValue();
            }
            letExp.setBody(expression);
            expression = letExp;
            this.namespaceBindings = namespaceBinding;
        }
        if (namespaceBinding2 != NamespaceBinding.predefinedXML) {
            ((MakeElement)object3).setNamespaceNodes(namespaceBinding2);
        }
        return expression;
    }

    Expression parseParenExpr() throws IOException, SyntaxException {
        this.getRawToken();
        char c = this.pushNesting('(');
        Expression expression = this.parseExprSequence(41);
        this.popNesting(c);
        if (this.curToken == -1) {
            this.eofError("missing ')' - unexpected end-of-file");
        }
        return expression;
    }

    Expression parseExprSequence(int n) throws IOException, SyntaxException {
        if (this.curToken == n || this.curToken == -1) {
            return QuoteExp.voidExp;
        }
        Expression expression = null;
        while (true) {
            Expression expression2 = this.parseExpr();
            Expression expression3 = expression = expression == null ? expression2 : XQParser.makeExprSequence(expression, expression2);
            if (this.curToken == n || this.curToken == -1) break;
            if (this.nesting == 0 && this.curToken == 10) {
                return expression;
            }
            if (this.curToken != 44) {
                return this.syntaxError(n == 41 ? "expected ')'" : "confused by syntax error");
            }
            this.getRawToken();
        }
        return expression;
    }

    Expression parseTypeSwitch() throws IOException, SyntaxException {
        Object object2;
        LambdaExp lambdaExp;
        Declaration declaration;
        char c = this.pushNesting('t');
        Expression expression = this.parseParenExpr();
        this.getRawToken();
        Object var3_3 = null;
        Vector<Expression> vector = new Vector<Expression>();
        vector.addElement(expression);
        while (this.match("case")) {
            this.pushNesting('c');
            this.getRawToken();
            if (this.curToken == 36) {
                declaration = this.parseVariableDeclaration();
                if (declaration == null) {
                    return this.syntaxError("missing Variable after '$'");
                }
                this.getRawToken();
                if (this.match("as")) {
                    this.getRawToken();
                } else {
                    this.error('e', "missing 'as'");
                }
            } else {
                declaration = new Declaration("(arg)");
            }
            declaration.setType((Type)((QuoteExp)this.parseDataType()).getValue());
            this.popNesting('t');
            lambdaExp = new LambdaExp(1);
            lambdaExp.addDeclaration(declaration);
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'case'");
            }
            this.comp.push(lambdaExp);
            this.pushNesting('r');
            lambdaExp.body = object2 = this.parseExpr();
            this.popNesting('t');
            this.comp.pop(lambdaExp);
            vector.addElement(lambdaExp);
        }
        if (this.curToken == 36) {
            declaration = this.parseVariableDeclaration();
            if (declaration == null) {
                return this.syntaxError("missing Variable after '$'");
            }
            this.getRawToken();
        } else {
            declaration = new Declaration("(arg)");
        }
        lambdaExp = new LambdaExp(1);
        lambdaExp.addDeclaration(declaration);
        if (this.match("default")) {
            this.getRawToken();
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'default'");
            }
            this.comp.push(lambdaExp);
            lambdaExp.body = object2 = this.parseExpr();
            this.comp.pop(lambdaExp);
        } else {
            lambdaExp.body = QuoteExp.voidExp;
            this.error('w', "no 'default' clause in 'typeswitch'");
        }
        vector.addElement(lambdaExp);
        this.popNesting(c);
        object2 = new Expression[vector.size()];
        vector.copyInto((Object[])object2);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.reflect.TypeSwitch", "typeSwitch"), (Expression[])object2);
    }

    char matchConstructorKeyword(int n) throws IOException, SyntaxException {
        if (this.curToken == 65) {
            int n2;
            if (this.match("element")) {
                n2 = 101;
            } else if (this.match("attribute")) {
                n2 = 97;
            } else if (this.match("document") && n == 123) {
                n2 = 100;
            } else if (this.match("text") && n == 123) {
                n2 = 116;
            } else if (this.match("comment") && n == 123) {
                n2 = 99;
            } else {
                return '\u0000';
            }
            if (n != 123 && (n2 == 101 || n2 == 97)) {
                if (!XQParser.isNameStart((char)n)) {
                    return '\u0000';
                }
                this.unread();
                this.mark();
                this.getRawToken();
                this.getRawToken();
                if (this.curToken != 123) {
                    n2 = 0;
                }
                this.reset();
                this.read();
            }
            return (char)n2;
        }
        return '\u0000';
    }

    Expression parseMaybePrimaryExpr() throws IOException, SyntaxException {
        Expression expression;
        int n = this.curLine;
        int n2 = this.curColumn;
        int n3 = this.peekOperand();
        if (n3 == 40) {
            expression = this.parseParenExpr();
        } else if (n3 == 123) {
            expression = this.syntaxError("saw unexpected '{' - assume you meant '('");
            this.parseEnclosedExpr();
        } else if (n3 == 404) {
            int n4 = this.read();
            if (n4 == 47) {
                this.getRawToken();
                String string = this.curToken == 65 || this.curToken == 81 || this.curToken == 67 ? "saw end tag '</" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + ">' not in an element constructor" : "saw end tag '</' not in an element constructor";
                this.curLine = n;
                this.curColumn = n2;
                Expression expression2 = this.syntaxError(string);
                while (this.curToken != 405 && this.curToken != -1 && this.curToken != 10) {
                    this.getRawToken();
                }
                return expression2;
            }
            expression = this.parseXMLConstructor(n4);
            expression.setFile(this.getName());
            expression.setLine(n, n2);
        } else if (n3 == 34) {
            expression = new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength).intern());
        } else if (n3 == 48) {
            IntNum intNum = IntNum.valueOf(this.tokenBuffer, 0, this.tokenBufferLength, 10, false);
            expression = new QuoteExp(intNum);
        } else if (n3 == 49) {
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            try {
                expression = new QuoteExp(new DFloNum(string));
            }
            catch (Throwable throwable) {
                expression = this.syntaxError("invalid decimal literal: '" + string + "'");
            }
        } else if (n3 == 36) {
            Object object2 = this.parseVariable();
            if (object2 == null) {
                return this.syntaxError("missing Variable");
            }
            expression = new ReferenceExp(object2);
        } else if (n3 == 70) {
            Object[] objectArray;
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            if (string.equals("typeswitch")) {
                return this.parseTypeSwitch();
            }
            char c = this.pushNesting('(');
            this.getRawToken();
            Vector<Object[]> vector = new Vector<Object[]>(10);
            if (this.curToken != 41) {
                while (true) {
                    objectArray = this.parseExpr();
                    vector.addElement(objectArray);
                    if (this.curToken == 41) break;
                    if (this.curToken != 44) {
                        return this.syntaxError("missing ')' after function call");
                    }
                    this.getRawToken();
                }
            }
            objectArray = new Expression[vector.size()];
            vector.copyInto(objectArray);
            ReferenceExp referenceExp = new ReferenceExp(string, null);
            referenceExp.setProcedureName(true);
            expression = new ApplyExp(referenceExp, (Expression[])objectArray);
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            this.popNesting(c);
        } else {
            if (n3 == 65 || n3 == 81) {
                int n5 = this.skipSpace(this.nesting != 0);
                if (n5 == 36) {
                    Expression expression3;
                    if (this.match("let")) {
                        expression3 = this.parseFLWRExpression(false);
                    } else if (this.match("for")) {
                        expression3 = this.parseFLWRExpression(true);
                    } else if (this.match("some")) {
                        expression3 = this.parseQuantifiedExpr(false);
                    } else if (this.match("every")) {
                        expression3 = this.parseQuantifiedExpr(true);
                    } else {
                        return this.syntaxError("invalid syntax - variable following name");
                    }
                    expression3.setFile(this.getName());
                    expression3.setLine(n, n2 - 3);
                    return expression3;
                }
                char c = this.matchConstructorKeyword(n5);
                if (c != '\u0000') {
                    Expression expression4;
                    Object[] objectArray;
                    if (n5 >= 0) {
                        this.unread();
                    }
                    this.getRawToken();
                    Vector<Expression> vector = new Vector<Expression>();
                    if (c == 'e' || c == 'a') {
                        Expression expression5 = this.parseNameSpec(this.defaultElementNamespace, c == 'a');
                        if (expression5 == null) {
                            return this.syntaxError("missing element/attribute name");
                        }
                        vector.addElement(this.castQName(expression5));
                        if (c == 'e') {
                            objectArray = new MakeElement();
                            if (this.namespaceBindings != NamespaceBinding.predefinedXML) {
                                objectArray.setNamespaceNodes(this.namespaceBindings);
                            }
                            expression4 = new QuoteExp(objectArray);
                        } else {
                            expression4 = MakeAttribute.makeAttributeExp;
                        }
                        this.getRawToken();
                    } else {
                        expression4 = c == 'd' ? XQParser.makeFunctionExp("gnu.kawa.xml.DocumentConstructor", "documentConstructor") : (c == 'c' ? XQParser.makeFunctionExp("gnu.kawa.xml.CommentConstructor", "commentConstructor") : XQParser.makeFunctionExp("gnu.kawa.xml.MakeText", "makeText"));
                    }
                    char c2 = this.pushNesting('{');
                    this.peekNonSpace("unexpected end-of-file after '{'");
                    if (this.curToken != 123) {
                        return this.syntaxError("missing '{'");
                    }
                    this.getRawToken();
                    if (c == 't' || c == 'c') {
                        vector.addElement(this.parseExprSequence(125));
                    } else if (this.curToken != 125) {
                        vector.addElement(this.parseExpr());
                        while (this.curToken == 44) {
                            this.getRawToken();
                            vector.addElement(this.parseExpr());
                        }
                    }
                    this.popNesting(c2);
                    if (this.curToken != 125) {
                        return this.syntaxError("missing '}'");
                    }
                    objectArray = new Expression[vector.size()];
                    vector.copyInto(objectArray);
                    ApplyExp applyExp = new ApplyExp(expression4, (Expression[])objectArray);
                    applyExp.setFile(this.getName());
                    applyExp.setLine(n, n2);
                    this.getRawToken();
                    return applyExp;
                }
                if (n5 == 40 && this.tokenBufferLength == 2 && this.tokenBuffer[0] == 'i' && this.tokenBuffer[1] == 'f') {
                    return this.parseIfExpr();
                }
                if (n5 >= 0) {
                    this.unread();
                }
                return this.parseNodeTest(-1);
            }
            if (n3 == 415 || n3 == 67 || n3 == 64 || n3 == 231 || n3 == 232) {
                return this.parseNodeTest(-1);
            }
            return null;
        }
        this.getRawToken();
        return expression;
    }

    public Expression parseIfExpr() throws IOException, SyntaxException {
        char c = this.pushNesting('i');
        Expression expression = this.parseParenExpr();
        this.getRawToken();
        if (!this.match("then")) {
            this.syntaxError("missing 'then'");
        } else {
            this.getRawToken();
        }
        Expression expression2 = this.parseExpr();
        if (!this.match("else")) {
            this.syntaxError("missing 'else'");
        } else {
            this.getRawToken();
        }
        this.popNesting(c);
        Expression expression3 = this.parseExpr();
        return new IfExp(XQParser.booleanValue(expression), expression2, expression3);
    }

    public boolean match(String string) {
        if (this.curToken != 65) {
            return false;
        }
        int n = string.length();
        if (this.tokenBufferLength != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = this.tokenBuffer[n2])) continue;
            return false;
        }
        return true;
    }

    public Object parseVariable() throws IOException, SyntaxException {
        if (this.curToken == 36) {
            this.getRawToken();
        } else {
            this.syntaxError("missing '$' before variable name");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        if (this.curToken == 81) {
            return string;
        }
        if (this.curToken == 65) {
            return Symbol.make("", string);
        }
        return null;
    }

    public Declaration parseVariableDeclaration() throws IOException, SyntaxException {
        Object object2 = this.parseVariable();
        if (object2 == null) {
            return null;
        }
        Declaration declaration = new Declaration(object2);
        declaration.setFile(this.getName());
        declaration.setLine(this.getLineNumber() + 1, this.getColumnNumber() + 1 - this.tokenBufferLength);
        return declaration;
    }

    public Expression parseFLWRExpression(boolean bl) throws IOException, SyntaxException {
        int n = this.flworDeclsFirst;
        this.flworDeclsFirst = this.flworDeclsCount;
        Expression expression = this.parseFLWRInner(bl);
        if (this.match("order")) {
            Expression[] expressionArray;
            int n2;
            this.getRawToken();
            if (this.match("by")) {
                this.getRawToken();
            } else {
                this.error("missing 'by' following 'order'");
            }
            Stack<Object> stack = new Stack<Object>();
            while (true) {
                boolean bl2 = false;
                n2 = this.defaultEmptyOrder;
                expressionArray = new LambdaExp(this.flworDeclsCount - this.flworDeclsFirst);
                for (int i = this.flworDeclsFirst; i < this.flworDeclsCount; ++i) {
                    expressionArray.addDeclaration(this.flworDecls[i].getSymbol());
                }
                this.comp.push((ScopeExp)expressionArray);
                expressionArray.body = this.parseExprSingle();
                this.comp.pop((ScopeExp)expressionArray);
                stack.push(expressionArray);
                if (this.match("ascending")) {
                    this.getRawToken();
                } else if (this.match("descending")) {
                    this.getRawToken();
                    bl2 = true;
                }
                if (this.match("empty")) {
                    this.getRawToken();
                    if (this.match("greatest")) {
                        this.getRawToken();
                        n2 = 71;
                    } else if (this.match("least")) {
                        this.getRawToken();
                        n2 = 76;
                    } else {
                        this.error("'empty' sequence order must be 'greatest' or 'least'");
                    }
                }
                stack.push(new QuoteExp((Object)((bl2 ? "D" : "A") + (char)n2)));
                NamedCollator namedCollator = this.defaultCollator;
                if (this.match("collation")) {
                    Object object2 = this.parseURILiteral();
                    if (object2 instanceof String) {
                        try {
                            namedCollator = NamedCollator.make((String)object2);
                        }
                        catch (Exception exception) {
                            this.error("unknown collation '" + object2 + "'");
                        }
                    }
                    this.getRawToken();
                }
                stack.push(new QuoteExp(namedCollator));
                if (this.curToken != 44) break;
                this.getRawToken();
            }
            if (!this.match("return")) {
                return this.syntaxError("expected 'return' clause");
            }
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(this.flworDeclsCount - this.flworDeclsFirst);
            for (n2 = this.flworDeclsFirst; n2 < this.flworDeclsCount; ++n2) {
                lambdaExp.addDeclaration(this.flworDecls[n2].getSymbol());
            }
            this.comp.push(lambdaExp);
            lambdaExp.body = this.parseExprSingle();
            this.comp.pop(lambdaExp);
            n2 = stack.size();
            expressionArray = new Expression[2 + n2];
            expressionArray[0] = expression;
            expressionArray[1] = lambdaExp;
            for (int i = 0; i < n2; ++i) {
                expressionArray[2 + i] = (Expression)stack.elementAt(i);
            }
            return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.OrderedMap", "orderedMap"), expressionArray);
        }
        this.flworDeclsFirst = n;
        return expression;
    }

    public Expression parseFLWRInner(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        ScopeExp scopeExp;
        Expression expression2;
        Object object2;
        char c = this.pushNesting(bl ? (char)'f' : 'l');
        this.curToken = 36;
        Declaration declaration = this.parseVariableDeclaration();
        if (declaration == null) {
            return this.syntaxError("missing Variable - saw " + this.tokenString());
        }
        if (this.flworDecls == null) {
            this.flworDecls = new Declaration[8];
        } else if (this.flworDeclsCount >= this.flworDecls.length) {
            object2 = new Declaration[2 * this.flworDeclsCount];
            System.arraycopy(this.flworDecls, 0, object2, 0, this.flworDeclsCount);
            this.flworDecls = object2;
        }
        this.flworDecls[this.flworDeclsCount++] = declaration;
        this.getRawToken();
        object2 = this.parseOptionalTypeDeclaration();
        Expression[] expressionArray = new Expression[1];
        Declaration declaration2 = null;
        if (bl) {
            boolean bl2 = this.match("at");
            expression2 = new LambdaExp(bl2 ? 2 : 1);
            if (bl2) {
                this.getRawToken();
                if (this.curToken == 36) {
                    declaration2 = this.parseVariableDeclaration();
                    this.getRawToken();
                }
                if (declaration2 == null) {
                    this.syntaxError("missing Variable after 'at'");
                }
            }
            scopeExp = expression2;
            if (this.match("in")) {
                this.getRawToken();
            } else {
                if (this.curToken == 76) {
                    this.getRawToken();
                }
                this.syntaxError("missing 'in' in 'for' clause");
            }
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            } else {
                if (this.match("in")) {
                    this.getRawToken();
                }
                this.syntaxError("missing ':=' in 'let' clause");
            }
            LetExp letExp = new LetExp(expressionArray);
            scopeExp = letExp;
        }
        expressionArray[0] = this.parseExprSingle();
        this.popNesting(c);
        this.comp.push(scopeExp);
        scopeExp.addDeclaration(declaration);
        this.setType(declaration, (Expression)object2);
        if (bl) {
            declaration.noteValue(null);
            declaration.setFlag(262144);
        }
        if (declaration2 != null) {
            scopeExp.addDeclaration(declaration2);
            declaration2.setType(LangPrimType.intType);
            declaration2.noteValue(null);
            declaration2.setFlag(262144);
        }
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression = this.parseFLWRInner(bl);
        } else if (this.match("for")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'for'");
            }
            expression = this.parseFLWRInner(true);
        } else if (this.match("let")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'let'");
            }
            expression = this.parseFLWRInner(false);
        } else {
            char c2 = this.pushNesting('w');
            if (this.curToken == 196) {
                this.getRawToken();
                expression2 = this.parseExprSingle();
            } else {
                expression2 = this.match("where") ? this.parseExprSingle() : null;
            }
            this.popNesting(c2);
            boolean bl3 = this.match("stable");
            if (bl3) {
                this.getRawToken();
            }
            boolean bl4 = this.match("return");
            boolean bl5 = this.match("order");
            if (!(bl4 || bl5 || this.match("let") || this.match("for"))) {
                return this.syntaxError("missing 'return' clause");
            }
            if (!bl5) {
                this.peekNonSpace("unexpected eof-of-file after 'return'");
            }
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl4) {
                this.getRawToken();
            }
            if (bl5) {
                int n3 = this.flworDeclsCount - this.flworDeclsFirst;
                Expression[] expressionArray2 = new Expression[n3];
                for (int i = 0; i < n3; ++i) {
                    expressionArray2[i] = new ReferenceExp(this.flworDecls[this.flworDeclsFirst + i]);
                }
                expression = new ApplyExp(ClassType.make("gnu.xquery.util.OrderedMap").getDeclaredMethod("makeTuple$V", 1), expressionArray2);
            } else {
                expression = this.parseExprSingle();
            }
            if (expression2 != null) {
                expression = new IfExp(XQParser.booleanValue(expression2), expression, QuoteExp.voidExp);
            }
            expression.setFile(this.getName());
            expression.setLine(n, n2);
        }
        this.comp.pop(scopeExp);
        if (bl) {
            expression2 = (LambdaExp)scopeExp;
            expression2.body = expression;
            Expression[] expressionArray3 = new Expression[]{scopeExp, expressionArray[0]};
            return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", expression2.min_args == 1 ? "valuesMap" : "valuesMapWithPos"), expressionArray3);
        }
        ((LetExp)scopeExp).setBody(expression);
        return scopeExp;
    }

    public Expression parseQuantifiedExpr(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        char c = this.pushNesting(bl ? (char)'e' : 's');
        this.curToken = 36;
        Declaration declaration = this.parseVariableDeclaration();
        if (declaration == null) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp(1);
        lambdaExp.addDeclaration(declaration);
        declaration.noteValue(null);
        declaration.setFlag(262144);
        this.setType(declaration, this.parseOptionalTypeDeclaration());
        if (this.match("in")) {
            this.getRawToken();
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            }
            this.syntaxError("missing 'in' in QuantifiedExpr");
        }
        Expression[] expressionArray = new Expression[]{this.parseExprSingle()};
        this.popNesting(c);
        this.comp.push(lambdaExp);
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression = this.parseQuantifiedExpr(bl);
        } else {
            boolean bl2 = this.match("satisfies");
            if (!(bl2 || this.match("every") || this.match("some"))) {
                return this.syntaxError("missing 'satisfies' clause");
            }
            this.peekNonSpace("unexpected eof-of-file after 'satisfies'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl2) {
                this.getRawToken();
            }
            expression = this.parseExprSingle();
            expression.setFile(this.getName());
            expression.setLine(n, n2);
        }
        this.comp.pop(lambdaExp);
        lambdaExp.body = expression;
        Expression[] expressionArray2 = new Expression[]{lambdaExp, expressionArray[0]};
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.ValuesEvery", bl ? "every" : "some"), expressionArray2);
    }

    public Expression parseFunctionDefinition(int n, int n2) throws IOException, SyntaxException {
        Object object2;
        if (this.curToken != 81 && this.curToken != 65) {
            return this.syntaxError("missing function name");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        if (string.indexOf(58) < 0) {
            this.error('w', "defined function must have qualified name");
        }
        this.getRawToken();
        if (this.curToken != 40) {
            return this.syntaxError("missing parameter list:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp();
        lambdaExp.setFile(this.getName());
        lambdaExp.setLine(n, n2);
        lambdaExp.setName(string);
        Declaration declaration = this.comp.currentScope().addDeclaration(string);
        if (this.comp.isStatic()) {
            declaration.setFlag(2048);
        }
        this.comp.push(declaration);
        declaration.setCanRead(true);
        declaration.setProcedureDecl(true);
        declaration.setFile(this.getName());
        declaration.setLine(n, n2);
        this.comp.push(lambdaExp);
        if (this.curToken != 41) {
            while (true) {
                if ((object2 = this.parseVariableDeclaration()) == null) {
                    this.error("missing parameter name");
                } else {
                    lambdaExp.addDeclaration((Declaration)object2);
                    this.getRawToken();
                    ++lambdaExp.min_args;
                    ++lambdaExp.max_args;
                    this.setType((Declaration)object2, this.parseOptionalTypeDeclaration());
                }
                if (this.curToken == 41) break;
                if (this.curToken != 44) {
                    return this.syntaxError("missing ',' in parameter list");
                }
                this.getRawToken();
            }
        }
        this.getRawToken();
        object2 = this.parseOptionalTypeDeclaration();
        lambdaExp.body = this.parseEnclosedExpr();
        this.comp.pop(lambdaExp);
        if (object2 != null) {
            Convert.setCoercedReturnValue(lambdaExp, (Expression)object2, this.interpreter);
        }
        SetExp setExp = new SetExp(declaration, (Expression)lambdaExp);
        setExp.setDefining(true);
        declaration.noteValue(lambdaExp);
        return setExp;
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.parse(null);
    }

    void parseSeparator() throws IOException, SyntaxException {
        int n = this.port.getLineNumber() + 1;
        int n2 = this.port.getColumnNumber() + 1;
        int n3 = this.skipSpace(this.nesting != 0);
        if (n3 == 59) {
            return;
        }
        if (warnOldVersion && n3 != 10) {
            this.curLine = n;
            this.curColumn = n2;
            this.error('w', "missing ';' after declaration");
        }
        if (n3 >= 0) {
            this.unread(n3);
        }
    }

    public Expression parse(Compilation compilation) throws IOException, SyntaxException {
        int n;
        this.comp = compilation;
        int n2 = this.skipSpace();
        if (n2 < 0) {
            return null;
        }
        this.unread(n2);
        int n3 = this.getLineNumber() + 1;
        int n4 = this.getColumnNumber() + 1;
        if (n2 == 35 && n3 == 1 && n4 == 1) {
            this.read();
            n2 = this.read();
            if (n2 != 33 || (n2 = this.read()) != 47) {
                this.error("'#' is only allowed in initial '#!/PROGRAM'");
            }
            while (n2 != 13 && n2 != 10 && n2 >= 0) {
                n2 = this.read();
            }
        }
        if (this.getRawToken() == -1) {
            return null;
        }
        this.peekOperand();
        if (this.curToken == 87) {
            int n5 = this.getLineNumber() + 1;
            int n6 = this.getColumnNumber() + 1;
            int n7 = this.peekNonSpace("unexpected end-of-file after 'define QName'");
            if (n7 == 40) {
                this.syntaxError("'missing 'function' after 'define'");
                this.curToken = 65;
                return this.parseFunctionDefinition(n5, n6);
            }
            return this.syntaxError("missing keyword after 'define'");
        }
        if (this.curToken == 80) {
            int n8 = this.getLineNumber() + 1;
            int n9 = this.getColumnNumber() + 1;
            this.getRawToken();
            this.peekNonSpace("unexpected end-of-file after 'define function'");
            char c = this.pushNesting('d');
            Expression expression = this.parseFunctionDefinition(n8, n9);
            this.popNesting(c);
            this.parseSeparator();
            expression.setFile(this.getName());
            expression.setLine(n3, n4);
            return expression;
        }
        if (this.curToken == 86) {
            Expression[] expressionArray;
            this.getRawToken();
            Declaration declaration = this.parseVariableDeclaration();
            if (declaration == null) {
                return this.syntaxError("missing Variable");
            }
            compilation.currentScope().addDeclaration(declaration);
            this.getRawToken();
            Expression expression = this.parseOptionalTypeDeclaration();
            compilation.push(declaration);
            declaration.setCanRead(true);
            declaration.setFlag(16384);
            Expression expression2 = null;
            boolean bl = false;
            if (this.curToken == 402 || this.curToken == 76) {
                if (this.curToken == 402) {
                    this.error("declare variable contains '=' instead of ':='");
                }
                this.getRawToken();
                bl = true;
            }
            if (this.curToken == 123) {
                if (warnOldVersion) {
                    this.error('w', "obsolate '{' in variable declaration");
                }
                expression2 = this.parseEnclosedExpr();
                this.parseSeparator();
            } else if (this.match("external")) {
                expressionArray = new Expression[]{new ApplyExp(new ReferenceExp(XQResolveNames.xsQNameDecl), new Expression[]{new QuoteExp((Object)declaration.getName())}), expression == null ? QuoteExp.nullExp : expression};
                expression2 = new ApplyExp(ClassType.make("gnu.xquery.lang.XQuery").getDeclaredMethod("getExternal", 2), expressionArray);
                expression2.setFile(this.getName());
                expression2.setLine(this.curLine, this.curColumn);
                this.getRawToken();
            } else {
                expression2 = this.parseExpr();
                expressionArray = null;
                if (!bl || expression2 == null) {
                    expressionArray = this.syntaxError("expected ':= init' or 'external'");
                }
                if (expression2 == null) {
                    expression2 = expressionArray;
                }
            }
            expressionArray = new SetExp(declaration, expression2);
            expressionArray.setDefining(true);
            declaration.noteValue(expression2);
            return expressionArray;
        }
        if (this.curToken == 65 && "namespace".equals((String)this.curValue)) {
            if (warnOldVersion) {
                this.error('w', "use 'declare namespace' instead of 'namespace'");
            }
            this.curToken = 78;
        }
        if (this.curToken == 78 || this.curToken == 77) {
            n = this.curToken;
            int n10 = this.skipSpace(this.nesting != 0);
            if (n10 >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n10)) {
                    this.getRawToken();
                    if (this.curToken != 65) {
                        return this.syntaxError("missing namespace prefix");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                    if (this.curToken != 402) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri in namespace declaration");
                    }
                    String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    Declaration declaration = this.pushNamespace(string, string2);
                    compilation.mainLambda.addDeclaration(declaration);
                    this.parseSeparator();
                    if (n == 77) {
                        compilation.getModule().setName(Compilation.mangleURI(string2));
                    }
                    SetExp setExp = new SetExp(declaration, declaration.getValue());
                    setExp.setDefining(true);
                    return setExp;
                }
            }
        }
        if (this.curToken == 84) {
            return this.syntaxError("'import schema' not implemented");
        }
        if (this.curToken == 73) {
            Object object2;
            this.getRawToken();
            String string = null;
            if (this.match("namespace")) {
                this.getRawToken();
                if (this.curToken != 65) {
                    return this.syntaxError("missing namespace prefix");
                }
                string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                this.getRawToken();
                if (this.curToken != 402) {
                    return this.syntaxError("missing '=' in namespace declaration");
                }
                this.getRawToken();
            }
            if (this.curToken != 34) {
                return this.syntaxError("missing uri in namespace declaration");
            }
            String string3 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
            if (string != null) {
                compilation.mainLambda.addDeclaration(this.pushNamespace(string, string3));
            }
            this.getRawToken();
            if (this.match("at")) {
                this.getRawToken();
                if (this.curToken != 34) {
                    return this.syntaxError("missing module location");
                }
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                this.parseSeparator();
            } else if (this.curToken != 59) {
                this.parseSeparator();
            }
            object2 = compilation.getModule();
            Vector vector = new Vector();
            ClassType classType = ClassType.make(Compilation.mangleURI(string3));
            require.importDefinitions(classType, string3, vector, (ScopeExp)object2, compilation);
            Expression[] expressionArray = new Expression[vector.size()];
            vector.toArray(expressionArray);
            return BeginExp.canonicalize(expressionArray);
        }
        if (this.curToken == 71) {
            Object object3 = this.parseURILiteral();
            if (object3 instanceof Expression) {
                return (Expression)object3;
            }
            String string = (String)object3;
            try {
                this.defaultCollator = NamedCollator.make(string);
            }
            catch (Exception exception) {
                this.defaultCollator = NamedCollator.codepointCollation;
                return this.declError("unknown collation '" + string + "'");
            }
            if (this.defaultCollator != null && !this.interactive) {
                return this.declError("duplicate default collation declaration");
            }
            this.parseSeparator();
            return QuoteExp.voidExp;
        }
        if (this.curToken == 69 || this.curToken == 79) {
            String string;
            n = this.curToken == 79 ? 1 : 0;
            this.getRawToken();
            if (this.match("namespace")) {
                this.getRawToken();
            } else {
                String string4 = "expected 'namespace' keyword";
                if (this.curToken != 34 && this.curToken != 402) {
                    return this.declError(string4);
                }
                if (warnOldVersion) {
                    this.error('w', string4);
                }
            }
            if (this.curToken == 402 || this.curToken == 76) {
                if (warnOldVersion) {
                    this.error('w', "extra '=' in default namespace declaration");
                }
                this.getRawToken();
            }
            if (this.curToken != 34) {
                return this.declError("missing namespace uri");
            }
            String string5 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            if (n != 0) {
                string = "functions$";
                this.functionNamespacePath = new Namespace[1];
                this.functionNamespacePath[0] = Namespace.getInstance(string5);
            } else {
                string = "elements$";
                this.defaultElementNamespace = string5;
            }
            Declaration declaration = this.pushNamespace(string, string5);
            compilation.mainLambda.addDeclaration(declaration);
            SetExp setExp = new SetExp(declaration, declaration.getValue());
            setExp.setDefining(true);
            this.parseSeparator();
            return setExp;
        }
        if (this.curToken == 83) {
            this.getRawToken();
            if (this.curToken == 402) {
                if (warnOldVersion) {
                    this.error('w', "obsolate '=' in xmlspace declaration");
                }
                this.getRawToken();
            }
            if (this.match("preserve")) {
                this.preserveBoundarySpace = true;
            } else if (this.match("skip")) {
                this.preserveBoundarySpace = false;
            } else {
                return this.syntaxError("xmlspace declaration must be preserve or strip");
            }
            this.parseSeparator();
            return QuoteExp.voidExp;
        }
        if (this.curToken == 66) {
            Object object4 = this.parseURILiteral();
            if (object4 instanceof Expression) {
                return (Expression)object4;
            }
            this.parseSeparator();
            this.baseURI = (String)object4;
            return QuoteExp.voidExp;
        }
        Expression expression = this.parseExprSequence(-1);
        if (this.curToken == 10) {
            this.unread(10);
        }
        expression.setFile(this.getName());
        expression.setLine(n3, n4);
        return expression;
    }

    public static Expression makeFunctionExp(String string, String string2) {
        return XQParser.makeFunctionExp(string, Compilation.mangleNameIfNeeded(string2), string2);
    }

    public static Expression makeFunctionExp(String string, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Procedure procedure = (Procedure)field.get(null);
            ClassType classType = ClassType.make(string);
            gnu.bytecode.Field field2 = classType.getDeclaredField(string2);
            Declaration declaration = new Declaration((Object)string3, field2);
            declaration.noteValue(new QuoteExp(procedure));
            declaration.setFlag(16384);
            return new ReferenceExp(string3, declaration);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    String tokenString() {
        switch (this.curToken) {
            case 65: 
            case 81: {
                return new String(this.tokenBuffer, 0, this.tokenBufferLength);
            }
            case -1: {
                return "<EOF>";
            }
        }
        return Integer.toString(this.curToken);
    }

    public void error(char c, String string) {
        this.error(c, this.port.getName(), this.curLine, this.curColumn, string);
    }

    public Expression declError(String string) throws IOException, SyntaxException {
        if (this.interactive) {
            return this.syntaxError(string);
        }
        this.error(string);
        while (this.curToken != 59 && this.curToken != -1) {
            this.getRawToken();
        }
        return new ErrorExp(string);
    }

    public Expression syntaxError(String string) throws IOException, SyntaxException {
        this.error(string);
        if (this.interactive) {
            int n;
            this.curToken = 0;
            this.curValue = null;
            this.nesting = 0;
            ((InPort)this.getPort()).readState = (char)10;
            while ((n = this.read()) >= 0) {
                if (n != 13 && n != 10) continue;
                this.unread(n);
                break;
            }
            throw new SyntaxException(this.getMessages());
        }
        return new ErrorExp(string);
    }

    static {
        XQParser.axisNames[0] = "ancestor";
        XQParser.axisNames[1] = "ancestor-or-self";
        XQParser.axisNames[2] = "attribute";
        XQParser.axisNames[3] = "child";
        XQParser.axisNames[4] = "descendant";
        XQParser.axisNames[5] = "descendant-or-self";
        XQParser.axisNames[6] = "following";
        XQParser.axisNames[7] = "following-sibling";
        XQParser.axisNames[8] = "namespace";
        XQParser.axisNames[9] = "parent";
        XQParser.axisNames[10] = "preceding";
        XQParser.axisNames[11] = "preceding-sibling";
        XQParser.axisNames[12] = "self";
        funcForwardFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "forwardFilter");
        funcReverseFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "reverseFilter");
        funcExprFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "exprFilter");
        documentNodeTest = new NodeType("document-node", 8);
        textNodeTest = new NodeType("text", 1);
        commentNodeTest = new NodeType("comment", 16);
        piNodeTest = new NodeType("processing-instruction", 32);
        anyNodeTest = new NodeType("node");
    }
}

