/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.Values;
import gnu.text.SourceLocator;

public class InlineCalls
extends ExpWalker {
    public static void inlineCalls(Expression expression, Compilation compilation) {
        InlineCalls inlineCalls = new InlineCalls(compilation);
        inlineCalls.walk(expression);
    }

    public InlineCalls(Compilation compilation) {
        this.setContext(compilation);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Expression expression = applyExp.func;
        if (expression instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            Expression expression2 = InlineCalls.inlineCall((LambdaExp)expression, applyExp.args, false);
            if (expression2 != null) {
                return this.walk(expression2);
            }
        }
        applyExp.func = expression = this.walk(expression);
        return expression.inline(applyExp, this, null, false);
    }

    public final Expression walkApplyOnly(ApplyExp applyExp) {
        return applyExp.func.inline(applyExp, this, null, true);
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration = referenceExp.getBinding();
        if (declaration != null && declaration.field == null && !declaration.getCanWrite()) {
            Expression expression = declaration.getValue();
            if (expression instanceof QuoteExp && expression != QuoteExp.undefined_exp) {
                return this.walkQuoteExp((QuoteExp)expression);
            }
            if (expression instanceof ReferenceExp && !declaration.isAlias()) {
                ReferenceExp referenceExp2 = (ReferenceExp)expression;
                Declaration declaration2 = referenceExp2.getBinding();
                Type type = declaration.getType();
                if (!(declaration2 == null || declaration2.getCanWrite() || type != null && type != Type.pointer_type && type != declaration2.getType() || referenceExp2.getDontDereference())) {
                    return this.walkReferenceExp(referenceExp2);
                }
            }
            if (!referenceExp.isProcedureName() && (declaration.flags & 0x100080) == 0x100080) {
                this.comp.error('e', "unimplemented: reference to method " + declaration.getName() + " as variable");
                this.comp.error('e', declaration, "here is the definition of ", "");
            }
        }
        return super.walkReferenceExp(referenceExp);
    }

    protected Expression walkIfExp(IfExp ifExp) {
        Expression expression;
        Declaration declaration;
        Expression expression2 = ifExp.test.walk(this);
        if (expression2 instanceof ReferenceExp && (declaration = ((ReferenceExp)expression2).getBinding()) != null && (expression = declaration.getValue()) instanceof QuoteExp && expression != QuoteExp.undefined_exp) {
            expression2 = expression;
        }
        ifExp.test = expression2;
        if (this.exitValue == null) {
            ifExp.then_clause = this.walk(ifExp.then_clause);
        }
        if (this.exitValue == null && ifExp.else_clause != null) {
            ifExp.else_clause = this.walk(ifExp.else_clause);
        }
        if (expression2 instanceof QuoteExp) {
            boolean bl = this.comp.getLanguage().isTrue(((QuoteExp)expression2).getValue());
            return ifExp.select(bl);
        }
        if (expression2.getType().isVoid()) {
            boolean bl = this.comp.getLanguage().isTrue(Values.empty);
            this.comp.error('w', "void-valued condition is always " + bl);
            return new BeginExp(expression2, ifExp.select(bl));
        }
        return ifExp;
    }

    protected Expression walkLetExp(LetExp letExp) {
        ReferenceExp referenceExp;
        Expression expression;
        Expression expression2;
        SourceLocator sourceLocator;
        Declaration declaration = letExp.firstDecl();
        int n = letExp.inits.length;
        int n2 = 0;
        while (n2 < n) {
            sourceLocator = letExp.inits[n2];
            letExp.inits[n2] = expression2 = this.walk((Expression)sourceLocator);
            expression = declaration.value;
            if (expression == sourceLocator) {
                declaration.value = expression = expression2;
                if (!declaration.getFlag(8192)) {
                    declaration.setType(expression.getType());
                }
            }
            ++n2;
            declaration = declaration.nextDecl();
        }
        if (this.exitValue == null) {
            letExp.body = this.walk(letExp.body);
        }
        if (letExp.body instanceof ReferenceExp && (sourceLocator = (referenceExp = (ReferenceExp)letExp.body).getBinding()) != null && ((Declaration)sourceLocator).context == letExp && !referenceExp.getDontDereference() && n == 1) {
            expression2 = letExp.inits[0];
            expression = ((Declaration)sourceLocator).getTypeExp();
            if (expression != QuoteExp.classObjectExp) {
                expression2 = this.walkApplyOnly(Convert.makeCoercion(expression2, expression));
            }
            return expression2;
        }
        return letExp;
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        Declaration declaration = lambdaExp.firstDecl();
        if (declaration != null && declaration.isThisParameter() && !lambdaExp.isClassMethod() && declaration.getType() == null) {
            declaration.setType(this.comp.mainClass);
        }
        return this.walkScopeExp(lambdaExp);
    }

    protected Expression walkSetExp(SetExp setExp) {
        super.walkSetExp(setExp);
        Declaration declaration = setExp.getBinding();
        if (!setExp.isDefining() && declaration != null && (declaration.flags & 0x100080) == 0x100080) {
            this.comp.error('e', "can't assign to method " + declaration.getName(), setExp);
        }
        if (declaration != null && declaration.getFlag(8192) && Invoke.checkKnownClass(declaration.getType(), this.comp) < 0) {
            declaration.setType(Type.errorType);
        }
        return setExp;
    }

    public static Expression inlineCall(LambdaExp lambdaExp, Expression[] expressionArray, boolean bl) {
        boolean bl2;
        if (lambdaExp.keywords != null || lambdaExp.nameDecl != null && !bl) {
            return null;
        }
        boolean bl3 = bl2 = lambdaExp.max_args < 0;
        if (lambdaExp.min_args == lambdaExp.max_args && lambdaExp.min_args == expressionArray.length || bl2 && lambdaExp.min_args == 0) {
            Expression[] expressionArray2;
            Expression[] expressionArray3;
            IdentityHashTable<SourceLocator, Declaration> identityHashTable;
            SourceLocator sourceLocator = null;
            int n = 0;
            if (bl) {
                identityHashTable = new IdentityHashTable<SourceLocator, Declaration>();
                expressionArray3 = Expression.deepCopy(expressionArray, identityHashTable);
                if (expressionArray3 == null && expressionArray != null) {
                    return null;
                }
            } else {
                identityHashTable = null;
                expressionArray3 = expressionArray;
            }
            if (bl2) {
                expressionArray2 = new Expression[expressionArray.length + 1];
                expressionArray2[0] = QuoteExp.getInstance(lambdaExp.firstDecl().type);
                System.arraycopy(expressionArray, 0, expressionArray2, 1, expressionArray.length);
                expressionArray3 = new Expression[]{new ApplyExp(Invoke.make, expressionArray2)};
            }
            expressionArray2 = new LetExp(expressionArray3);
            SourceLocator sourceLocator2 = lambdaExp.firstDecl();
            while (sourceLocator2 != null) {
                Declaration declaration = ((Declaration)sourceLocator2).nextDecl();
                if (bl) {
                    Declaration declaration2 = expressionArray2.addDeclaration(((Declaration)sourceLocator2).symbol, ((Declaration)sourceLocator2).type);
                    if (((Declaration)sourceLocator2).typeExp != null) {
                        declaration2.typeExp = Expression.deepCopy(((Declaration)sourceLocator2).typeExp);
                        if (declaration2.typeExp == null) {
                            return null;
                        }
                    }
                    identityHashTable.put(sourceLocator2, declaration2);
                } else {
                    lambdaExp.remove((Declaration)sourceLocator, (Declaration)sourceLocator2);
                    expressionArray2.add((Declaration)sourceLocator, (Declaration)sourceLocator2);
                }
                if (!bl2 && !((Declaration)sourceLocator2).getCanWrite()) {
                    ((Declaration)sourceLocator2).setValue(expressionArray3[n]);
                }
                sourceLocator = sourceLocator2;
                sourceLocator2 = declaration;
                ++n;
            }
            sourceLocator2 = lambdaExp.body;
            if (bl && (sourceLocator2 = Expression.deepCopy((Expression)sourceLocator2, identityHashTable)) == null && lambdaExp.body != null) {
                return null;
            }
            expressionArray2.body = sourceLocator2;
            return expressionArray2;
        }
        return null;
    }
}

