/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XDataType;
import gnu.mapping.Procedure1or2;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.Duration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;
import gnu.xml.TextUtils;
import gnu.xquery.util.TimeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class ArithOp
extends Procedure1or2
implements CanInline,
Inlineable {
    char op;
    static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final ArithOp add = new ArithOp("+", '+', 2);
    public static final ArithOp sub = new ArithOp("-", '-', 2);
    public static final ArithOp mul = new ArithOp("*", '*', 2);
    public static final ArithOp div = new ArithOp("div", 'd', 2);
    public static final ArithOp idiv = new ArithOp("idiv", 'i', 2);
    public static final ArithOp mod = new ArithOp("mod", 'm', 2);
    public static final ArithOp plus = new ArithOp("+", 'P', 1);
    public static final ArithOp minus = new ArithOp("-", 'M', 1);

    ArithOp(String string, char c, int n) {
        super(string);
        this.op = c;
    }

    public Object apply1(Object object2) throws Throwable {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            object2 = XDataType.doubleType.valueOf(TextUtils.stringValue(object2));
        }
        switch (this.op) {
            case 'P': {
                return AddOp.apply2(1, IntNum.zero(), object2);
            }
            case 'M': {
                int n = Arithmetic.classifyValue(object2);
                switch (n) {
                    case 7: {
                        return XDataType.makeFloat(-Arithmetic.asFloat(object2));
                    }
                    case 8: {
                        return XDataType.makeDouble(-Arithmetic.asDouble(object2));
                    }
                }
                if (object2 instanceof Numeric) {
                    return ((Numeric)object2).neg();
                }
                return AddOp.apply2(-1, IntNum.zero(), object2);
            }
        }
        throw new UnsupportedOperationException(this.getName());
    }

    public static BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128);
    }

    public Object apply2(Object object2, Object object3) throws Throwable {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (object3 == Values.empty || object3 == null) {
            return object3;
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            object2 = XDataType.doubleType.valueOf(TextUtils.stringValue(object2));
        }
        if (object3 instanceof KNode || object3 instanceof UntypedAtomic) {
            object3 = XDataType.doubleType.valueOf(TextUtils.stringValue(object3));
        }
        switch (this.op) {
            case '+': {
                return AddOp.apply2(1, object2, object3);
            }
            case '-': {
                return AddOp.apply2(-1, object2, object3);
            }
            case '*': {
                return MultiplyOp.$St.apply2(object2, object3);
            }
        }
        int n = Arithmetic.classifyValue(object2);
        int n2 = Arithmetic.classifyValue(object3);
        int n3 = n < n2 ? n2 : n;
        switch (this.op) {
            case 'd': {
                if (n < 0 || n2 < 0) break;
                if (n3 <= 6) {
                    BigDecimal bigDecimal = (BigDecimal)XDataType.decimalType.cast(object2);
                    BigDecimal bigDecimal2 = (BigDecimal)XDataType.decimalType.cast(object3);
                    return ArithOp.div(bigDecimal, bigDecimal2);
                }
                if (n3 == 7) {
                    return new Float(((Number)object2).floatValue() / ((Number)object3).floatValue());
                }
                if (n3 == 8) {
                    return new Double(((Number)object2).doubleValue() / ((Number)object3).doubleValue());
                }
                if (object2 instanceof Duration && object3 instanceof Duration) {
                    Duration duration = (Duration)object2;
                    Duration duration2 = (Duration)object3;
                    if (duration.unit() == Unit.second && duration2.unit() == Unit.second) {
                        long l = duration.getTotalSeconds();
                        long l2 = duration2.getTotalSeconds();
                        int n4 = duration.getNanoSecondsOnly();
                        int n5 = duration2.getNanoSecondsOnly();
                        BigDecimal bigDecimal = TimeUtils.secondsBigDecimalFromDuration(l, n4);
                        BigDecimal bigDecimal3 = TimeUtils.secondsBigDecimalFromDuration(l2, n5);
                        return ArithOp.div(bigDecimal, bigDecimal3);
                    }
                    if (duration.unit() == Unit.month && duration2.unit() == Unit.month) {
                        BigDecimal bigDecimal = BigDecimal.valueOf(duration.getTotalMonths());
                        BigDecimal bigDecimal4 = BigDecimal.valueOf(duration2.getTotalMonths());
                        return ArithOp.div(bigDecimal, bigDecimal4);
                    }
                    throw new ArithmeticException("divide of incompatible durations");
                }
                if (n3 >= 0) {
                    return Arithmetic.asNumeric(object2).div(Arithmetic.asNumeric(object3));
                }
            }
            case 'i': {
                if (n < 0 || n2 < 0) break;
                if (n3 <= 4) {
                    IntNum intNum = Arithmetic.asIntNum(object2);
                    IntNum intNum2 = Arithmetic.asIntNum(object3);
                    return IntNum.quotient(intNum, intNum2);
                }
                if (n3 <= 6) {
                    BigDecimal bigDecimal = (BigDecimal)XDataType.decimalType.cast(object2);
                    BigDecimal bigDecimal5 = (BigDecimal)XDataType.decimalType.cast(object3);
                    return Arithmetic.asIntNum(bigDecimal.divide(bigDecimal5, 0, 1));
                }
                if (n3 <= 7) {
                    float f = ((Number)object2).floatValue() / ((Number)object3).floatValue();
                    return RealNum.toExactInt(f, 3);
                }
                double d = ((Number)object2).doubleValue() / ((Number)object3).doubleValue();
                return RealNum.toExactInt(d, 3);
            }
            case 'm': {
                if (n < 0 || n2 < 0) break;
                if (n3 <= 4) {
                    IntNum intNum = Arithmetic.asIntNum(object2);
                    IntNum intNum3 = Arithmetic.asIntNum(object3);
                    return IntNum.remainder(intNum, intNum3);
                }
                if (n3 <= 6) {
                    return sub.apply2(object2, mul.apply2(idiv.apply2(object2, object3), object3));
                }
                if (n3 <= 7) {
                    float f = Arithmetic.asFloat(object2);
                    float f2 = Arithmetic.asFloat(object3);
                    return XDataType.makeFloat(f % f2);
                }
                if (n3 > 9) break;
                double d = Arithmetic.asDouble(object2);
                double d2 = Arithmetic.asDouble(object3);
                double d3 = d % d2;
                if (n3 == 9) {
                    return DFloNum.make(d3);
                }
                return XDataType.makeDouble(d3);
            }
        }
        throw new UnsupportedOperationException(this.getName());
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }
}

