/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PrintNested {
    protected PrintWriter out;
    protected boolean isDomTerm;
    public static final int NL_LINEAR = 116;
    public static final int NL_FILL = 115;
    public static final int NL_MISER = 117;
    public static final int NL_MANDATORY = 118;
    public boolean prefixButtons = true;
    public String hideButtonChar = "\u25bc";
    public String showButtonChar = "\u25b6";
    public String boxHorizonal = "\u2500";
    public String boxVertical = "\u2502";
    public String boxVerticalLast = "\u250a";
    public String boxChild = "\u251c";
    public String boxChildLast = "\u2514";
    public String nobreakSeparator = " " + this.boxChild;
    public int indentStep = 2;
    private StringBuilder indentation = new StringBuilder();
    private Stack<Integer> indentationLengthStack = new Stack();

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out);
        PrintNested printNested = new PrintNested(printWriter);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("key1", 98789767);
        linkedHashMap.put("key2", "abcdefghijklmnopqrstuvwxyz");
        Tree tree = printNested.makeTree("info: GET /foo/endpoint", "info: user <user ID> valid auth", linkedHashMap, Arrays.asList(3, 4, printNested.makeTree("info1 - request to service A", "info1a - request took 1 seconds", "info1b - request took 1 seconds"), "info2", Arrays.asList(11099011, Arrays.asList(13008821, 13008822), 12099012)), printNested.makeTree("info3 - request to service B", "debug - opening new connection\nnext line", "debug - success, result = ...", "info - request took 1 seconds"), "info - http request took 3 seconds abcdefghi", "info - preparing result took 1 seconds");
        printNested.printObject(tree, false);
        printWriter.println();
        printWriter.flush();
    }

    public PrintNested(PrintWriter printWriter) {
        this.out = printWriter;
        this.isDomTerm = System.console() != null && System.getenv("DOMTERM") != null;
    }

    public Tree makeTree(Object object, Object ... objectArray) {
        SimpleTree simpleTree = new SimpleTree();
        simpleTree.header = object;
        simpleTree.children = Arrays.asList(objectArray);
        return simpleTree;
    }

    public boolean isTree(Object object) {
        return object instanceof Tree;
    }

    public boolean isList(Object object) {
        return object instanceof List;
    }

    public void startLogicalBlock() {
        if (this.isDomTerm) {
            this.out.print("\u001b]110\u0007");
        } else {
            this.indentationLengthStack.add(this.indentation.length());
        }
    }

    public void endLogicalBlock() {
        if (this.isDomTerm) {
            this.out.print("\u001b]111\u0007");
        } else {
            this.indentation.setLength(this.indentationLengthStack.pop());
        }
    }

    public void printSimple(Object object) {
        this.out.print(object == null ? "(null)" : object.toString());
    }

    public void newline(int n) {
        this.out.print("\u001b]" + n + "\u0007");
    }

    public void printObject(Object object, boolean bl) {
        if (this.isList(object) || object instanceof Map) {
            if (this.prefixButtons && !bl) {
                this.printHideButton();
            }
            if (this.isList(object)) {
                this.printList(object);
            } else {
                this.printMap(object);
            }
        } else if (this.isTree(object)) {
            if (this.prefixButtons && !bl) {
                this.printHideButton();
            }
            this.printTree((Tree)object);
        } else {
            this.printSimple(object);
        }
    }

    public void printElementSeparator(String string, boolean bl) {
        String string2 = (bl ? this.boxChildLast : this.boxChild) + PrintNested.repeat(this.boxHorizonal, this.indentStep - 1);
        if (this.isDomTerm) {
            int n = 116;
            this.out.print("\u001b]" + n + ";\"\",\"" + string2 + "\"," + string + "\u0007");
        } else {
            this.out.print("\n" + this.indentation + string2);
        }
    }

    public void printHideButton() {
        if (this.isDomTerm) {
            this.out.print("\u001b[16u" + this.hideButtonChar + this.showButtonChar + "\u001b[17u");
        }
    }

    protected void printIndentation(boolean bl) {
        String string = (bl ? this.boxVerticalLast : this.boxVertical) + PrintNested.repeat(" ", this.indentStep - 1);
        if (this.isDomTerm) {
            this.out.print("\u001b]112;" + -this.indentStep + "\u0007");
            this.out.print("\u001b]114;\"" + string + "\"\u0007");
        } else {
            this.indentation.append(string);
        }
    }

    public void printTree(Tree tree) {
        this.out.print(tree.getHeader());
        if (!this.prefixButtons) {
            this.printHideButton();
        }
        Iterator iterator = tree.getChildren().iterator();
        boolean bl = true;
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            Object t = iterator.next();
            bl2 = iterator.hasNext();
            this.printElementSeparator("\"" + this.boxChild + "\"", !bl2);
            bl = false;
            this.startLogicalBlock();
            this.printIndentation(!bl2);
            this.printObject(t, false);
            this.endLogicalBlock();
        }
    }

    public void printListHeader(List list) {
        this.out.print("array(" + list.size() + ")[");
    }

    public void printListTail() {
        this.out.print("]");
    }

    public void printMapHeader(Map map) {
        this.out.print("{");
    }

    public void printMapTail() {
        this.out.print("}");
    }

    protected void printKey(Object object) {
        if (object != null) {
            this.out.print(object.toString() + ":");
            if (this.isDomTerm) {
                this.out.print("\u001b]115;\"\",\"\",\" \"\u0007");
            } else {
                this.out.print(" ");
            }
        }
    }

    protected void printElement(Object object, Object object2, boolean bl, boolean bl2) {
        this.printElementSeparator(bl ? "\"\"" : "\";\"", bl2);
        this.startLogicalBlock();
        this.printIndentation(bl2);
        boolean bl3 = this.isList(object2);
        boolean bl4 = this.isTree(object2);
        boolean bl5 = object2 instanceof Map;
        if (this.prefixButtons) {
            if (bl3 || bl4 || bl5) {
                this.printHideButton();
            } else if (this.isDomTerm) {
                this.out.print(" ");
            }
        }
        this.printKey(object);
        this.printObject(object2, true);
        this.endLogicalBlock();
    }

    public void printList(Object object) {
        List list = (List)object;
        this.printListHeader(list);
        if (!this.prefixButtons) {
            this.printHideButton();
        }
        Iterator iterator = list.iterator();
        boolean bl = iterator.hasNext();
        boolean bl2 = true;
        int n = 0;
        while (bl) {
            Object e = iterator.next();
            bl = iterator.hasNext();
            this.printElement(n, e, bl2, !bl);
            bl2 = false;
            ++n;
        }
        this.printListTail();
    }

    public void printMap(Object object) {
        Map map = (Map)object;
        this.printMapHeader(map);
        if (!this.prefixButtons) {
            this.printHideButton();
        }
        Iterator iterator = map.entrySet().iterator();
        boolean bl = iterator.hasNext();
        boolean bl2 = true;
        int n = 0;
        while (bl) {
            Map.Entry entry = iterator.next();
            bl = iterator.hasNext();
            this.printElement(entry.getKey(), entry.getValue(), bl2, !bl);
            bl2 = false;
            ++n;
        }
        this.printMapTail();
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (--n >= 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static class SimpleTree
    implements Tree {
        Object header;
        List children;

        @Override
        public Object getHeader() {
            return this.header;
        }

        @Override
        public Iterable getChildren() {
            return this.children;
        }
    }

    public static interface Tree {
        public Object getHeader();

        public Iterable getChildren();
    }
}

