/* yourcode.h

   originally written by Frederic Bois
   
   Copyright (c) 1993-2008 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301, USA.

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

   Header file for the "yourcode" file, containing customizable routines.
*/

#ifndef _YOURCODE_H_
#define _YOURCODE_H_

/* ----------------------------------------------------------------------------
   Inclusions
*/

#include "sim.h"


/* ----------------------------------------------------------------------------
   Typedefs
*/

typedef struct tagMCPREDOUT {
  long nbrdy;    /* number of kinetic ys */
  double *pred;  /* pointer to the data */
  int passflag;  /* typically a pass/fail flag */
} MCPREDOUT, *PMCPREDOUT;


/* ----------------------------------------------------------------------------
   Prototypes  */

void DoStep_by_Step (void /* double t, long *neq, double *y */);
void OutspecToLinearArray (PANALYSIS panal, PMCPREDOUT pMCPredOut);
void TransformPred (PANALYSIS, PMCPREDOUT);
double Definite_Integral (double (*Function)(double), double dFrom, double dTo);
void Interpolate_Poly (double rgdX[], double rgdY[], int n, double x, 
                       double *pdY, double *pdDY);
double Trapezes (double (*Function)(double x), double dFrom, double dTo, 
                 int nSteps);

#endif /* _YOURCODE_H_ */

/* End */

