/* old score extrapolator widget
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

import java.applet.*;
import java.awt.*;
import java.lang.*;
import java.util.*;
import java.net.*;
import java.awt.event.*;

public class TScore extends Applet implements Runnable {
  public float   W[];
  public int     Entry_cnt,  Exam_cnt;
  public float   S[], F[];
  public int     X[], C[], R[];
  public float   SF_ratio[],  SF_percent[];
  public float   Sum_ratio[], Sum_percent[];
  public float   Exam_ratio[], Raw_exam_ratio[], Raw_epc_ratio[];
  public float   Term_score;
     
  ExpPanel     []  HQpanel;
  ExmPanel     []  EXpanel;
  Label            TitleL;
  Label            EqL;

public void init() {
   String      p;
   int         fs;
   int         idx;

   C       = new int[2];
   R       = new int[2];
   W       = new float[5];

//  final exam set number   
   p=getParameter("FS"); 
   fs = (p==null)?1:Integer.valueOf(p).intValue();
// how many entries 
   Entry_cnt= ((fs == 0)? 2 : 1 +  2*fs); 
// how many exams
   Exam_cnt = (Entry_cnt - 3 ) / 2; 

   S      = new float[Entry_cnt];
   F      = new float[Entry_cnt];
   X      = new int[Entry_cnt];
   SF_ratio  = new float[Entry_cnt];
   SF_percent= new float[Entry_cnt];
   Sum_ratio = new float[Entry_cnt];
   Sum_percent = new float[Entry_cnt];
   Raw_exam_ratio = new float[Exam_cnt];
   Raw_epc_ratio  = new float[Exam_cnt];
   Exam_ratio = new float[Exam_cnt];

   p=getParameter("HW_W");
   W[0] =(p==null)?1:Float.valueOf(p).floatValue(); 
   p=getParameter("QZ_W");
   W[1] =(p==null)?1:Float.valueOf(p).floatValue();
   p=getParameter("EX_W");
   W[2] =(p==null)?1:Float.valueOf(p).floatValue();
   p=getParameter("FE_W");
   W[3] =(p==null)?1:Float.valueOf(p).floatValue();
   p=getParameter("PC_W");
   W[4] =(p==null)?1:Float.valueOf(p).floatValue();
   
   p=getParameter("HW_C");
   C[0] =(p==null)?1:Integer.valueOf(p).intValue();
   p=getParameter("HW_R");
   R[0] =(p==null)?1:Integer.valueOf(p).intValue();
   p=getParameter("QZ_C");
   C[1] =(p==null)?1:Integer.valueOf(p).intValue();
   p=getParameter("QZ_R");
   R[1] =(p==null)?1:Integer.valueOf(p).intValue();

   for(idx=0;idx<Entry_cnt;idx++) {
     p=getParameter("X"+idx);
     X[idx]=(p==null)?1:Integer.valueOf(p).intValue();
     if( (idx>1) && (X[idx]==1) ) {  // midterm exam, final extrapolated
       SF_ratio[idx]  = (float)0.0;
       SF_percent[idx]= (float)0.0;
       if( idx == (Entry_cnt - 1) ) {  // final exam extrapolated, from hw
         Sum_ratio[idx] = SF_ratio[0]; 
	 Sum_percent[idx] = SF_percent[0];
       } 
     } else {
 // homework, quiz extrapolated or not;exam,final not extrapolated 
       p=getParameter("S"+idx);
       S[idx]=(p==null)?1:Float.valueOf(p).floatValue();
       p=getParameter("F"+idx);
       F[idx] =(p==null)?1:Float.valueOf(p).floatValue();
       if ((float)F[idx] < 0.00000001) {
	   SF_ratio[idx] = (float) 0.0;
       } else {
	   SF_ratio[idx] = (float) ((float)S[idx] / (float)F[idx]);
       }
       int tmp_i = (int) (10000 * SF_ratio[idx] );
       SF_percent[idx]= (float)tmp_i / (float)100.0;
       if( idx == (Entry_cnt - 1) ) {         // final exam
         Sum_ratio[idx]   = SF_ratio[idx];
	 Sum_percent[idx] = SF_percent[idx];
       }
     }
   }
   Sum_ratio[0] = (float)(S[0] + ((float)R[0]*F[0]*SF_ratio[0]/(float)C[0])) / (float)(F[0]*(1.0 + (float)R[0]/(float)C[0]));
     int tmp_i = (int)(10000 * Sum_ratio[0]);
     Sum_percent[0] =  (float)tmp_i / (float)100.0;
     Sum_ratio[0]   = Sum_percent[0] / (float)100.0;
     Sum_ratio[1] = (float)(S[1] + (R[1]*F[1]*SF_ratio[1]/C[1])) / (float)(F[1]*(1.0 + R[1]/C[1]));
     tmp_i = (int)(10000 * Sum_ratio[1]);
     Sum_percent[1] =  (float)tmp_i / (float)100.0;
     Sum_ratio[1]   =  Sum_percent[1] / (float)100.0;


   // if exam 1 is not given, use homework as default to extrapolate 
   //    if epc 1 is not given, use exam 1 as epc 1
   // if exam 2 is not given, use exam 1 to extrapolate
   // if exam 3 is not given, use exam 2 to extrapolate
   // I am lying, I only use the homework score

   float exam_sum = (float)0.0;
   for(idx=0;idx<Exam_cnt;idx++) {
     if( X[(idx+1)*2] == 1 ) {
//      taken from homework 
        Raw_exam_ratio[idx] = SF_ratio[0]; 
     } else {
        Raw_exam_ratio[idx] = SF_ratio[(idx+1)*2];
     }
     if( X[(idx+1)*2 + 1] == 1 ) {
        Raw_epc_ratio[idx] = Raw_exam_ratio[idx];
     } else {
        Raw_epc_ratio[idx] = SF_ratio[(idx+1)*2 + 1];
     }
     
     if( Raw_epc_ratio[idx] > Raw_exam_ratio[idx] ) {
         Exam_ratio[idx] = Raw_exam_ratio[idx] + W[4]*( Raw_epc_ratio[idx] - Raw_exam_ratio[idx] ) ;
     } else {
         Exam_ratio[idx] = Raw_exam_ratio[idx];
     }
     //System.out.print("idx="+idx+":Exam_ratio="+Exam_ratio[idx]+"\n");
     Sum_ratio[2*(idx+1)] = Exam_ratio[idx];
     tmp_i = (int)(10000 * Exam_ratio[idx] );
     Sum_percent[2*(idx+1)] = (float)tmp_i / (float)100.0;
     Sum_ratio[2*(idx+1)]   = Sum_percent[2*(idx+1)] / (float)100.0;
     exam_sum += Exam_ratio[idx];
   }
   exam_sum = (float)exam_sum / (float)Exam_cnt;

   Term_score = Sum_ratio[0] * W[0] + Sum_ratio[1] * W[1] + exam_sum * W[2] + Sum_ratio[Entry_cnt - 1] * W[3];

   tmp_i = (int)(10000 * Term_score);
   Term_score = (float)tmp_i / (float)100.0;


//    call to setup User Interface

   initGUI();

    }
public void initGUI() {
       int     row_cnt = Exam_cnt + 4;
       int     idx;
       String  [] title = {"Homework", "Quizz" }; 
       HQpanel = new ExpPanel[2];
       EXpanel = new ExmPanel[Exam_cnt+2];

       setLayout(new GridLayout(row_cnt,0,4,4));

       String t_str = "Term Score Extrapolation Applet";
       TitleL    = new Label(t_str, Label.CENTER);
       add(TitleL);

       for(idx = 0; idx < 2; idx++) {
         HQpanel[idx] = new ExpPanel(this,title[idx],X[idx],
                               S[idx],F[idx],C[idx],R[idx]);
         add(HQpanel[idx]);
       }
       // Midterm Exam
       for(idx =0; idx < Exam_cnt; idx++) {
         EXpanel[idx] = new ExmPanel(this,idx+1,X[2*(idx+1)],1,X[2*idx+3],
             S[2*(idx+1)],F[2*(idx+1)],W[4],S[2*idx+3],F[2*idx+3],Sum_ratio[2*(idx+1)]);
         add(EXpanel[idx]);
       }
       // Final Exam
       EXpanel[Exam_cnt] = new ExmPanel(this,0,X[Entry_cnt-1],0,0,
             S[Entry_cnt-1],F[Entry_cnt-1],W[3],S[Entry_cnt-1],F[Entry_cnt-1],Sum_ratio[Entry_cnt-1]);
       add(EXpanel[Exam_cnt]);

       String eq_str = "Term score=" + Sum_percent[0] + "*" + W[0] ;
       eq_str = eq_str + "+" + Sum_percent[1] + "*" + W[1] ;
       eq_str = eq_str + "+" + "(" ; 
       for(idx =1;idx<=Exam_cnt;idx++) {
          if(idx>1) {
             eq_str = eq_str + "+ ";
           }
           eq_str = eq_str + Sum_percent[2*idx] ;
       } 
       eq_str = eq_str + ") *" + W[2] + "/" + Exam_cnt + "+";
       eq_str = eq_str + Sum_percent[2*idx] + "*" + W[3] + " = ";
       eq_str = eq_str + " " + Term_score + "%";
       // EqL    = new Label(eq_str, Label.LEFT);
       // add(EqL);

  }
public void recalcTermScore() {
       float  score[];
       int    idx;
       float  term_summ, exam_summ;
 
       score = new float[Exam_cnt+3];
       term_summ = (float)0.0;
       exam_summ = (float)0.0;
       for(idx=0;idx<2;idx++) {
         score[idx] = HQpanel[idx].getSubTotal();
         term_summ = term_summ + score[idx] * W[idx];
       }
       for(idx =0; idx < Exam_cnt; idx++) {
         score[idx+2] = EXpanel[idx].getSubTotal();
         exam_summ = exam_summ + score[idx+2];
       }
       score[Exam_cnt+2] = EXpanel[Exam_cnt].getSubTotal();
       exam_summ = exam_summ * W[2] / Exam_cnt;
       term_summ = term_summ + exam_summ + score[Exam_cnt+2] * W[3];
       int  tmp_i = (int) ((float)100.0*term_summ);
       term_summ  = (float)(tmp_i / (float)100.0);
       String eq_str = "Term score=" + score[0] + "*" + W[0] ;
       eq_str = eq_str + "+" + score[1] + "*" + W[1] ;
       eq_str = eq_str + "+" + "(" ; 
       for(idx=0;idx<Exam_cnt;idx++) {
          if(idx>0) {
             eq_str = eq_str + "+ ";
           }
           eq_str = eq_str + score[idx+2] ;
        } 
        eq_str = eq_str + ") *" + W[2] + "/" + Exam_cnt + "+";
        eq_str = eq_str + score[Exam_cnt+2] + "*" + W[3] + " = ";
        eq_str = eq_str + " " + term_summ + "  %";
        // TitleL.setText("TTT");
        TitleL.setText(eq_str);
  }
public void paint(Graphics g) {
        Dimension d = getSize();
        g.drawRect(0,0, d.width - 1, d.height - 1);
  }
public void run()   {  }
public void start() {
        recalcTermScore();
  }
public void stop()  {  }

}
class ExpPanel extends Panel
                     implements ActionListener,
                                 AdjustmentListener {
    TScore     controller;
    TextField  exT;
    Scrollbar  sB;
    Label      sumL;
    int        max = 100;
    int        block = 1;
    float      ff,ss;
    int        rr,cc;

    ExpPanel(TScore u,String t,
             int x,float a,float b,int m,int n) {
        GridBagConstraints   c = new GridBagConstraints();
        GridBagLayout        gridbag = new GridBagLayout();
        setLayout(gridbag);
        int tmp_i;

        controller = u;
        ss = a; ff = b; cc = m; rr = n;
        float sf_ratio =  (float)ss / (float)ff;
        tmp_i = (int)(10000 * sf_ratio);
        float sf_percent =  (float)tmp_i / (float)100.0;
        float sum_ratio = (float)(ss + ((float)rr*ff*sf_ratio/(float)(cc+rr))) / (float)(ff*(1.0 + (float)rr/(float)(cc+rr)));
	//System.out.print("ss ="+ss+":rr="+rr+":ff="+ff+":sf_ratio="+sf_ratio+":cc="+cc+":sum_ratio="+sum_ratio+"\n");
        tmp_i = (int)(10000 * sum_ratio);
        float sum_percent =  (float)tmp_i / (float)100.0;

        String cs = " " + ss + "/"  + ff; 
        cs = cs + " = " + sf_percent + "%";
        String r = "remaining " + rr + " sets at (%) ";
        String s = " " + sum_percent + "%";

        //Set up default layout constraints.
        c.fill = GridBagConstraints.NONE;

        Label tL = new Label(t, Label.LEFT);
        // c.gridwidth = GridBagConstraints.REMAINDER; //It ends a row.
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(tL, c);
        add(tL);
        
        Label cL = new Label(cs, Label.CENTER);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(cL, c);
        add(cL);

        Label sL = new Label("subtotal=", Label.RIGHT);
        c.gridwidth = 1;
        c.gridx = 3;
        c.gridy = 0;
        gridbag.setConstraints(sL, c);
        add(sL);

        sumL = new Label(s, Label.RIGHT);
        c.gridwidth = GridBagConstraints.REMAINDER; //It ends a row.
        c.gridx = 4;
        c.gridy = 0;
        gridbag.setConstraints(sumL, c);
        add(sumL);
        if(x==1) { 
          Label rL = new Label(r, Label.RIGHT);
          c.gridwidth = 2;
          c.gridx = 0;
          c.gridy = 1;
          gridbag.setConstraints(rL, c);
          add(rL);

          exT = new TextField("0", 3);
          c.anchor = GridBagConstraints.EAST;
          c.gridwidth = 1; //The default value.
          c.gridx = 2;
          c.gridy = 1;
          gridbag.setConstraints(exT, c);
          add(exT);
          exT.addActionListener(this);
          c.anchor = GridBagConstraints.CENTER;  // default

        //Add the slider.  It's horizontal, and it has the maximum
        //value specified by the instance variable max.  Its initial
        //and minimum values are the default (0).  A click increments
        //the value by block units.
          sB = new Scrollbar(Scrollbar.HORIZONTAL);
          sB.setMaximum(max + 10);
          sB.setBlockIncrement(block);
          // c.gridwidth = GridBagConstraints.REMAINDER; //It ends a row.
          c.fill = GridBagConstraints.HORIZONTAL;
          c.gridwidth = 2;
          c.gridx = 3;
          c.gridy = 1;
          gridbag.setConstraints(sB, c);
          add(sB);
          sB.addAdjustmentListener(this);
          exT.setText(String.valueOf(sf_percent));
          sB.setValue((int)sf_percent);
        }

    }
    // Draws a box around this panel. 
    public void paint(Graphics g) {
        Dimension d = getSize();
        g.drawRect(0,0, d.width - 1, d.height - 1);
    }
    public Insets getInsets() {
        return new Insets(5,5,5,8);
    }
    float  getSubTotal() {
        String s_str = sumL.getText().replace('%','\0').trim();
        float  s_real = Float.valueOf(s_str).floatValue();
        return (s_real);
    }
    double getValue() {
        double f;
        try {
            f = (double)Double.valueOf(exT.getText()).doubleValue();
	    if (f > max) {f=max;}
        } catch (java.lang.NumberFormatException e) {
            f = 0.0;
        }
        return f;
    }
    // entered into exT
    public void actionPerformed(ActionEvent e) {
        int tf = (int) getValue();
        if (tf > max)
            tf = max;
        if (tf < 0)
            tf = 0;
        sB.setValue(tf);
        exT.setText(String.valueOf((int)tf));
        recalcSumm(tf);
    }    
    //  slider sB changed
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Scrollbar source = (Scrollbar)e.getSource();
           int   my_i =  (int)source.getValue();
           exT.setText(String.valueOf(e.getValue()));
           recalcSumm(my_i);
    }
    void  recalcSumm(int tf) {
        float my_r = (float) tf / (float)100.0;
        int  tmp_i= (int)(10000*(ss+((float)rr*ff*my_r/(cc+rr)))/(float)(ff*(1.0+(float)rr/(cc+rr))));
	//System.out.print("ss ="+ss+":rr="+rr+":ff="+ff+":my_r="+my_r+":cc="+cc+":tmp_i="+((float)tmp_i/10000.0)+"\n");
        float sum  = (float)tmp_i / (float)100.0;
        sumL.setText(sum + "%");
        controller.recalcTermScore();
    }
    // Set the values in the slider and text field. 
    void setValue(double f) {
        setSliderValue(f);
        exT.setText(String.valueOf((float)f));
    }
    void setSliderValue(double f) {
        int sliderValue = (int)f;

        if (sliderValue > max)
               sliderValue = max;
        if (sliderValue < 0)
            sliderValue = 0;
        sB.setValue(sliderValue);
        
    }
}
class ExmPanel extends Panel
                     implements ActionListener,
                                AdjustmentListener {
    TScore     controller;
    TextField  exT_ex, exT_pc;
    Scrollbar  sB_ex,  sB_pc;
    Label      sumL;
    int        max = 100;
    int        block = 1;
    int        show_pc, exam_ex, epc_ex;
    float      s_ex, f_ex, s_pc, f_pc;
    float      c_factor;

    // exam_type  0  Final
    //            1, 2, 3, 4 
    ExmPanel(TScore u,int exam_type,int exam_x,int show_epc,int epc_x,
             float a,float b,float w,float m,float n,float ex_default) {
        GridBagConstraints   c = new GridBagConstraints();
        GridBagLayout        gridbag = new GridBagLayout();
        setLayout(gridbag);
        Label  tL;
        float  exam_ratio, epc_ratio;
        float  sum;
        int    tmp_i;

        controller = u; 
        c_factor   = w;
        show_pc = show_epc;
        exam_ex = exam_x;
        epc_ex  = epc_x;
        s_ex = a; f_ex = b; s_pc = m; f_pc = n;
        //Set up default layout constraints.
        c.fill = GridBagConstraints.NONE;

        //Add the label.  It displays this panel's title, centered.
        if(exam_type == 0 ) { // Final exam
           tL = new Label("Final", Label.LEFT);
        } else {
           tL = new Label("Exam " + exam_type, Label.LEFT);
        }
        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(tL, c);
        add(tL);
        c.anchor = GridBagConstraints.CENTER;

        if( exam_x == 0 ) {
          // exam not extrapolated
	  if ((float)f_ex < 0.00000001) {
	      exam_ratio = (float) 0.0;
	  } else {
	      exam_ratio = (float)s_ex / (float)f_ex;
	  }
          tmp_i = (int) (10000 * exam_ratio );
          float percent = (float)tmp_i / (float)100.0;
          String cs =  " " + a + "/" + b + " = " + percent + " %";
          Label  cL = new Label(cs, Label.CENTER);
          c.gridwidth = 2;
          c.gridx = 1;
          c.gridy = 0;
          gridbag.setConstraints(cL, c);
          add(cL);
        } else {
          // extrapolate exam
          exam_ratio = ex_default;
          exT_ex = new TextField("0", 3);
          exT_ex.setName("EXAM");
          c.gridwidth = 1; //The default value.
          c.gridx = 2;
          c.gridy = 0;
          gridbag.setConstraints(exT_ex, c);
          add(exT_ex);
          exT_ex.addActionListener(this);

          sB_ex = new Scrollbar(Scrollbar.HORIZONTAL);
          sB_ex.setName("EXAMS");
          sB_ex.setMaximum(max + 10);
          sB_ex.setBlockIncrement(block);
          c.gridwidth = 2;
          c.gridx = 3;
          c.gridy = 0;
          gridbag.setConstraints(sB_ex, c);
          add(sB_ex);
          sB_ex.addAdjustmentListener(this);
        }
        epc_ratio = exam_ratio;
        if(show_pc == 1) {
          if(epc_x == 1) {
            epc_ratio = exam_ratio;
          } else {
            epc_ratio = (float)s_pc / (float)f_pc;
          }
          if( epc_ratio > exam_ratio ) {
            tmp_i= (int)(10000 * (exam_ratio + c_factor * (epc_ratio - exam_ratio)));
            sum  = (float)tmp_i / (float)100.0;
          } else {
            tmp_i= (int)(10000 * exam_ratio);
            sum  = (float)tmp_i / (float)100.0;
          }
        } else { 
          tmp_i= (int)(10000 * exam_ratio);
          sum  = (float)tmp_i / (float)100.0;
        }

        Label sL = new Label("subtotal=", Label.RIGHT);
        c.gridwidth = 1;
        c.gridx = 5;
        c.gridy = 0;
        gridbag.setConstraints(sL, c);
        add(sL);

        String  s = " " + sum + "%";
        sumL = new Label(s, Label.CENTER);
        c.anchor = GridBagConstraints.EAST; 
        c.gridwidth = GridBagConstraints.REMAINDER; //It ends a row.
        c.gridx = 6;
        c.gridy = 0;
        gridbag.setConstraints(sumL, c);
        add(sumL);
        c.anchor = GridBagConstraints.CENTER; 

        if( show_epc == 1 ) {
           Label eL = new Label("Correction " + exam_type, Label.LEFT);
           c.gridwidth = 1;
           c.gridx = 0;
           c.gridy = 1;
           gridbag.setConstraints(eL, c);
           add(eL);
           if( epc_x == 0 ) {
	     float ratio;
	     if ((float)f_pc < 0.00000001) {
		 ratio = (float) 0.0;
	     } else {
		 ratio = (float) ( s_pc / f_pc);
	     }
             tmp_i = (int) (10000 * ratio );
             float percent = (float)tmp_i / (float)100.0;
             String cs =  " " + s_pc + "/" + f_pc + " = " + percent + " %";
             Label  cL = new Label(cs, Label.CENTER);
             c.gridwidth = 2;
             c.gridx = 1;
             c.gridy = 1;
             gridbag.setConstraints(cL, c);
             add(cL);
           } else {
             exT_pc = new TextField("0", 3);
             exT_pc.setName("PC");
             c.anchor = GridBagConstraints.EAST;
             c.gridwidth = 1; //The default value.
             c.gridx = 2;
             c.gridy = 1;
             gridbag.setConstraints(exT_pc, c);
             add(exT_pc);
             exT_pc.addActionListener(this);

             sB_pc = new Scrollbar(Scrollbar.HORIZONTAL);
             sB_pc.setName("PCS");
             sB_pc.setMaximum(max + 10);
             sB_pc.setBlockIncrement(block);
             c.gridwidth = GridBagConstraints.REMAINDER;
             c.anchor = GridBagConstraints.CENTER;
             c.fill = GridBagConstraints.HORIZONTAL;
             // c.gridwidth = 2;
             c.gridx = 3;
             c.gridy = 1;
             gridbag.setConstraints(sB_pc, c);
             add(sB_pc);
             sB_pc.addAdjustmentListener(this);
           }
        }
        setExValue(exam_ratio,epc_ratio);
    }
    // Draws a box around this panel. 
    public void paint(Graphics g) {
        Dimension d = getSize();
        g.drawRect(0,0, d.width - 1, d.height - 1);
    }
    public Insets getInsets() {
        return new Insets(5,5,5,8);
    }
    float  getSubTotal() {
        String s_str = sumL.getText().replace('%','\0').trim();
        float  s_real = Float.valueOf(s_str).floatValue();
        return (s_real);
    }
    // entered into exT
    public void actionPerformed(ActionEvent e) {
        TextField source = (TextField)e.getSource();
        String name = source.getName();
        int tf = (int)Integer.valueOf(source.getText()).intValue();
        if (tf > max)
            tf = max;
        if (tf < 0)
            tf = 0;
        if( name.equals(String.valueOf("EXAM")) ) {
          sB_ex.setValue(tf);
          exT_ex.setText(String.valueOf((int)tf));
        } else {
          sB_pc.setValue(tf);
          exT_pc.setText(String.valueOf((int)tf));
        }
        recalcSumm();
    }    
    //  slider sB changed
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Scrollbar source = (Scrollbar)e.getSource();
        String    name = source.getName();
           int    my_i =  (int)source.getValue();
        
        if( name.equals(String.valueOf("EXAMS")) ) {
          sB_ex.setValue(my_i);
          exT_ex.setText(String.valueOf((int)my_i));
        } else {
          sB_pc.setValue(my_i);
          exT_pc.setText(String.valueOf((int)my_i));
        }
        recalcSumm();
    }
    void  recalcSumm() {
        int   tmp_i;
        float exam , epc, sum;
        
        if( exam_ex == 1 ) {
           tmp_i = (int)Integer.valueOf(exT_ex.getText()).intValue();
           exam = (float) tmp_i / (float)100.0;
        } else {
           exam = (float)s_ex / (float)f_ex;
        }
        if( show_pc == 1 ) {
          if(epc_ex == 1) {
            tmp_i = (int)Integer.valueOf(exT_pc.getText()).intValue();
            epc = (float) tmp_i / (float)100.0;
          } else {
            epc = (float)s_pc / (float)f_pc;
          }
          if( epc > exam ) {
            tmp_i= (int)(10000 * (exam + c_factor * (epc - exam)));
            sum  = (float)tmp_i / (float)100.0;
          } else {
            tmp_i= (int)(10000 * exam);
            sum  = (float)tmp_i / (float)100.0;
          }
        } else {
          tmp_i= (int)(10000 * exam);
          sum  = (float)tmp_i / (float)100.0;
        }
        sumL.setText(sum + "%");
        controller.recalcTermScore();
    }
    void setExValue (float a, float b) {
        int  exm, epc;
        exm = (int) (a*100.0); 
        epc = (int) (b*100.0); 
        if (exm > max)
            exm = max;
        if (exm < 0)
            exm = 0;
        if (epc > max)
            epc = max;
        if (epc < 0)
            epc = 0;
        if( exam_ex ==1 ) {
          sB_ex.setValue(exm);
          exT_ex.setText(String.valueOf(exm));
        }
        if( (show_pc == 1) && (epc_ex==1) ) {
          sB_pc.setValue(epc);
          exT_pc.setText(String.valueOf(epc));
        }
     }
}

