#!/bin/sh

# This program tests that the descriptives command actually works

TEMPDIR=/tmp/pspp-tst-$$

here=`pwd`;

# ensure that top_srcdir is absolute
cd $top_srcdir; top_srcdir=`pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH


cleanup()
{
     cd /
     rm -rf $TEMPDIR
}


fail()
{
    echo $activity
    echo FAILED
    cleanup;
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    cleanup;
    exit 2;
}

pass()
{
    cleanup;
    exit 0;
}

mkdir -p $TEMPDIR

cd $TEMPDIR

activity="create program"
cat > $TEMPDIR/descript.stat <<EOF
title 'Test DESCRIPTIVES procedure'.

data list / V0 to V16 1-17.
begin data.
12128989012389023
34128080123890128
56127781237893217
78127378123793112
90913781237892318
37978547878935789
52878237892378279
12377912789378932
26787654347894348
29137178947891888
end data.

descript all/stat=all/format=serial.

EOF
if [ $? -ne 0 ] ; then no_result ; fi


activity="run program"
$SUPERVISOR $here/../src/pspp -o raw-ascii $TEMPDIR/descript.stat
if [ $? -ne 0 ] ; then no_result ; fi

activity="compare output"
diff -B -b $TEMPDIR/pspp.list - <<EOF
1.1 DATA LIST.  Reading 1 record from the command file.
+--------+------+-------+------+
|Variable|Record|Columns|Format|
#========#======#=======#======#
|V0      |     1|  1-  1|F1.0  |
|V1      |     1|  2-  2|F1.0  |
|V2      |     1|  3-  3|F1.0  |
|V3      |     1|  4-  4|F1.0  |
|V4      |     1|  5-  5|F1.0  |
|V5      |     1|  6-  6|F1.0  |
|V6      |     1|  7-  7|F1.0  |
|V7      |     1|  8-  8|F1.0  |
|V8      |     1|  9-  9|F1.0  |
|V9      |     1| 10- 10|F1.0  |
|V10     |     1| 11- 11|F1.0  |
|V11     |     1| 12- 12|F1.0  |
|V12     |     1| 13- 13|F1.0  |
|V13     |     1| 14- 14|F1.0  |
|V14     |     1| 15- 15|F1.0  |
|V15     |     1| 16- 16|F1.0  |
|V16     |     1| 17- 17|F1.0  |
+--------+------+-------+------+

2.1 DESCRIPTIVES.  Valid cases = 10; cases with missing value(s) = 0.
+--------#-------+---------+-----+--------+-------+--------+--------+--------+--------+--------+-----+-------+-------+------+
|Variable#Valid N|Missing N| Mean|S E Mean|Std Dev|Variance|Kurtosis|S E Kurt|Skewness|S E Skew|Range|Minimum|Maximum|  Sum |
#========#=======#=========#=====#========#=======#========#========#========#========#========#=====#=======#=======#======#
|V0      #     10|        0|3.800|    .841|  2.658|   7.067|   -.035|   1.334|    .889|    .687|8.000|  1.000|  9.000|38.000|
|V1      #     10|        0|4.600|    .957|  3.026|   9.156|  -1.386|   1.334|   -.032|    .687|9.000|   .000|  9.000|46.000|
|V2      #     10|        0|4.100|   1.159|  3.665|  13.433|  -2.019|   1.334|    .476|    .687|8.000|  1.000|  9.000|41.000|
|V3      #     10|        0|4.100|    .875|  2.767|   7.656|  -2.049|   1.334|    .422|    .687|7.000|  1.000|  8.000|41.000|
|V4      #     10|        0|7.000|    .471|  1.491|   2.222|   7.152|   1.334|  -2.516|    .687|5.000|  3.000|  8.000|70.000|
|V5      #     10|        0|4.900|   1.027|  3.247|  10.544|  -1.401|   1.334|   -.205|    .687|9.000|   .000|  9.000|49.000|
|V6      #     10|        0|5.900|    .795|  2.514|   6.322|   -.290|   1.334|   -.960|    .687|7.000|  1.000|  8.000|59.000|
|V7      #     10|        0|4.700|   1.096|  3.466|  12.011|  -1.993|   1.334|   -.165|    .687|9.000|   .000|  9.000|47.000|
|V8      #     10|        0|4.100|   1.100|  3.479|  12.100|  -1.928|   1.334|    .371|    .687|9.000|   .000|  9.000|41.000|
|V9      #     10|        0|4.300|    .870|  2.751|   7.567|   -.875|   1.334|    .730|    .687|8.000|  1.000|  9.000|43.000|
|V10     #     10|        0|5.500|    .847|  2.677|   7.167|  -1.842|   1.334|   -.326|    .687|7.000|  2.000|  9.000|55.000|
|V11     #     10|        0|6.500|    .778|  2.461|   6.056|  -1.276|   1.334|   -.895|    .687|6.000|  3.000|  9.000|65.000|
|V12     #     10|        0|7.900|    .605|  1.912|   3.656|   5.241|   1.334|  -2.208|    .687|6.000|  3.000|  9.000|79.000|
|V13     #     10|        0|4.300|    .989|  3.129|   9.789|  -1.248|   1.334|    .333|    .687|9.000|   .000|  9.000|43.000|
|V14     #     10|        0|3.600|   1.013|  3.204|  10.267|   -.961|   1.334|    .809|    .687|9.000|   .000|  9.000|36.000|
|V15     #     10|        0|3.700|    .920|  2.908|   8.456|  -1.352|   1.334|    .710|    .687|7.000|  1.000|  8.000|37.000|
|V16     #     10|        0|6.400|    .909|  2.875|   8.267|  -1.142|   1.334|   -.923|    .687|7.000|  2.000|  9.000|64.000|
+--------#-------+---------+-----+--------+-------+--------+--------+--------+--------+--------+-----+-------+-------+------+
EOF
if [ $? -ne 0 ] ; then fail ; fi


pass
