//****************************************************************************//
//      Untabifier class:  
//
//      Derived Pretranslator to convert tabs to spaces before HTML generation
//
//      Don Stauffer Revision: June 2003
//****************************************************************************//
#ifndef	srcUntabifier_H
#define	srcUntabifier_H

#include	<string>

#include	"srcpretranslator.h"

using std::string;

class Untabifier : public Pretranslator
{
 public:

  Untabifier (int nSpacesPerTab):nSpacesPerTab_ (nSpacesPerTab), n_ (0)
    {
    }


  void generate (const string & s)
    {
      Pretranslator::generate (s.c_str ());
      n_ += s.size ();
    }


  void generate (const string & s, int start, int end)
    {
      Pretranslator::generate (s.c_str (), start, end);
      n_ += 1 + end - start;
    }


  void generateln (const string & s)
    {
      Pretranslator::generateln (s.c_str ());
      n_ = 0;
    }


  void generate_preproc (const string & s)
    {
      Pretranslator::generate_preproc (s.c_str ());
      n_ += s.size ();
    }


  void generate_normal (const string & s)
    {
      Pretranslator::generate_normal (s.c_str ());
      n_ += s.size ();
    }


  void generateTab (void)
    {
      int nSpaces = nSpacesPerTab_ - n_ % nSpacesPerTab_;
      for (int i = 0; i < nSpaces; i++)
	generate (SPACE_CHAR);
    }


  void startComment (const string & s)
    {
      Pretranslator::startComment (s.c_str ());
    }


  void endComment (const string & s)
    {
      Pretranslator::endComment (s.c_str ());
    }


  void generateComment (const string & s)
    {
      Pretranslator::generateComment (s.c_str ());
      n_ += s.size ();
    }


  void startString (const string & s)
    {
      Pretranslator::startString (s.c_str ());
    }


  void endString (const string & s)
    {
      Pretranslator::endString (s.c_str ());
    }


  void generateString (const string & s)
    {
      Pretranslator::generateString (s.c_str ());
      n_ += s.size ();
    }


  void generateKeyWord (const string & s)
    {
      Pretranslator::generateKeyWord (s.c_str ());
      n_ += s.size ();
    }


  void generateBaseType (const string & s)
    {
      Pretranslator::generateBaseType (s.c_str ());
      n_ += s.size ();
    }


  void generatePreProc (const string & s)
    {
      Pretranslator::generatePreProc (s.c_str ());
      n_ += s.size ();
    }


  void generateNumber (const string & s)
    {
      Pretranslator::generateNumber (s.c_str ());
      n_ += s.size ();
    }


  void generateSymbol (const string & s)
    {
      Pretranslator::generateSymbol (s.c_str ());
      n_ += s.size ();
    }


  void generateFunction (const string & s)
    {
      Pretranslator::generateFunction (s.c_str ());
      n_ += s.size ();
    }


  void generateCBracket (const string & s)
    {
      Pretranslator::generateCBracket (s.c_str ());
      n_ += s.size ();
    }


 private:

  const int nSpacesPerTab_;
  int n_;
  
};				//      class   Untabifier

#endif //      #ifndef srcUntabifier_H
