/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import mozilla_training_analyzer.MozillaSpamToken;
import mozilla_training_analyzer.TrainingData;

public class TrainingDataTableModel
extends AbstractTableModel
implements TableModelListener {
    private String[] colNames = new String[]{"Token", "Good", "Good %", "Bad", "Bad %"};
    private TrainingData parentTrainer = null;
    private MozillaSpamToken[] tokenSet = null;

    public TrainingDataTableModel(TrainingData trainingData) {
        this.setNewTrainingData(trainingData);
    }

    public TrainingData getTrainingData() {
        return this.parentTrainer;
    }

    public void setNewTrainingData(TrainingData trainingData) {
        if (trainingData == null) {
            return;
        }
        Object[] objectArray = trainingData.getTokenSet().toArray();
        this.tokenSet = new MozillaSpamToken[objectArray.length];
        for (int i = 0; i < this.tokenSet.length; ++i) {
            this.tokenSet[i] = (MozillaSpamToken)objectArray[i];
        }
        this.parentTrainer = trainingData;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public int getRowCount() {
        return this.tokenSet.length;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.tokenSet[n].getTokenString();
            }
            case 1: {
                return new Integer(this.tokenSet[n].getGoodTokenCount());
            }
            case 2: {
                float f = (float)this.tokenSet[n].getGoodTokenCount() / (float)this.parentTrainer.getGoodMessageCount();
                f *= 1.0E7f;
                f = (float)Math.ceil(f);
                return new Float(f /= 100000.0f);
            }
            case 3: {
                return new Integer(this.tokenSet[n].getBadTokenCount());
            }
            case 4: {
                float f = (float)this.tokenSet[n].getBadTokenCount() / (float)this.parentTrainer.getBadMessageCount();
                f *= 1.0E7f;
                f = (float)Math.ceil(f);
                return new Float(f /= 100000.0f);
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0 && n2 != 2 && n2 != 4;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void removeRows(int[] nArray) {
        if (nArray == null || nArray.length == 0 || nArray.length >= this.getRowCount()) {
            return;
        }
        int n = -1;
        int n2 = -1;
        n2 = nArray[0];
        n = nArray[nArray.length - 1];
        if (n2 > n) {
            n2 = n;
            n = nArray[0];
        }
        MozillaSpamToken[] mozillaSpamTokenArray = new MozillaSpamToken[this.tokenSet.length - (n - n2 + 1)];
        System.arraycopy(this.tokenSet, 0, mozillaSpamTokenArray, 0, n2);
        System.arraycopy(this.tokenSet, n + 1, mozillaSpamTokenArray, n2, this.tokenSet.length - n - 1);
        for (int i = 0; i < nArray.length; ++i) {
            this.parentTrainer.getTokenSet().remove(this.tokenSet[nArray[i]]);
        }
        this.tokenSet = mozillaSpamTokenArray;
        this.fireTableRowsDeleted(n2, n);
        this.fireTableDataChanged();
    }

    public void addRow(String string) {
        MozillaSpamToken mozillaSpamToken = new MozillaSpamToken(string, 0, 0);
        if (this.parentTrainer.getTokenSet().contains(mozillaSpamToken)) {
            JOptionPane.showMessageDialog(null, "The given token already exists in this set of tokens.");
            return;
        }
        MozillaSpamToken[] mozillaSpamTokenArray = new MozillaSpamToken[this.tokenSet.length + 1];
        System.arraycopy(this.tokenSet, 0, mozillaSpamTokenArray, 0, this.tokenSet.length);
        this.parentTrainer.getTokenSet().add(mozillaSpamToken);
        mozillaSpamTokenArray[mozillaSpamTokenArray.length - 1] = mozillaSpamToken;
        this.tokenSet = mozillaSpamTokenArray;
        this.fireTableRowsInserted(this.tokenSet.length - 1, this.tokenSet.length - 1);
        this.fireTableDataChanged();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 || n2 == 2 || n2 == 4) {
            return;
        }
        MozillaSpamToken mozillaSpamToken = this.parentTrainer.getTokenSet().tailSet(this.tokenSet[n]).first();
        if ((Integer)object < 0) {
            object = new Integer(0);
        }
        if (n2 == 1) {
            this.tokenSet[n].setGoodTokenCount((Integer)object);
            mozillaSpamToken.setGoodTokenCount((Integer)object);
        } else if (n2 == 3) {
            this.tokenSet[n].setBadTokenCount((Integer)object);
            mozillaSpamToken.setBadTokenCount((Integer)object);
        } else {
            System.err.println("TrainingDataTableModel.setValueAt(): WARNING -- Invalid column passed in: " + n2);
        }
        this.fireTableCellUpdated(n, n2);
        this.fireTableCellUpdated(n, n2 + 1);
    }
}

