/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

namespace LocaleInpector
{

internal sealed class POLocale
{

public static int Main()
{
    ConfigPo config = new ConfigPo();
    config.InitIni();

    int ret = MainCore();
    return ret;
}

private static int MainCore()
{
    string title = "PO Locale " + Config2.GetVersion();
    //System.Console.OutputEncoding = BPIO.UTF8;
    System.Console.Title = title;
    //System.Console.BackgroundColor = System.ConsoleColor.Blue;
    //System.Console.ForegroundColor = System.ConsoleColor.Gray;
    System.Console.Write(title);
    System.Console.Write(" - a converter tool for mozilla extensions localizers.");
    //System.Console.ResetColor();

    System.Console.WriteLine();

    // pot
    // [2] original (dir, xpi, jar)
    // [3] output.pot

    // po
    // [2] original (dir, xpi, jar)
    // [3] translated
    // [4] output.po

    // locale
    // [2] input.po
    // [3] original chrome (dir, xpi, jar)
    // [4] output.zip


    string input;
    string auxInput = null;
    string output;
    string[] arguments = System.Environment.GetCommandLineArgs();

    if (arguments.Length < 2) {
        return Config2.WriteHeader();
    }

    switch (arguments[1]) {
        case "pot":
            if (arguments.Length < 4) {
                return Config2.WriteHeader();
            }
            input  = arguments[2];
            output = arguments[3];
            break;
        case "po":
            if (arguments.Length < 5) {
                return Config2.WriteHeader();
            }
            input  = arguments[2];
            auxInput = arguments[3];
            output = arguments[4];
            break;
        case "locale":
            if (arguments.Length < 5) {
                return Config2.WriteHeader();
            }
            input = arguments[2];
            auxInput = arguments[3];
            output = arguments[4];
            break;
        default:
            return Config2.WriteHeader();
    }

    if (BPIO.Exists(output)) {
        System.Console.ForegroundColor = System.ConsoleColor.Red;
        System.Console.WriteLine("Cannot save {0}. A file with the name you specified already exists.", output);
        System.Console.ResetColor();
        return 1;
    }

    /*
    // expired version
    if (System.DateTime.Today > new System.DateTime(2005, 08, 20)) {
        System.Threading.Thread.Sleep(100000);
        return 1;
    }
    */

    switch (arguments[1]) {
        case "locale":
            PoToLocale.Save(input, output, auxInput);
            break;
        case "pot":
            LocaleToPo.Create(input, null, output);
            break;
        case "po":
            LocaleToPo.Create(input, auxInput, output);
            break;
        default:
            throw new System.InvalidOperationException();
    }

    return 0;
}

}//class
}//ns