/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.mozilla.xpcom.Debug;
import org.mozilla.xpcom.IID;
import org.mozilla.xpcom.Utilities;

class ProxyHandler
implements InvocationHandler {
    private long oid;
    private IID iid;
    private long orb;

    ProxyHandler(long l, IID iID, long l2) {
        this.oid = l;
        this.iid = iID;
        this.orb = l2;
        Utilities.callMethod(this.oid, null, this.iid, this.orb, null);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Debug.log("--[java]ProxyHandler.invoke " + method);
        String string = method.getName();
        if (string.equals("toString")) {
            return "ProxyObject@{oid = " + this.oid + " iid = " + this.iid + "}";
        }
        if (string.equals("clone")) {
            throw new CloneNotSupportedException();
        }
        if (string.equals("finalize")) {
            Utilities.callMethod(this.oid, method, this.iid, this.orb, objectArray);
            this.finalize();
        } else if (string.equals("equals")) {
            if (objectArray[0] instanceof ProxyHandler) {
                ProxyHandler proxyHandler = (ProxyHandler)objectArray[0];
                return new Boolean(this.oid == proxyHandler.oid && this.iid.equals(proxyHandler.iid) && this.orb == proxyHandler.orb);
            }
        } else {
            if (string.equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            return Utilities.callMethod(this.oid, method, this.iid, this.orb, objectArray);
        }
        return null;
    }

    long getOID() {
        return this.oid;
    }
}

