unit CommicsUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdAntiFreezeBase, IdAntiFreeze, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP, StdCtrls, ComCtrls, OleCtrls,
  SHDocVw, MOZILLACONTROLLib_TLB, PickUnit, IdException, Buttons, Inifiles, ShellAPI;

type
  TMainForm = class(TForm)
    IdHTTP: TIdHTTP;
    IdAntiFreeze1: TIdAntiFreeze;
    ButtonComics: TButton;
    ProgressBar: TProgressBar;
    MozillaBrowser: TMozillaBrowser;
    LabelDone: TLabel;
    ButtonManageComics: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    ButtonHelp: TButton;
    procedure ButtonComicsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonManageComicsClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonHelpClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses ManageUnit;

{$R *.dfm}
//The following function returns the position of a given string in another string,
//when the search needs to start at a specified position in the second string
function PosFromPos (const s1, s2: string;
                  pos, max: Integer): Integer;
// s1 = the string that must be found
// s2 = the string to search
// pos = start position
// max = maximum search length
var s, l1, l2, j: Integer;
begin
 Result:= -1;
 l1:= Length (s1);
 l2:= Length (s2);
 if max <= 0 then max:= l2; // maximum length
 // we can not search befor the first char
 if pos < 0 then pos:= 0;
 // maybe we're ready at all?
 if (l1 <= 0) or (pos > max) then Exit;
 for s:= pos to (max - l1) do begin
  for j:= 1 to l2 do begin
   if (s1[j] <> s2[s+j]) then BREAK; // Diffrence detectet
   // we have it found
   if (j = l1) then begin Result:= s; Exit; end;
  end;
 end;
end;

procedure TMainForm.ButtonComicsClick(Sender: TObject);
var comicsrc: TextFile;
    picks: tstrings;
    ini: TIniFile;
    ctr,prestartpos,startpos,endpos: integer;
    comicname,exepath,checkedList,comicwebsrc,imgsrc: string;
    comicurl,comicstartpoint,comicbeganch,comicendanch,comicimgurl: string;
begin
  progressbar.Max := 0;
  labeldone.Caption := ' ';
//loading the picks list from the dailycomics.ini file into a stringlist
  picks := tstringlist.Create;
  ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  checkedList :=  ini.ReadString('DailyComics','Picked','');

  if checkedList = '' then
  begin
    MessageDlg('You don''t have any comics in your pick list...click the upper right button',mtError,mbOKCancel,0);
    exit;
  end;

  for ctr := 1 to length(checkedList) do
  begin
    if checkedList[ctr] <> ',' then
    begin
      comicname := comicname+checkedList[ctr]
    end else
    begin
      picks.Add(comicname);
      comicname := '';
    end;
  end;
  picks.Add(comicname);

  progressbar.Max := picks.Count;
  exepath := ExtractFilePath(application.exename);
  DeleteFile(exepath+'comics.html');
  AssignFile(comicsrc,exepath+'comics.html');
  ReWrite(comicsrc);
  Writeln(comicsrc,'<html><body><center>');
  Writeln(comicsrc,'<strong><font size="+1">You can click on each comic to go to its website.</font></strong><p>');

  for ctr := 0 to (picks.Count - 1) do
  begin
    comicName := picks.Strings[ctr];
    comicURL := ini.ReadString(comicName,'URL','');
    comicStartPoint := ini.ReadString(comicName,'StartPoint','');
    comicBegAnch := ini.ReadString(comicName,'BegAnch','');
    comicEndAnch := ini.ReadString(comicName,'EndAnch','');
    comicImgURL := ini.ReadString(comicName,'ImgURL','');
    try
      comicwebsrc := idhttp.Get(comicURL);
    except
      on EIDSocketError do comicwebsrc := 'failed';
      on EInOutError do comicwebsrc := 'failed';
      on EIDHTTPProtocolException do comicwebsrc := 'failed';
    end;
    if comicwebsrc <> 'failed' then
    begin
      ProgressBar.StepIt;
      if comicStartPoint <> '' then
      begin
        prestartpos := Pos(comicStartPoint,comicwebsrc);
        startpos := PosFromPos(comicBegAnch,comicwebsrc,prestartpos,length(comicwebsrc));
        endpos := PosFromPos(comicEndAnch,comicwebsrc,startpos,length(comicwebsrc));
      end else
      begin
        startpos := Pos(comicBegAnch,comicwebsrc);
        endpos := PosFromPos(comicEndAnch,comicwebsrc,startpos,length(comicwebsrc));
      end;
      imgsrc := copy(comicwebsrc,startpos,(endPos+4)-startpos);
      comicwebsrc := '<img src="'+comicImgURL+imgsrc+'">';
      Writeln(comicsrc,'<strong>'+comicName+'</strong>');
      Writeln(comicsrc,'<br>');
      Writeln(comicsrc,'<a href="'+comicURL+'">');
      Writeln(comicsrc,comicwebsrc);
      Writeln(comicsrc,'</a>');
      Writeln(comicsrc,'<p>');
      Writeln(comicsrc,'<hr width="500">');
      Writeln(comicsrc,'<p>');
    end else
    begin
      MessageDlg('Sorry '+comicName+' is unavailable, skipping it for today', mtError, [mbOK], 0);
      ProgressBar.Max := ProgressBar.Max-1;
    end;
  end;
  picks.Free;
  ini.Free;
  LabelDone.caption := 'Done. Comics will appear below.';
  Writeln(comicsrc,'</center></body></html>');
  flush(comicsrc);
  CloseFile(comicsrc);
  MozillaBrowser.Navigate(exepath+'comics.html');
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  try
    Top := Ini.ReadInteger('Form','Top',100);
    Left := Ini.ReadInteger('Form','Left',100);
    Width := Ini.ReadInteger('Form','Width',757);
    Height := Ini.ReadInteger('Form','Height',642);
    if Ini.ReadBool( 'Form', 'InitMax', false ) then
      WindowState := wsMaximized
    else
      WindowState := wsNormal;
  finally
    Ini.Free;
  end;
  MainForm.Caption := MainForm.Caption + datetostr(date);
end;

procedure TMainForm.ButtonManageComicsClick(Sender: TObject);
begin
  FormManageComics.ShowModal;
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
  MozillaBrowser.GoBack;
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
 MozillaBrowser.GoForward;
end;

procedure TMainForm.BitBtn3Click(Sender: TObject);
begin
  MozillaBrowser.Stop;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  try
    Ini.WriteInteger('Form','Top',Top);
    Ini.WriteInteger('Form','Left',Left);
    Ini.WriteInteger('Form','Width',Width);
    Ini.WriteInteger('Form','Height',Height);
    Ini.WriteInteger('Form','MozWidth',MozillaBrowser.Width);
    Ini.WriteInteger('Form','MozHeight',MozillaBrowser.Height);
    Ini.WriteBool('Form','InitMax',WindowState = wsMaximized);
  finally
    Ini.Free;
  end;
end;

procedure TMainForm.ButtonHelpClick(Sender: TObject);
var exepath: string;
begin
  exepath := ExtractFilePath(application.exename);
  ShellExecute(MainForm.Handle, 'Open', PChar(exepath+'Help\Help.html'), nil, nil, SW_SHOW);
end;

procedure TMainForm.FormActivate(Sender: TObject);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  MozillaBrowser.Width := Ini.ReadInteger('Form','MozWidth',733);
  MozillaBrowser.Height := Ini.ReadInteger('Form','MozHeight',527);
  Ini.Free;
end;

end.
