<%
' FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
'  Author: Duong Thanh An - technical@anisolution.com (core)
'  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
'	
'  Copyright (C) 2004 Anisolution.com
'
'  This program is free software; you can redistribute it and/or modify
'  it under the terms of the GNU General Public License as published by
'  the Free Software Foundation; either version 2 of the License, or
'  (at your option) any later version.
'
'  This program is distributed in the hope that it will be useful,
'  but WITHOUT ANY WARRANTY; without even the implied warranty of
'  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'  GNU General Public License for more details.
'
'  You should have received a copy of the GNU General Public License
'  along with this program; if not, write to the Free Software
'  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
'
'  Anisolution.com
'  http://www.anisolution.com
'  HCMC Vietnam
'  info@anisolution.com
'
'		
'	 Copyright notice:
'	 XUL File Manager is freeware with open source code. 
'	 As long as you keep the copyright message, you can 
'	 play with the code for your own purposes but you can
'	 not distribute the altered version. You can not sell 
'	 XUL File Manager or use it for commercial purposes.
'	 Please contact us for commercial uses.
'
'	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
'


function mapPath(s) 
	dim root
	dim t
	if left(s, 1) <> "/" and left(s, 1) <> "\" then
		root = server.mapPath(".")
		t = s
	else
		root = server.mapPath("/")
		t = right(s, len(s) - 1)
	end if
	do while true
		dim i : i = instr(t, "/")
		if i <= 0 then i = instr(t, "\")

		if i <= 0 then 
			if t <> "" then root = root & "\" & t
			exit do
		end if
		dim f : f = left(t, i - 1)
		if f = ".." then
			dim j : j = inStrRev(root, "\")
			if j <= 0 then j = inStrRev(root, "/")
			if j > 0 then
				root = left(root, j - 1)
			end if
		elseif f <> "." then
			root = root & "\" & f
		end if
		t = right(t, len(t) - i)
	loop
	
	mapPath = root

end function

'this function does not support parent ref (../)
function unMapPath(s)
	dim root : root = mapPath(ROOT_PATH & "/")
	if left(s, len(root)) = root then
		dim t : t = right(s, len(s) - len(root))
		t = replace(t, "\", "/")
		unMapPath = t
	else
		unMapPath = s
	end if
end function

	function unicodeXmlEncode(input)
		if "" & input = "" then
			unicodeXmlEncode = ""
			exit function
		end if




'--------------
		unicodeXmlEncode = server.htmlEncode(input)
		exit function
'--------------


		dim re : set re = new RegExp
		re.global = true
		re.ignoreCase = true

		dim s : s = input

		re.pattern = "&([^#])"	'ignoring the case of &#xxxx; <-- unicode char entity ref.
		s = re.replace(s, "&amp;$1")

		s = replace(s, "<", "&lt;")
		s = replace(s, ">", "&gt;")
		s = replace(s, """", "&quot;")
		's = replace(s, vbNewLine, "<br>")

		unicodeXmlEncode = s
	end function
	function getSep() 
		if MODE = "VIRTUAL" then
			getSep = "/"
		else
			getSep = "\"
		end if
	end function
	function getRootPath()
		dim prefix : prefix = ROOT_PATH
		if right(prefix, 1) = getSep() then
			prefix = left(prefix, len(prefix) - 1)
		end if
		getRootPath = prefix
	end function
	function getRequestPath() 
		dim path : path = trim("" & request(P_PATH))
		if path = "" then path = getSep()
		if left(path, 1) <> getSep then path = getSep() & path
		if right(path, 1) <> getSep then path = path & getSep()
		getRequestPath = getRootPath & path
	end function
	function getRealPath(path)
		dim p : p = path
		if MODE = "VIRTUAL" then
			p = mapPath(path)
		end if
		if right(p, 1) <> getSep then p = p & getSep()
		getRealPath = p
	end function

	function getOrignialRealPath1() 
		getOrignialRealPath1 = getOrignialRealPathImpl(P_PATH1)
	end function

	function getOrignialRealPath2() 
		getOrignialRealPath2 = getOrignialRealPathImpl(P_PATH2)
	end function

	function getOrignialRealPath() 
		getOrignialRealPath = getOrignialRealPathImpl(P_PATH)
	end function

	function getOrignialRealPathImpl(name) 
		dim p : p = trim("" & request(name))
		dim a : a = split(p, vblf)
		dim i
		for i = 0 to ubound(a)
			if MODE = "VIRTUAL" then
				a(i) = mapPath(getRootPath & a(i))
			end if
		next
		getOrignialRealPathImpl = join(a, vbNewLine)
	end function

	function getVersionString() 
		getVersionString = trim(APPLICATION_NAME & " " & VERSION_MAJOR & "." & VERSION_MINNOR & " " & VERSION_TAG)
	end function
	function getAbsolutePath(virtualPath)
		dim s : s = ""

		'proto
		if uCase(request.serverVariables("HTTPS")) = "ON" then
			s = s & "https://"
		else
			s = s & "http://"
		end if

		s = s & request.serverVariables("SERVER_NAME")
		
		dim port : port = trim("" & request.serverVariables("SERVER_PORT"))
		if port <> "80" then
			s = s & ":" & port
		end if

		if virtualPath = "" then
			s = s & request.serverVariables("PATH_INFO")
		elseif left(virtualPath, 1) = "/" then
			s = s & virtualPath
		else
			dim pathInfo : pathInfo = request.serverVariables("PATH_INFO")
			dim i : i = inStrRev(pathInfo, "/")
			pathInfo = left(pathInfo, i)
			s = s & pathInfo & virtualPath
		end if
		getAbsolutePath = s
	end function

	function formatDate(d)
		formatDate = year(d) & "_" & month(d) & "_" & day(d) & "_" & hour(d) & "_" & minute(d) & "_" & second(d)
	end function

%>