/*$Id: add2list.js,v 1.4 2008/04/01 21:26:11 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var action, rule;
var parent; 
var url, domain, directory;

function escape(url)
{
	url = url.replace(/\\/g, '\\\\');
	url = url.replace(/\./g, '\\.');
	url = url.replace(/\+/g, '\\+');
	url = url.replace(/\?/g, '\\?');
	url = url.replace(/\{/g, '\\{');
	url = url.replace(/\}/g, '\\}');
	url = url.replace(/\(/g, '\\(');
	url = url.replace(/\)/g, '\\)');
	url = url.replace(/\^/g, '\\^');
	url = url.replace(/\$/g, '\\$');
	url = url.replace(/\|/g, '\\|');
	url = url.replace(/\[/g, '\\[');
	url = url.replace(/\]/g, '\\]');	
	return url;
}

function escapeURL(url)
{
	url = escape(url);
	return url.replace(/\*/g, '\\*');
}

function escapeCustomURL(url)
{
	url = escape(url);
	//url.replace(/([^\\])\*/g, '$1.*');
	return url.replace(/\*/g, '.*');
}

function longestContent(url)
{
	var res;
	var maxlen = 0;
	var parts = url.split(/\*/);
	if (!parts)
		return null;
	res = parts[0];
	maxlen = res.length - "http://".length;
	for (i = 1; i< parts.length; i++){
		var p = parts[i];
		if (p.length > maxlen){
			maxlen = p.length;
			res = p;
		}
	}	
	return res;
}

function getDirectory(url)
{
	var idx = url.lastIndexOf("/");
	return url.slice(0, idx + 1);
}

function getDomain(url)
{
	var sep = url.indexOf("://");
	var idx;
	if (sep ==  -1)
		idx = 0;
	else
		idx = url.indexOf("/", sep + 3);
	return url.slice(0, idx + 1);
}

function add2listInit()
{
	action = window.arguments[0];
	url =  window.arguments[1];
	rule = window.arguments[2];
	parent = window.arguments[3];
	    
	document.title = action + " URL";
	var txt = document.getElementById('hint').getAttribute('value');	
	document.getElementById('hint').setAttribute('value', txt + " " + action);	
	document.getElementById('file-url').setAttribute('value', url);

	directory = getDirectory(url)
	document.getElementById('directory-url').setAttribute('value',  directory + "*");

	domain = getDomain(url);
	document.getElementById('domain-url').setAttribute('value', domain + "*" );
	
	document.getElementById('custom-url').setAttribute('value', url);
}

function createOptions(reg, content)
{
	var reason = "Broken rule. ";
	reg =  "/^" + reg +"$/i";	
	
	if (rule.msg)
		reason += rule.msg + " ";
	if (rule.fid)
		reason += "fid: " + rule.fid + " ";
	if (rule.rev)
		reason += "rev: " + rule.rev + " ";
        var options =  "msg:\"" + reason + "\"; ";
	if (content)
		options += "url_content:\"" + content + "\"; ";
	options += "url_re:\"" + reg +"\"; ";
	return options;
}

function add2list()
{
	var content, reg;
	if (document.getElementById('file').selected){
		content = url;
		reg = escapeURL(url);
	}
	else if (document.getElementById('directory').selected){
		content = directory;
		reg = escapeURL(directory);
		reg = reg + ".*";
	}
	else if (document.getElementById('domain').selected){
		content = domain;
		reg = escapeURL(domain);
		reg = reg + ".*";
	}
	else if (document.getElementById('custom').selected){
		reg = document.getElementById('custom-url').value
		content = longestContent(reg);
		reg = escapeCustomURL(reg);
	}

	var options = createOptions(reg, content);
	//alert(options);
	
	if (action == "whitelist") {
	    parent.whitelist(options);
	}else
	    parent.blacklist(options);
	return true;
}

function selectCustom()
{
	document.getElementById('add2list-radiogroup').selectedItem = document.getElementById('custom');
}
