/*$Id: fkRequestExaminator.h,v 1.2 2008/05/18 10:29:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2008 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKREQUESTEXAMINATOR_H
#define FKREQUESTEXAMINATOR_H

#include "nsCOMPtr.h"
#include "nsISupports.h"
#include "fkSentence.h"
#include "ActiveRuleSet.h"

class fkRequestExaminator {
 public:
	fkRequestExaminator();
	virtual ~fkRequestExaminator();
	NS_IMETHODIMP Init();
	
	const fkSentence* CheckUrl(const char *url);
	const fkSentence* CheckHeaders(const char *headers, PRUint32 headers_len); 
	const fkSentence* CheckBodyFragment(const char *body, PRUint32 body_len, 
					    PRUint32 body_offset);
	const fkSentence* GetSentence();
	
 private:
	const fkSentence* CheckMatch(list<const Rule *> match);
	inline const fkSentence* Block() {
	    TRACE("blocking request");
	    sentence->SetAction(sentence->BLOCK);
	    return sentence;
	}

	inline const fkSentence* Whitelist() {
	    TRACE("whitelisting request");
	    sentence->SetAction(sentence->DONT_AUDIT);
	    return sentence;
	}
	
	ActiveRuleSet connRules;
	fkSentence *sentence;
	nsCOMPtr<fkISentence> sentence_external;
	char* url;
	const char* headers;
	PRUint32 headers_len;
	const char* body;
	PRUint32 body_len;
	PRUint32 body_offset;
};

#endif
