/*$Id: Rule.h,v 1.8 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULE_H
#define RULE_H

#include "Common.h"

class Rule;

struct reference{
	char *system;
	char *ruleId;
};

struct RE{
	pcre *re_compiled;
	pcre_extra *re_extra; 
	char *pattern;
};

struct PatternMatchData{
	unsigned char *pattern_buf;
	int nocase;
	unsigned int pattern_size;
	Rule *parent;
};

class Rule
{
	/*encapsulation rules ;) */
 public:
	int actionID;
	char *action;
	char *msg;
	list<RE> urlREs;
	list<RE> headersREs;
	list<RE> bodyREs;	
	list<reference> references;

	list<PatternMatchData> url_content;
	list<PatternMatchData> headers_content;
	list<PatternMatchData> body_content;
	
	int fid;
	int rev;
	Rule();
	~Rule();
	void reset();
	void init();
	
	bool urlRule() const;
	bool headersRule() const;
	bool bodyRule() const;
};

#endif
